/*
** RasterLayout
**
**	This module must build up the Display version of the
**	raster image, creating the XImage structure. This should be
**	called whenever the content, image dimensions or anything
**	affecting the presentation changes.
**
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/RasterP.h>

#include "RasterLayout.h"
#include "ImageTools.h"

void XeRasterLayout(w)
XeRasterWidget w;
    {
	XImage *image;
	XeRawImage *raw = w->raster.raw_image;
	XeImageChannel data[4];
	int i, pixel_size;

	_XeDestroyImage((XeBasicWidget)w, w->raster.dsp_image);
	w->raster.dsp_image = NULL;
	w->raster.done = True;	/* Consider done, whether errors or not */
	if (raw == NULL)
		return;		/* Nothing to layout */
	w->raster.dsp_image = _XeCreateImage
		((XeBasicWidget)w, w->raster.raw_image,
		 w->raster.dither, w->raster.color_quantize,
		 w->raster.clip_width > 0 ? w->raster.clip_width :
		 w->raster.raster_width,
		 w->raster.clip_height > 0 ? w->raster.clip_height :
		 w->raster.raster_height);
	if (w->raster.dsp_image == NULL ||
	    (image = w->raster.dsp_image->image) == NULL)
		return;
	data[0].addr = (unsigned char *)image->data;
	data[0].w = image->width;
	data[0].h = image->height;
	data[0].line = image->bytes_per_line;
	data[0].inc = (image->bits_per_pixel + 7) / 8;
	pixel_size = raw->bits_per_component * raw->samples_per_pixel;
	for (i = 1; i <= raw->num_channels && i < XtNumber(data); i++)
	    {
		XeImageChannel channel;
		int cx, cy, cw, ch;

		channel = raw->channel[i-1];
		/*
		** Perform CLIP computations. Because channels may have
		** different dimensions, clip parameters must first
		** be converted from raster coordinates to channel specific
		** values (cx, cy, cw, ch).
		*/
		cx = (w->raster.clip_x * channel.w) / raw->width;
		if (cx < 0)
			cx = 0;
		cy = (w->raster.clip_y * channel.h) / raw->height;
		if (cy < 0)
			cy = 0;
		cw = (w->raster.clip_width * channel.w) / raw->width;
		if (cw <= 0)
			cw = channel.w;
		if (cw > channel.w - cx)
			cw = channel.w - cx;
		ch = (w->raster.clip_height * channel.h) / raw->height;
		if (ch <= 0)
			ch = channel.h;
		if (ch > channel.h - cy)
			ch = channel.h - cy;
		channel.addr += cy * channel.line + cx * channel.inc;
		channel.w = cw;
		channel.h = ch;
		/*
		** Rotation/mirror work only for >=8 bit channels
		*/
		if (pixel_size < 8)
			data[i] = channel;
		else
			_XeMirrorRotation(w->basic.rotation,
					  w->basic.mirror_image,
					  &channel,  &data[i]);
	    }
	_XeBuildImage((XeBasicWidget)w, w->raster.dsp_image, i, data);
    }






