/*
** Very Simple Xew Widget Demonstration Program
** (Using porthhole and panner, logic copied from editres program if
**  X11R5 is defined, and viewport otherwise)
*/

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#if X11R5
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#else
#include <X11/Xaw/Viewport.h>
#endif
#include <X11/Xew/Basic.h>
#include <X11/Xew/Raster.h>
#include <X11/Xew/Text.h>
#include <X11/Xew/Audio.h>
#include <X11/Xew/Video.h>
#include <X11/Xew/Frame.h>
#include <X11/Xew/Support.h>

#include "ui_tools.h"

static Widget lookingat = None, main_window;

#include "text_panel.c"
#include "video_panel.c"
#include "image_panel.c"


/*
** RemovePanelTarget
**	a callback function that removes the Widget from the panel
**	target.
*/
static void RemovePanelTarget(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	UI_PanelDef *panel = (UI_PanelDef *)client_data;

	if (panel && panel->target == w)
		panel->target = None;
    }

/*
** ChangePanelTarget
**	Change the target widget of a panel. Primarily, this function
**	adds a Destroy Callback to the widget for removing the reference
**	from the panel, if widget gets destroyed.
*/
static void ChangePanelTarget(w, panel)
Widget w;
UI_PanelDef *panel;
    {
	if (panel->target)
		XtRemoveCallback(panel->target, XtNdestroyCallback,
				 RemovePanelTarget, (XtPointer)panel);
	if ((panel->target = w) != 0)
		XtAddCallback(w, XtNdestroyCallback, RemovePanelTarget,
			      (XtPointer)panel);
    }

/*
** Notify_MENU
**	Popup a menu panel associated with the widget
*/
static void Notify_MENU(w, data)
Widget w;
XtPointer data;
    {
	UI_PanelDef *panel = (UI_PanelDef *)data;

	if (panel)
	    {
		ChangePanelTarget(w, panel);
		UI_SetToggles(panel);
		UI_PopupPanel(w, (XtPointer)panel, (XtPointer)NULL);
	    }
    }

/*
** Sample Notify skeleton..
*/
static void Notify(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeNotifyCallbackData *notify = (XeNotifyCallbackData *)call_data;
	int i;

	switch (notify->reason)
	    {
	    case XeCR_NOTIFY:
		/* Quickhack: just assume it's a button event! */
		for (i = 0; i < notify->num_params; i++)
		    {
			if (strcmp("MENU", notify->params[i]) == 0)
				Notify_MENU(w, client_data);
		    }
		break;
	    default:
		printf("UNKNOWN: XeRC=%d\n");
		break;
	    }
    }

/*
** Sample Expose callback
*/
static void Redisplay(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeExposeCallbackData *expose = (XeExposeCallbackData *)call_data;
    }

#if X11R5

void PortholeCallback(w, panner_ptr, report_ptr)
Widget w;
XtPointer panner_ptr, report_ptr;
    {
	Arg args[10];
	Cardinal n = 0;
	XawPannerReport *report = (XawPannerReport *)report_ptr;
	Widget panner = (Widget)panner_ptr;

	XtSetArg(args[n], XtNsliderX, report->slider_x); n++;
	XtSetArg(args[n], XtNsliderY, report->slider_y); n++;
	if (report->changed != (XawPRSliderX | XawPRSliderY))
	    {
		XtSetArg(args[n], XtNsliderWidth, report->slider_width); n++;
		XtSetArg(args[n], XtNsliderHeight, report->slider_height); n++;
		XtSetArg(args[n], XtNcanvasWidth, report->canvas_width); n++;
		XtSetArg(args[n], XtNcanvasHeight, report->canvas_height); n++;
	    }
	XtSetValues (panner, args, n);
    }

void PannerCallback(w, closure, report_ptr)
Widget w;
XtPointer closure, report_ptr;
    {
	Arg args[2];
	XawPannerReport *report = (XawPannerReport *)report_ptr;

	if (lookingat == None) 
		return;
	XtSetArg (args[0], XtNx, -report->slider_x);
	XtSetArg (args[1], XtNy, -report->slider_y);
	XtSetValues(lookingat, args, 2);
    }

#endif

static void AddContent();

static char *source_file;

static void  PopdownFileDialog(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	char *filename;
	UI_PanelDef *panel = (UI_PanelDef *)client_data;

	if (panel && UI_GetStrings(panel, &filename, 1) == 1 && filename)
	    {
		if (source_file)
			free((void *)source_file);
		source_file = filename;
		AddContent(lookingat, source_file);
	    }
	UI_Popdown(w, client_data, call_data);
    }

extern UI_PanelDef popup_dialog_loadfile;

static UI_ElementDef file_name_input[] =
    {
	UI_INPUT("Name: "),
	UI_END(),
    };
static UI_ActionDef loadfile_actions[] =
    {
	{"load", PopdownFileDialog, (XtPointer)&popup_dialog_loadfile},
	{"cancel"},
	{NULL},
    };
UI_PanelDef popup_dialog_loadfile =
    {
	"dialogPanel",
	file_name_input,
	loadfile_actions,
	"Load File",
    };

static UI_MenuItemDef file_menu_items[] =
    {
	{"Load File",	UI_PopupPanel,	(XtPointer)&popup_dialog_loadfile,},
	{"Quit",	UI_Quit,	NULL},
	{NULL},
    };

static UI_MenuDef file_menu =
    {
	"File",
	file_menu_items,
    };

/*
** AddContent
*/
static void AddContent(parent, name)
Widget parent;
char *name;
    {
	XeContentFormat type;
	Arg args[10];
	int n, i;
	Widget widget;
	UI_PanelDef *resources = NULL;

	n = 0;
	if (name && name[0] == '|')
	    {
		XtSetArg(args[n], XtNcontentFile, NULL); ++n;
		XtSetArg(args[n], XtNcontentFilter, name+1); ++n;
		type = XeContentFormat_UNKNOWN;
	    }
	else
	    {
		XtSetArg(args[n], XtNcontentFilter, NULL); ++n;
		XtSetArg(args[n], XtNcontentFile, name); ++n;
		type = XeFindContentFormat(name);
	    }
	XtSetArg(args[n], XtNcontentFormat, type); ++n;
	switch (XeFindContentClass(type))
	    {
	    default:
		printf("Assuming Text content type\n");
		/*
		** Request proportional spacing, because we are not
		** specifying the lineSpacing.
		*/
		XtSetArg(args[n], XtNproportional, True); ++n;
		widget = XtCreateManagedWidget
			(name,xeTextWidgetClass,parent,args,n);
		resources = &text_resources;
		break;
	    case XeContentClass_AUDIO:
		widget = XtCreateManagedWidget
			(name,xeAudioWidgetClass,parent,args,n);
		break;
	    case XeContentClass_VIDEO:
		widget = XtCreateManagedWidget
			(name,xeVideoWidgetClass,parent,args,n);
		resources = &video_resources;
		break;
	    case XeContentClass_RASTER:
		widget = XtCreateManagedWidget
			(name,xeRasterWidgetClass, parent,args,n);
		resources = &image_resources;
		break;
	    }
	if (resources)
		XtAddCallback(widget, XtNnotifyCallback, Notify,
			      (XtPointer)resources);
	XtAddCallback(widget,XtNexposeCallback,Redisplay,(XtPointer)NULL);
    }

static void WarningHandler(message)
String message;
    {
	static UI_PanelDef warning = {"Warning"};

	warning.heading = message;
	UI_PopupPanel(main_window, (XtPointer)&warning, (XtPointer)NULL);
    }

#include "fallback.c"

main(argc, argv)
int argc; char *argv[];
    {
	XtAppContext demo_application;
	Widget root_widget, porthole, panner, pane, box, button;
	Arg args[10];
	int n, i;

	root_widget = XtAppInitialize
		(&demo_application, "XewViewer", NULL,0, &argc, argv,
		 fallback_resources,
		 NULL, 0);
	UI_Initialize(demo_application);
	n = 0;
	XtSetArg(args[n], XtNlayoutPath, 270); ++n;
	main_window = pane = XtCreateManagedWidget
		("mainWindow", xeFrameWidgetClass, root_widget, args, n);
	n = 0;
	XtSetArg(args[n], XtNlayoutPath, 0); ++n;
	box = XtCreateManagedWidget
		("menuPanel", xeFrameWidgetClass, pane, args, n);
	UI_CreateMenu(box, &file_menu);

#if X11R5
	/*
	** Use Porthole/Panner if X11R5 available
	*/
	n = 0;
	panner = XtCreateManagedWidget
		("panner", pannerWidgetClass, box, args, n);
	n = 0;
	porthole = XtCreateManagedWidget
		("workArea", portholeWidgetClass, pane, args, n);
	XtAddCallback(porthole, XtNreportCallback,
		      PortholeCallback, (XtPointer)panner);
	XtAddCallback(panner, XtNreportCallback,
		      PannerCallback, (XtPointer)porthole);
#else
	/*
	** Use plain old viewport if X11R4
	*/
	n = 0;
	XtSetArg(args[n], XtNallowHoriz, True); ++n;
	XtSetArg(args[n], XtNallowVert, True); ++n;
	porthole = XtCreateManagedWidget("workArea", viewportWidgetClass,
				     pane,args, n);
#endif
	if (argc < 2)
	    {
		printf("usage: viewer files(s)\n");
		exit(0);
	    }
	XtAppSetWarningHandler(demo_application, WarningHandler);
	n = 0;
	lookingat = XtCreateManagedWidget
		("workArea", xeFrameWidgetClass, porthole, args, n);
	for (i = 1; i  < argc; i++)
		AddContent(lookingat, argv[i]);
	XtRealizeWidget(root_widget);
	XtAppMainLoop(demo_application);
	return 0;
    }


