#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <X11/Xproto.h>
#include "printer.h"

char                    hexchars[] = "0123456789abcdef";

/* print an image to a file in hex format according to postscript format by
   changing the colormap to greyscale */

void
printImageGrey (unsigned char *image,
                int x,
                int y,
                int width,
                int height,
                int depth,
                XColor *colors,
                int numColors,
                FILE * fp,
                int indexSupport)
{
  unsigned char           val,
                         *imageEnd;
  char                   *printrow,
                         *printptr;
  int                     i,
                          pixel,
                          bytes_per_line, byte_width,
                          indexVec[NUM_COLORS];
  XColor                 *resColor;

  if (depth > 8)
  {
    fprintf (stderr, "depth %d not supported in image operator\n", depth);
    return;
  }
  bytes_per_line = (depth * width + 31) / 32 * 4; /* scanline pad is 32 */
  imageEnd = image + bytes_per_line * height;
  byte_width = (depth * width + 7) / 8;

  if (indexSupport)
  {
    printrow = (char *) malloc (width * 2);

/* create an indexed color space for displaying the image */

    fprintf (fp, "[/Indexed /DeviceRGB %d\n", numColors - 1);
    fprintf (fp, "<\n");
    for (i = 0; i < numColors; i++)
    {
      val = colors[i].red >> 8;
      fprintf (fp, "%x", (val & 0xf0) >> 4);
      fprintf (fp, "%x", val & 0xf);
      val = colors[i].green >> 8;
      fprintf (fp, "%x", (val & 0xf0) >> 4);
      fprintf (fp, "%x", val & 0xf);
      val = colors[i].blue >> 8;
      fprintf (fp, "%x", (val & 0xf0) >> 4);
      fprintf (fp, "%x", val & 0xf);
      fprintf (fp, "\n");
    }
    fprintf (fp, "> ] setcolorspace\n");

/* print the image dictionary */

    fprintf (fp, "/picstr %d string def\n", width);
    fprintf (fp, "<<\n");
    fprintf (fp, "/ImageType 1\n");
    fprintf (fp, "/Width %d /Height %d\n", width, height);
    fprintf (fp, "/BitsPerComponent %d\n", depth);
    fprintf (fp, "/Decode [0 255]\n");
    fprintf (fp, "/ImageMatrix [ 1 0 0 1 %d %d]\n", -x, -y);
    fprintf (fp, "/DataSource { currentfile picstr readhexstring pop }\n");
    fprintf (fp, ">>\n");
    fprintf (fp, "image\n");
    while (image < imageEnd)
    {
      printptr = printrow;

/* translate the image pixels to hex characters and print the row in a 
   single shot */
      for (i = 0; i < byte_width; ++i)
      {
        val = image[i];
        *printptr++ = hexchars[(val & 0xf0) >> 4];
        *printptr++ = hexchars[val & 0xf];
      }
      image += bytes_per_line;
      fwrite (printrow, 1, byte_width * 2, fp);
      fprintf (fp, "\n");
    }
    free (printrow);
  }
  else if (depth == 8)
  {
    printrow = (char *) malloc (width * 6);

/* create an index vector of the colors */

    for (i = 0; i < NUM_COLORS; i++)
    {
      indexVec[i] = 0;
    }
    for (i = 0; i < numColors; i++)
    {
      if (colors[i].pixel < NUM_COLORS)
      {
        indexVec[colors[i].pixel] = i;
      }
    }

/* image header..presumes we have defined imagedraw function. y translation
   negative as inverse of moveto */

    fprintf (fp, "%d %d %d [ 1 0 0 1 %d %d] imagedraw\n",
             width, height, depth, -x, -y);
    while (image < imageEnd)
    {

/* get the print pixel corresponding to the image pixel */

      printptr = printrow;
      for (i = 0; i < width; ++i)
      {
        pixel = image[i];
        resColor = &(colors[indexVec[pixel]]);
        val = resColor->red >> 8;
        *printptr++ = hexchars[(val & 0xf0) >> 4];
        *printptr++ = hexchars[val & 0xf];
        val = resColor->green >> 8;
        *printptr++ = hexchars[(val & 0xf0) >> 4];
        *printptr++ = hexchars[val & 0xf];
        val = resColor->blue >> 8;
        *printptr++ = hexchars[(val & 0xf0) >> 4];
        *printptr++ = hexchars[val & 0xf];
      }
      image += bytes_per_line;
      fwrite (printrow, 1, width * 6, fp);
      fprintf (fp, "\n");
    }
    free (printrow);
  }
}

/* print an image in 24-bit TrueColor */

void
printImage24 (unsigned char      *image,
              int                 x,
              int                 y,
              int                 width,
              int                 height,
              int                 depth,
              FILE               *fp)
{
  unsigned char  val,
                 *imageEnd;
  char           *printrow,
                 *printptr;
  int            bytes_per_line;
  int i;

  bytes_per_line = 4 * width; /* 4 bytes per pixel! */
  imageEnd = image + bytes_per_line * height;

  printrow = (char *) malloc (width * 6);

/* image header..presumes we have defined imagedraw function. y translation
   negative as inverse of moveto */
  
    fprintf (fp, "/picstr %d string def\n", width*3);
    fprintf (fp, "<<\n");
    fprintf (fp, "/ImageType 1\n");
    fprintf (fp, "/Width %d /Height %d\n", width, height);
    fprintf (fp, "/BitsPerComponent 8\n");
    fprintf (fp, "/Decode [0 1 0 1 0 1]\n");
    fprintf (fp, "/ImageMatrix [ 1 0 0 1 %d %d]\n", -x, -y);
    fprintf (fp, "/DataSource { currentfile picstr readhexstring pop }\n");
    fprintf (fp, ">>\n");
    fprintf (fp, "image\n");

  while (image < imageEnd)
  {
/* get the print pixel corresponding to the image pixel */

    printptr = printrow;
    for (i = 0; i < sizeof(unsigned long) * width; i += sizeof(unsigned long))
    {
  
  /* in the long, the values are stored as 0BGR */

      val = image[i+3];
      *printptr++ = hexchars[(val & 0xf0) >> 4];
      *printptr++ = hexchars[val & 0xf];
      val = image[i+2];
      *printptr++ = hexchars[(val & 0xf0) >> 4];
      *printptr++ = hexchars[val & 0xf];
      val = image[i+1];
      *printptr++ = hexchars[(val & 0xf0) >> 4];
      *printptr++ = hexchars[val & 0xf];
    }
    image += bytes_per_line;
    fwrite (printrow, 1, width * 6, fp);
    fprintf (fp, "\n");
  }
  free (printrow);
}
