#include <string.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/extensions/Xext.h>

#define NODXFLUSH
#define NEED_REPLIES
#include <X11/Xlibint.h>
#include <X11/Xproto.h>
/*- In the Server distribution, but not normally in /usr/include/X11.
*/
#include "extutil.h"

#include "printlib.h"
#include "printlibP.h"

/*- Local data.
*/
static XExtensionInfo  *printInfo;
static char            *printExtensionName = PRINTNAME;

/* there are X macros dependent on the "dpy" naming convention for display */

#define PrintCheckExtension( dpy, i, val) \
    XextCheckExtension( dpy, i, printExtensionName, val)

static int              close_display ();
static char            *error_string ();

static XExtensionHooks  printExtensionHooks =
{
  NULL,                         /* createGc */
  NULL,                         /* copyGc */
  NULL,                         /* flushGc */
  NULL,                         /* freeGc */
  NULL,                         /* createFont */
  NULL,                         /* freeFont */
  close_display,                /* close_display */
  NULL,                         /* wireToEvent */
  NULL,                         /* eventToWire */
  NULL,                         /* error */
  error_string,                 /* error_string */
};

static char            *printErrorList[] =
{
  "BadPrintWindow",
};

static 
XEXT_GENERATE_FIND_DISPLAY (findDisplay, printInfo,
                            printExtensionName,
                            &printExtensionHooks, 0, NULL)

  static                  XEXT_GENERATE_CLOSE_DISPLAY (close_display, printInfo)

  static                  XEXT_GENERATE_ERROR_STRING (error_string, printExtensionName,
                                                      PrintNumberErrors, printErrorList)

/* request to open a print window, and generate PostScript for all draw 
   commands sent to that window */

  Bool                    XOpenPrintWindow (Display *dpy,
                                            Window win,
                                            char *printfile)
{
  XExtDisplayInfo        *info = findDisplay (dpy);
  xOpenPrintReq          *req;
  xPrintReply             rep;

  PrintCheckExtension (dpy, info, False);
  LockDisplay (dpy);
  GetReq (OpenPrint, req);
  req->strlength = strlen (printfile);
  req->reqType = info->codes->major_opcode;
  req->printReqType = X_OpenPrint;
  req->drawable = win;

/* copy except for the '\0' */

  strncpy (req->filename, printfile, req->strlength);
  if (!_XReply (dpy, (xReply *) & rep, 0, xFalse))
  {
    UnlockDisplay (dpy);
    SyncHandle ();
    return (False);
  }
  UnlockDisplay (dpy);
  SyncHandle ();
  return (rep.flag);
}

/* request to close the print window and the postscript output file */

Bool 
XClosePrintWindow (Display *dpy,
                   Window win)
{
  XExtDisplayInfo        *info = findDisplay (dpy);
  xClosePrintReq         *req;

  PrintCheckExtension (dpy, info, False);
  LockDisplay (dpy);
  GetReq (ClosePrint, req);
  req->reqType = info->codes->major_opcode;
  req->printReqType = X_ClosePrint;
  req->drawable = win;
  UnlockDisplay (dpy);
  SyncHandle ();
  return (True);
}

/* set the printer paramters for our output ( like preserving aspect ratio) */

Bool 
XSetPrintParams (Display *dpy,
                 Bool preserveAspect,
                 int fontScale,
                 int pixmapScale,
                 int pageWidth,
                 int pageHeight,
                 int printDirect,
                 int landscape,
                 char *correctFile)
{
  XExtDisplayInfo        *info = findDisplay (dpy);
  xSetPrintReq           *req;

  PrintCheckExtension (dpy, info, False);
  LockDisplay (dpy);
  GetReq (SetPrint, req);
  req->reqType = info->codes->major_opcode;
  req->printReqType = X_SetPrint;
  req->aspect = preserveAspect;
  req->fontScale = fontScale;
  req->pixmapScale = pixmapScale;
  req->pageWidth = pageWidth;
  req->pageHeight = pageHeight;
  req->printDirect = printDirect;
  req->landscape = landscape;
  if (correctFile != NULL)
  {
    req->strlength = strlen (correctFile);
    strncpy (req->correctFile, correctFile, req->strlength);
  }
  else
  {
    req->strlength = 0;
  }
  UnlockDisplay (dpy);
  SyncHandle ();
  return (True);
}
