/*
** GetImage.c
**
**	Contains the function to grab a copy of the widget content into
**	the XImage structure. This a very independent module and does not
**	need any other Xew modules to work.
**
** Copyright 1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include "GetImage.h"

/*
** Handle some differencies between X11 releases
*/
#if ((XtVersion) < 11005)
typedef char *XPointer;
#endif

/*
** XeGetXImage
*/
XImage *XeGetXImage(w, x, y, width, height)
Widget w;
int x, y;
unsigned int width, height;
    {
	Display *display = XtDisplay(w);
	Window window = XtWindow(w);
	Pixmap pixmap;
	GC gc;
	XImage *image;

	/*
	** No XGetImage is possible if the widget is not properly realised
	*/
	if (!window || !w->core.width || !w->core.height)
		return NULL;

	/*
	** Constrain the requested rectangle inside the pixmap
	** to prevent "bad match" errors from XGetImage!
	*/
	if (x < 0)
	    {
		width += x;
		x = 0;
	    }
	else if (x >= w->core.width)
		x = w->core.width - 1;
	if (y < 0)
	    {
		height += y;
		y = 0;
	    }
	else if (y >= w->core.height)
		y = w->core.height - 1;
	if (x + width > w->core.width)
		width = w->core.width - x;
	if (y + height > w->core.height)
		height = w->core.height - y;
			
	pixmap = XCreatePixmap
		(display,window, w->core.width, w->core.height, w->core.depth);
	gc = XCreateGC(display, window, 0, 0);
	XSetForeground(display, gc, w->core.background_pixel);
	if (w->core.background_pixmap != XtUnspecifiedPixmap)
		XSetTile(display, gc, w->core.background_pixmap);
	XFillRectangle(display, pixmap, gc,0,0,w->core.width,w->core.height);

	if (w->core.widget_class->core_class.expose)
	    {
		static XExposeEvent init_expose;

		XExposeEvent expose;
		Region region;
		XRectangle rect;

		/*
		** Do the dirty! Substitute the pixmap into widget window
		** and fake an expose event (this may mess up some widgets!
		** Perhaps should in the end use XClearArea with exposures
		** True for the original window?)
		*/
		expose = init_expose;
		expose.type = Expose;
		expose.display = display;
		expose.window = pixmap;
		rect.x = expose.x = 0;
		rect.y = expose.y = 0;
		rect.width = expose.width = w->core.width;
		rect.height = expose.height = w->core.height;
		w->core.window = pixmap;
		region = XCreateRegion();
		XUnionRectWithRegion(&rect, region, region);
		(*w->core.widget_class->core_class.expose)
			(w, (XEvent *)&expose, region);
		XDestroyRegion(region);
		w->core.window = window;
	    }
	else
		/*
		** Widget does not have an expose method, there nothing
		** else to be done, except try for XCopyArea...
		*/
		XCopyArea(display, window, pixmap, gc,
			  0, 0, w->core.width, w->core.height, 0, 0);
	image = XGetImage(display, pixmap,
			  x, y, width, height,
			  AllPlanes, ZPixmap);
	XFreePixmap(display, pixmap);
	XFreeGC(display, gc);
	return image;
    }

