#ifndef _XewPrintP_h
#define _XewPrintP_h
/*
** Copyright 1995 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include "Print.h"

/*
** XePrintInitializeProc, XePrintProc, XePrintCancelPRoc, XePrintDestroyProc
**	widget methods to perform printing of the content
**
** XePrintInitializeProc (print_initialize method)
**	is somewhat similar to widget Initialize method (called in
**	superclass-subclass order). This should make all the necessary
**	changes for the printing process in the clone widget instance
**	(a typical things that need be done are recreating GC's, recomputing
**	any pixel values, reproducing the pixmaps etc..
**
** XePrintDestroyProc (print_destroy method)
**	is similar to the widget Destroy method (called in subclass-superclass
**	order). Its task is to release any resources allocated to the clone
**	widget.
**
** XePrintConstraintInitialize (print_constraint_initialize method)
**	is similar to the widget Constraint Initialize method. This should make
**	any necessary changes for the printing in the copied widget constraint
**	record.
**
** XePrintConstraintDestroy (print_constraint_destroy method)
**	is similar to the widget Constraint Destroy method. This is release
**	any resources allocated in the Print Constraint Initialize.
**
** XePrintProc (print method)
**	is a method that should do the actual printing. If this returns
**	non-NULL context pointer, the printing is active, but not completed.
**	In that case main process (_XePrintProcess) will exit and it is
**	the responsibility of the widget specific printing to resume the
**	main process by calling _XePrintProcess after the widget print
**	has been completed.
**
** XePrintCancel (print_cancel method)
**	is a method that is used to cancel the active printing process
**	in the widget. The context parameter is the same as was returned
**	by the print method. This function should abort whatever asynchronous
**	printing is in progress and return the widget approximately to the
**	state that it was before the print method call.
**
**	*NOTE*	This function should not do any tasks of the print_destroy
**		method, which will get called later anyway.
**
**	*NOTE*	It is also guaranteed that print_destroy method is never
**		called for a clone widget, if this printing is active on
**		it. print_cancel is *always* called first in such cases.
**
**	*NOTE*	This function must not call the _XePrintProcess, which would
**		normally happen when the active printing process completes.
*/
#if NeedFunctionPrototypes
typedef void (*XePrintInitializeProc)(Widget, Widget, XePrintProcess);
typedef XtPointer (*XePrintProc)(Widget, Widget, int, int, XePrintProcess);
typedef void (*XePrintConstraintInitializeProc)(Widget, Widget, XePrintProcess);
typedef void (*XePrintConstraintDestroyProc)(Widget, Widget, XePrintProcess);
typedef void (*XePrintCancelProc)(Widget, Widget, XePrintProcess, XtPointer);
typedef void (*XePrintDestroyProc)(Widget, Widget, XePrintProcess);
#else
typedef void (*XePrintInitializeProc)();
typedef void (*XePrintConstraintInitializeProc)();
typedef void (*XePrintConstraintDestroyProc)();
typedef XtPointer (*XePrintProc)();
typedef void (*XePrintCancelProc)();
typedef void (*XePrintDestroyProc)();
#endif

typedef struct PrintNode
    {
	Widget w, clone;
	XePrintProc print;
	XePrintCancelProc cancel;
    } PrintNode;


typedef struct XePrintProcessRec
    {
	int running;		/* Non-Zero when process running, zeroed
				   just before the final page callback. This
				   is used to prevent destructive recursion,
				   if application calls XePrintCancel from the
				   final callback...
				   */
	int paused;		/* Non-Zero when printing process is paused
				   temporarily by the application */

	int calling;		/* Non-Zero, when page callback is being
				   called. This is used to prevent recursive
				   calls to the callback */

	XePrinter *printer;	/* Printer */
	XePrintPageProc callback;/* Page callback */
	XtPointer client_data;	/* for the page callback */

	Widget print_root;	/* The top level widget being printed */
	Widget clone_root;	/* The top level widget of the clone tree */
	GC gc;			/* GC used for printing borders */
	int x, y;		/* Current page origin */
	int width, height;	/* Area to print */
	int page;		/* Current page number */
	int count;		/* Number of Widgets in the tree */
	int current;		/* Index of the current widget being printed */
	XtPointer printing;	/* Printing context of current widget */
	PrintNode tree[1];	/* Widget Tree to print (struct hack!) */
    } XePrintProcessRec;


_XFUNCPROTOBEGIN
/*
** _XePrintProcess
**	is the internal control loop that calls the individual print
**	methods of the widgets one at time. If the print methode returns
**	a non-NULL pointer (context), it a responsibility of the print
**	method to arrange a call to _XePrintProcess to resume the
**	main loop, once the current widget is printed.
*/
XePrintProcess _XePrintProcess
	(
#if NeedFunctionPrototypes
	 XePrintProcess		/* Print Process Context pointer */
#endif
	 );

/*
** _XeDefaultPrint, _XeDefaultPrintCancel
**	implement the default print methods that can be used for any widget.
**	These methods grab the window content by use of XGetImage and convert
**	that to the printer.
**
** *NOTE*
**	Never only use one of these, the methods depend on each other.
**	You must use both or neither.
*/
XtPointer _XeDefaultPrint
	(
#if NeedFunctionPrototypes
	 Widget,		/* Real widget instance */
	 Widget,		/* Printer adjusted clone */
	 int, int,		/* Destination address on the printer page */
	 XePrintProcess		/* Print Process Context pointer */
#endif
	 );

void _XeDefaultPrintCancel
	(
#if NeedFunctionPrototypes
	 Widget,		/* Real widget instance */
	 Widget,		/* Printer adjusted clone */
	 XePrintProcess,	/* Print Process Context pointer */
	 XtPointer		/* Widget Printing context to cancel */
#endif
	 );

_XFUNCPROTOEND
#endif
