/*
** Import module for importing JPEG/JFIF images into Xew
** internal raster format. This is based on example.c from the
** jpegsrc.v5 (beta1) distribution.
**
** Copyright 1992-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <stdio.h>
#if SYSV_INCLUDES
#	include <memory.h>
#	include <malloc.h>
#else
#if ANSI_INCLUDES
#	include <stddef.h>
#	include <stdlib.h>
#else
char *malloc();
void free();
#endif
#endif
#include <string.h>
#include <setjmp.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/RasterP.h>
#include "ImageTools.h"
#include "RasterJPEG.h"

#ifndef NO_JPEG
#include "jpeglib.h"

typedef struct WidgetContext
    {
	struct jpeg_error_mgr pub; /* "public" fields */
	jmp_buf setjmp;		/* Error exit buffer */
	XeRasterWidget widget;	/* Widget Instance Pointer */
	XeRawImage *raw;	/* Raw image being built */
    } WidgetContext;
#endif

static void RasterImportWarning(w, msg)
XeRasterWidget w;
char *msg;
    {
	XeWidgetWarningMsg
		((Widget)w, "rasterImportWarning", msg, (String *)NULL, 0);
    }

#ifndef NO_JPEG
/*
** *NOTE*
**	The code below has some initial preparations for supporting other
**	than 8 bit sample size, but they are not yet really effective. Only
**	8 bits works for now!!!!
*/
static void AllocateImageBuffer(raw, cinfo)
XeRawImage *raw;
struct jpeg_decompress_struct *cinfo;
    {
	long size;
	int i, components;

	raw->num_channels = components = raw->samples_per_pixel =
		cinfo->output_components;
	raw->width = cinfo->output_width;
	raw->height = cinfo->output_height;
	raw->bytes_per_line = components * raw->width;
	raw->bits_per_sample = BITS_IN_JSAMPLE;
	raw->bits_per_component = 8 * sizeof(JSAMPLE); /* assumes 8bit bytes */
	size = raw->bytes_per_line * raw->height * sizeof(JSAMPLE);
	if ((raw->data = (unsigned char *)malloc(size)) == NULL)
		return;
	if (components == 1)
		/* here it is assumed that colormap is provided also
		   for the grayscale and it can be treated as palette
		   color. watch this out! --msa */
		raw->image_class = XeImageClass_PALETTE;
	else
		raw->image_class = XeImageClass_FULLCOLOR;
	raw->alloc_data = True;
	for (i = 0; i < raw->num_channels; ++i)
	    {
		raw->channel[i].addr = raw->data + i;
		raw->channel[i].w = raw->width;
		raw->channel[i].h = raw->height;
		raw->channel[i].inc = raw->num_channels;
		raw->channel[i].line = raw->bytes_per_line;
	    }
	if (cinfo->out_color_space == JCS_YCbCr)
		raw->color_space = XeImageSpace_YCbCr;
	else
		raw->color_space = XeImageSpace_RGB;
    }

static void SetupParameters(w, raw, cinfo)
XeRasterWidget w;
XeRawImage *raw;
struct jpeg_decompress_struct *cinfo;
    {
	if (cinfo->out_color_space == JCS_RGB &&
	    w->basic.imaging.color_quantize == XeColorQuantize_JPEG)
	    {
		cinfo->quantize_colors = TRUE;
		cinfo->desired_number_of_colors =
			w->basic.imaging.max_colors > 256 ?
				256 : w->basic.imaging.max_colors;
	    }
    }

static void AllocateColormap(raw, cinfo)
XeRawImage *raw;
struct jpeg_decompress_struct *cinfo;
    {
	int num_colors = cinfo->actual_number_of_colors;
	JSAMPARRAY colormap = cinfo->colormap;
	int i;
	unsigned char *r, *g, *b;
	int mapsize = (1 << raw->bits_per_sample);

	if (raw->alloc_map)
		XtFree((char *)raw->color_map); /* Release old if exists */
	if (colormap == NULL)
	    {
		raw->alloc_map = False;
		raw->color_map = NULL;
		if (cinfo->output_components < 3)
		    {
			/* Either this is grayscale or something weird... */
			raw->image_class = XeImageClass_GRAYSCALE;
		    }
		return;
	    }
	raw->alloc_map = True;
	r = raw->color_map = (unsigned char *)XtMalloc(3 * mapsize);
	g = r + mapsize;
	b = g + mapsize;
	if (mapsize < num_colors) /* should really give warning --msa */
		num_colors = mapsize;
	else if (cinfo->out_color_space == JCS_RGB)
		for (i = 0; i < num_colors; i++)
		    {
			r[i] = GETJSAMPLE(colormap[0][i]);
			g[i] = GETJSAMPLE(colormap[1][i]);
			b[i] = GETJSAMPLE(colormap[2][i]);
		    }
	else
		for (i = 0; i < num_colors; i++)
			r[i] = g[i] = b[i] = GETJSAMPLE(colormap[0][i]);

    }

static void JPEG_Message(cinfo)
j_common_ptr cinfo;
    {
	WidgetContext *context = (WidgetContext *)cinfo->err;
	char msgtext[JMSG_LENGTH_MAX];

	(*cinfo->err->format_message)(cinfo, msgtext);
	XeWidgetWarningMsg
		((Widget)context->widget, "rasterImportWarning", msgtext,
		 (String *)NULL, 0);
    }

static void JPEG_Error (cinfo)
j_common_ptr cinfo;
    {
	WidgetContext *context = (WidgetContext *)cinfo->err;

	(*cinfo->err->output_message)(cinfo);
	longjmp(context->setjmp, 1);
    }
/*
** ****************************************************************
** JPEG input source manager for reading input from a memory buffer
** ****************************************************************
**
*/
typedef struct SourceManager
    {
	struct jpeg_source_mgr pub;
    } SourceManager;

static void init_source(cinfo)
j_decompress_ptr cinfo;
    {
    }

static boolean fill_input_buffer(cinfo)
j_decompress_ptr cinfo;
    {
	static JOCTET EOI[] =  {0xFF, JPEG_EOI};
		
	SourceManager *src = (SourceManager *)cinfo->src;
	/*
	** This should not really occur. Just fake the EOI marker
	*/
	src->pub.next_input_byte = EOI;
	src->pub.bytes_in_buffer = sizeof(EOI);
	return TRUE;
    }

static void skip_input_data(cinfo, num_bytes)
j_decompress_ptr cinfo;
long num_bytes;
    {
	SourceManager *src = (SourceManager *)cinfo->src;

	if (num_bytes <= 0)
		return;
	else if (num_bytes > src->pub.bytes_in_buffer)
		num_bytes = src->pub.bytes_in_buffer;
	src->pub.next_input_byte += num_bytes;
	src->pub.bytes_in_buffer -= num_bytes;
    }

static void term_source(cinfo)
j_decompress_ptr cinfo;
    {
    }

static void JPEG_string_src(cinfo, buffer, length)
j_decompress_ptr cinfo;
char *buffer;
long length;
    {
	SourceManager *src;

	if (cinfo->src == NULL)
		cinfo->src = (struct jpeg_source_mgr *)
			XtMalloc(sizeof(SourceManager));
	src = (SourceManager *)cinfo->src;
	src->pub.init_source = init_source;
	src->pub.fill_input_buffer = fill_input_buffer;
	src->pub.skip_input_data = skip_input_data;
	src->pub.resync_to_restart = jpeg_resync_to_restart;
	src->pub.term_source = term_source;
	src->pub.bytes_in_buffer = length;
	src->pub.next_input_byte = buffer;
    }
/* *****************************
** END OF INPUT MANAGER ROUTINES
** *****************************
*/

#endif

/*
** XeImport_JPEG
**
*/
XeRawImage *XeImport_JPEG(w)
XeRasterWidget w;
    {
#ifdef NO_JPEG
	RasterImportWarning(w, "JPEG support not compiled.");
	return NULL;
#else
	struct jpeg_decompress_struct cinfo;
	WidgetContext context;
	XeDataContent content;

	_XeOpenContent((XeBasicWidget)w, &content);
	context.widget = w;
	context.raw = _XeCreateRawImage(3); /* Prepare for 3 channels */
	
	/* Set up longjmp for error recovery out of JPEG_Error */
	cinfo.err = jpeg_std_error(&context.pub);
	context.pub.error_exit = JPEG_Error;
	context.pub.output_message = JPEG_Message;
	if (setjmp(context.setjmp))
		goto import_failed;
	jpeg_create_decompress(&cinfo);
	if (content.type)
		jpeg_stdio_src(&cinfo, content.source.stream);
	else
		JPEG_string_src(&cinfo, content.source.string, content.length);
	(void)jpeg_read_header(&cinfo, TRUE);
	SetupParameters(context.widget, context.raw, &cinfo);
	jpeg_start_decompress(&cinfo);
	AllocateImageBuffer(context.raw, &cinfo);
	if (context.raw->data == NULL)
	    {
		RasterImportWarning(w, "Out of Memory at JPEG Import");
		goto import_failed;
	    }
	while (cinfo.output_scanline < cinfo.output_height)
	    {
		JSAMPROW row = (JSAMPLE *)
			&context.raw->data[cinfo.output_scanline *
					   context.raw->bytes_per_line];
		(void)jpeg_read_scanlines(&cinfo, &row, 1);
	    }
	AllocateColormap(context.raw, &cinfo);
	(void)jpeg_finish_decompress(&cinfo);
	jpeg_destroy_decompress(&cinfo);
	_XeCloseContent(&content);
	return context.raw;
	/*
	** Import failed, cleanup
	*/
    import_failed:
	jpeg_destroy_decompress(&cinfo);
	_XeDestroyRawImage(context.raw);
	_XeCloseContent(&content);
	return NULL;
#endif
    }



