/*
** RasterLayout
**
**	This module must build up the Display version of the
**	raster image, creating the XImage structure. This should be
**	called whenever the content, image dimensions or anything
**	affecting the presentation changes.
**
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/RasterP.h>

#include "RasterLayout.h"
#include "ImageTools.h"

void XeRasterLayout(w)
XeRasterWidget w;
    {
	XImage *image;
	XeRawImage *raw = w->raster.raw_image;
	XeImageChannel data[4];
	int i, pixel_size, src_width, src_height;
	Dimension width, height;

	_XeDestroyImage(w->raster.dsp_image);
	w->raster.dsp_image = NULL;
	w->raster.done = True;	/* Consider done, whether errors or not */
	if (raw == NULL)
		return;		/* Nothing to layout */
	/*
	** The source image rectange size
	*/
	src_width = w->raster.clip_width > 0 ?
		w->raster.clip_width : w->raster.raster_width;
	src_height = w->raster.clip_height > 0 ?
		w->raster.clip_height :  w->raster.raster_height;
	/*
	** Apply the current scale setting and window size to this and
	** get destination rectangle size
	*/
	_XeBasicScaling((XeBasicWidget)w, src_width, src_height,
			w->core.width, w->core.height,
			&width, &height);
	/*
	*/
	if (w->basic.cmap && w->basic.cmap != w->core.colormap)
	    {
		w->core.colormap = w->basic.cmap;
		XSetWindowColormap(XtDisplay(w),XtWindow(w),w->core.colormap);
		w->basic.cmap = 0;
	    }
	/*
	*/
	w->raster.dsp_image = _XeCreateImage
		(XtDisplay(w), XtWindow(w), w->raster.raw_image,
		 &w->basic.imaging, width, height);
	if (w->raster.dsp_image == NULL ||
	    (image = w->raster.dsp_image->image) == NULL)
		return;
	data[0].addr = (unsigned char *)image->data;
	data[0].w = image->width;
	data[0].h = image->height;
	data[0].line = image->bytes_per_line;
	data[0].inc = (image->bits_per_pixel + 7) / 8;
	pixel_size = raw->bits_per_component * raw->samples_per_pixel;
	for (i = 1; i <= raw->num_channels && i < XtNumber(data); i++)
	    {
		XeImageChannel channel;
		int cx, cy, cw, ch;

		channel = raw->channel[i-1];
		/*
		** Perform CLIP computations. Because channels may have
		** different dimensions, clip parameters must first
		** be converted from raster coordinates to channel specific
		** values (cx, cy, cw, ch).
		*/
		cx = (w->raster.clip_x * channel.w) / raw->width;
		if (cx < 0)
			cx = 0;
		cy = (w->raster.clip_y * channel.h) / raw->height;
		if (cy < 0)
			cy = 0;
		cw = (w->raster.clip_width * channel.w) / raw->width;
		if (cw <= 0)
			cw = channel.w;
		if (cw > channel.w - cx)
			cw = channel.w - cx;
		ch = (w->raster.clip_height * channel.h) / raw->height;
		if (ch <= 0)
			ch = channel.h;
		if (ch > channel.h - cy)
			ch = channel.h - cy;
		channel.addr += cy * channel.line + cx * channel.inc;
		channel.w = cw;
		channel.h = ch;
		/*
		** Rotation/mirror work only for >=8 bit channels
		*/
		if (pixel_size < 8)
			data[i] = channel;
		else
			_XeMirrorRotation(w->basic.rotation,
					  w->basic.mirror_image,
					  &channel,  &data[i]);
	    }
	_XeBuildImage(w->raster.dsp_image, i, data);
	if (w->core.colormap != w->raster.dsp_image->colormap)
	    {
		if (!w->basic.cmap)
			/*
			** Replacing default colormap with private one
			*/
			w->basic.cmap = w->core.colormap;
		w->core.colormap = w->raster.dsp_image->colormap;
		XSetWindowColormap(XtDisplay(w),XtWindow(w),w->core.colormap);
		if (w->core.colormap == w->basic.cmap)
			w->basic.cmap = 0;
	    }
    }






