/*
** VideoImage
**	This module contains functions and utilities to convert the
**	raw video frame (Y, Cb, Cr) into XImage structure.
**
** Copyright 1993-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <stdio.h>
#if ANSI_INCLUDES
#	include <stddef.h>
#	include <stdlib.h>
#endif
#include <assert.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/VideoP.h>
#include "BasicColor.h"
#include "ImageTools.h"
#include "VideoImage.h"

#ifdef SH_MEM
#	include <sys/ipc.h>
#	include <sys/shm.h>
#	include <X11/extensions/XShm.h>
#endif

/*
** XeVideoImage
**	This function is called once per each video frame
*/
void XeVideoImage(w)
XeVideoWidget w;	/* Video Widget */
    {
	XImage *image;
	XeImageChannel data[4];
	XeRawImage *raw = w->video.raw_image;
	int i;

	if (!XtIsRealized((Widget)w) || raw == NULL || !raw->num_channels)
		return;
	if (!w->video.done)
	    {
		Dimension width, height;

		_XeDestroyImage(w->video.dsp_image);
		w->video.done = True;
		_XeBasicScaling((XeBasicWidget)w, raw->width, raw->height,
				w->core.width, w->core.height,
				&width, &height);
		/*
		*/
		if (w->basic.cmap && w->basic.cmap != w->core.colormap)
		    {
			w->core.colormap = w->basic.cmap;
			XSetWindowColormap
				(XtDisplay(w),XtWindow(w),w->core.colormap);
			w->basic.cmap = 0;
		    }
		/*
		*/
		w->video.dsp_image =
			_XeCreateImage(XtDisplay(w), XtWindow(w), raw,
				       &w->basic.imaging,
				       width, height);
	    }
	if (!w->video.dsp_image || (image = w->video.dsp_image->image) == NULL)
		return;
	data[0].addr = (unsigned char *)image->data;
	data[0].w = image->width;
	data[0].h = image->height;
	data[0].line = image->bytes_per_line;
	data[0].inc = (image->bits_per_pixel + 7) / 8;
	for (i = 1; i <= raw->num_channels && i < XtNumber(data); ++i)
		_XeMirrorRotation(w->basic.rotation,w->basic.mirror_image,
				  &raw->channel[i-1], &data[i]);
	_XeBuildImage(w->video.dsp_image, i, data);
	if (w->core.colormap != w->video.dsp_image->colormap)
	    {
		if (!w->basic.cmap)
			/*
			** Replacing default colormap with private one
			*/
			w->basic.cmap = w->core.colormap;
		w->core.colormap = w->video.dsp_image->colormap;
		XSetWindowColormap(XtDisplay(w),XtWindow(w),w->core.colormap);
		if (w->core.colormap == w->basic.cmap)
			w->basic.cmap = 0;
	    }
	/*
	** Call the expose for all of the window.
	*/
	(*w->core.widget_class->core_class.expose)
		((Widget)w, (XEvent *)NULL, (Region)0);
	XFlush(XtDisplay(w));
    }

