/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: group.h,v 1.8 95/09/25 14:54:55 leon Exp $ */
#ifndef __KN_GROUP_H
#define __KN_GROUP_H




#include <Kn/kno.h>


#ifdef __cplusplus
extern "C" {
#endif



extern void KnGroupImport();
extern void KnGroupClassInitialize();






#define KnGroupPart\
    KnOPart;\
    KlList children


typedef struct KnGroupStruct {
    KnGroupPart;
} *KnGroup;

/* The Group Class
   
 * INHERITS: KnO
 
 * OVERRIDES:
- KnSelDispatch 
 
 * FIELDS: new fields defined in the KnRect class are:
-    KlList children: children list

 * DESCRIPTION

 * The KnGroup class has no graphical appearance. It is used to group some
 * graphical objects. A KnGroup may be rotated, moved and resized. It may
 * receive its own behavior, with Interactors, or Xt translations. A KnGroup
 * has its own dispatch mechanism. It tries first to dispatch an event to any
 * of its children, then if the event has not been dispatched, it tries to
 * dispatch it with its own behavior. A KnGroup Draw method just call this
 * method for all its children

 * USE: class writing
 */
extern KlType KnGroupClass;


/* Builds a new KnGroup Object
   
 * This is KnGroup class constructor. It builds a new KnGroup whose left corner
 * coordinates are (x,y) and size is width x height. Position and size are
 * given in the parent's coodinates system.

 * USE: application programming.
 
 * returns: The newly created KnGroup
 */
KnO
KnCreateGroup(Widget knvas,	/* a knvas widget */
	    KnO parent,		/* the Group parent */
	    KnPosition x,		/* top left x coordinate */
	    KnPosition  y);	/* top left y coordinate */

KnO
KnGroupAdd(KnGroup g, KnO kno);

void
KnGroupRemove(KnGroup g, KnO kno);

/* KnGroup Initializer
   
 * This function calls the KnO Initializer and initializes the KnGroup specific
 * fields. Unlike the KnOs it creates a Transformer for the group object.

 * USE: class writing
 
 * returns: the kno
 */
void 
KnGroupInit(KnGroup group,	/* the group object */
	    Widget knvas,	/* a knvas widget */
	    KnO parent,		/* the group's parent */
	    KnPosition x,		/* top left x coordinate */
	    KnPosition y);	/* top left y coordinate */



#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif


#endif /* __KN_O_H */
