/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: knoP.h,v 1.4 95/09/28 11:58:23 leon Exp $ */
#ifndef __KNOP_H
#define __KNOP_H

#include <X11/Intrinsic.h>
#include <Kn/kno.h>
#include <Kn/KnvasP.h>
#include <Kn/TagP.h>
#include <Kn/rect.h>
#include <Kn/layer.h>

/* This file contains private functions declarations */

#ifdef __cplusplus
extern "C" {
#endif



void
KnOCopyFields(KnO new,
	      KnO old);


void
KnRectCopyFields(KnRect new,
		 KnRect old);


void
KnTagComputeShadow(KnTag tag,
		   GC *top_gc,
		   GC *bottom_gc,
		   KnDimension *top_thick,
		   KnDimension *bottom_thick);





/* Get a knvas's tag
   
 * If the knvas owns a tag whose tag id is tid, it returns this tag, else, it
 * returns the default knvas tag
 
 * returns: The Tag whose tag id is tid */
KnTag
KnvasGetTag(Widget w,		/* the knvas widget */
	     KnTagId tid);	/* the tag id */




void
KnDrawSelectedBox(KnTag tag,
		  KnDrawingContext ct,
		  XRectangle *box);


void
KnvasAddLayer(Widget knvas,
	      KnLayer layer);

#ifdef __cplusplus
} /* Close scope of 'extern "C"' declaration which encloses file. */
#endif




#endif /* __KNOP_H */
/* DON'T ADD ANYTHING AFTER THIS #endif */
