/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: label.h,v 1.5 95/09/25 14:55:55 leon Exp $ */
#ifndef __LABEL_H
#define __LABEL_H



#include <Kn/kno.h>

#ifdef __cplusplus
extern "C" {
#endif



extern void KnLabelImport();
extern void KnLabelclassInitialize();

#define KnLabelPart\
    KnOPart;\
    char *s;\
    int len


typedef struct KnLabelStruct {
    KnLabelPart;
} *KnLabel;





/* The Label Class
   
 * INHERITS: KnO
 
 * OVERRIDES: no method overrided
 
 * FIELDS: new fields defined in the KnRect class are:


 * DESCRIPTION

 * Define a label object whose top left corner is (x, y). It will be displayed
 * as text and may contain newlines ('\n'). The label may NOT be rotated nor
 * zoomed. The object is drawn as a label, using font and foreground from its
 * tag.

 * USE: class writing */
extern KlType KnLabelClass;


/* Builds a new KnLabel object.
   
 * This is the KnLabel class constructor. It builds a new KnLabel object that
 * will be drawn as a label, whose source point coodinates are (x, y)

 * USE: application programming.
 
 * returns: The newly created KnLabel. */
KnO
KnCreateLabel(Widget knvas,	/* ignored. required for consistency */
	    KnO  parent,		/* the object's parent */
	    KnPosition x,		/* x coordinate of source point */
	    KnPosition y,		/* y coodinate of source point */
	    char *s);		/* the string to be displayed */



/* KnLabel Initializer
   
 * Initialize the KnLabel fields, according to the parameters. This must be
 * called by any KnLabel sub-class. This will call the KnO initializer before
 * initializing the KnLabel specific fields. The KnLabel specific fields are:

-  l->width = tox - x;
-  l->height = toy - y;

 * WARNING: label fields are width, height, so that the target point is relative
 * to the origin point (x, y). Keeping only tox and toy in the KnLabel object
 * make us lose benefice of transformations.

 * USE: class writing
 
 * returns: */
void
KnLabelInit(KnLabel l,
	    Widget knvas,
	    KnO parent,
	    KnPosition x,
	    KnPosition y,
	    char *s);



#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif



#endif /* __LABEL_H */
