/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: layer.c,v 1.10 95/09/28 11:57:46 leon Exp $ */
#include "layer.h"
#include "Knvas.h"
#include "TagP.h"

/*********************\
* 		      *
*  KlO  KnLayer          *
*  BODY		      *
* 		      *
\*********************/



/* type desc */
KlType KnLayerClass;


/* init class fields and call super class Init proc */
void
KnLayerInit(KnLayer layer, Widget knvas)
{
    TagObject tag;
    tag = (TagObject)KnvasGetDefaultTag(knvas);
    layer->tid = tag->tag.id;
    layer->parents = KlListNMake(0);
    KlIncRef(layer->parents);
    KnvasShareLayer(knvas, layer);
    KnGroupInit((KnGroup)layer, knvas, 0, 0, 0);
    layer->parent = NULL;
}


void
KnLayerFree(KnLayer layer)
{
    layer->parents->size = 0;	/* prevent KlDecRef on widgets */
    KlDecRef(layer->parents);
    KnGroupFree((KnGroup)layer);
}


/* allocates storage space for a new layer
 * 
 * returns: the newly created KnLayer
 */
KnO
KnCreateLayer(Widget knvas)
{
    KnLayer layer;
    layer =  (KnLayer)KlOMake(KnLayerClass);
    KnLayerInit(layer, knvas);
    return (KnO)layer;
}






KnO
KnLayerContains(KnGroup group, Widget knvas, Int x, Int y)
{
    KnO res;
    if (NULL != (res = (KnO)KnGroupContains(group, knvas, x, y)))
	return res;
    else
	return group->interactor ? (KnO)group : (KnO)NULL;
}






/* declare new   selectors
 */
void
KnLayerImport()
{
	
}



void
KnLayerClearBox(KnLayer layer, XPoint *points, Cardinal n, XRectangle *extra)
{
    int i;
    Widget w;

    for(i = 0; i < layer->parents->size; i++) {
	w = (Widget)layer->parents->list[i];
	if(XtIsRealized(w)) {
	    KnvasClearArea(w, points, n, extra);
	}
    }
}



/* class initializations for KnLayer objects
 * 
 * returns: 
 */
void
KnLayerClassInitialize()
{
     /* declare  types */
    KlDeclareSubType(&KnLayerClass, "KnLayer", KnGroupClass, 
		     sizeof(struct KnLayerStruct));

    /* declare methods */
    KlDeclareMethod(KnLayerClass, KlSelFree, KnLayerFree);
    KlDeclareMethod(KnLayerClass, KnOSelClearBox, KnLayerClearBox);
    KlDeclareMethod(KnLayerClass, KnOSelContains, KnLayerContains);
}
