/* Copyright (c) 1995 by Groupe Bull.  All Rights Reserved */
/* $Id: relief.c,v 1.3 95/09/28 11:58:33 leon Exp $ */


#include "kno.h"
#include "TagP.h"



void
KnDrawFilledRelief(KnDrawingContext ct, KnTag tag, XPoint *points, int num)
{
    GC top_gc, bottom_gc;
    KnDimension top_thick, bottom_thick;
    int i;
    
    KnTagComputeShadow(tag, &top_gc, &bottom_gc,
		       &top_thick, &bottom_thick);
    KnSetRegion(ct->dpy, top_gc, ct->clip);
    KnSetRegion(ct->dpy, bottom_gc, ct->clip);
    for(i = 0; i < num; i++) {
	points[i].x -= top_thick;
	points[i].y -= top_thick;
    }
    XFillPolygon(ct->dpy, ct->win, top_gc, points, num, 
		 Convex, CoordModeOrigin);
    for(i = 0; i < num; i++) {
	points[i].x += top_thick+bottom_thick;
	points[i].y += top_thick+bottom_thick;
    }
    XFillPolygon(ct->dpy, ct->win, bottom_gc, points, num, 
		 Convex, CoordModeOrigin);
    for(i = 0; i < num; i++) {
	points[i].x -= bottom_thick;
	points[i].y -= bottom_thick;
    }
}
