/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: BarGraphP.h,v 1.1 95/02/02 11:04:13 leon Exp $ */
#ifndef __BAR_GRAPHP_H
#define __BAR_GRAPHP_H

/* force the motif widget flag */
#ifndef DO_MOTIF_WIDGET
#define DO_MOTIF_WIDGET
#endif /* DO_MOTIF_WIDGET */
#include <Kn/KnvasP.h>
#include "BarGraph.h"


#ifdef __cplusplus
extern "C" {
#endif

    
typedef struct {
    int empty;
} KnGraphClassPart;

typedef struct _KnGraphClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    XmManagerClassPart	manager_class;
    KnvasClassPart	knvas_class;
    KnGraphClassPart    graph_class;
} KnGraphClassRec;

typedef struct _KnGraphPart{
    /* public part: resources */
    int *items;
    int itemCount;
    Dimension marginWidth;
    Dimension marginHeight;
    Dimension spacing;

    /* private part */
    KnO layer;
} KnGraphPart;


typedef struct _KnGraphRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart      constraint;
    XmManagerPart       manager;
    KnvasPart	        knvas;
    KnGraphPart         graph;
} KnGraphRec;

extern KnGraphClassRec knGraphClassRec;



#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif


#endif /* __BAR_GRAPHP_H */
