/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: PieChart.c,v 1.1 95/02/02 11:04:16 leon Exp $ */

#include "PieChartP.h"
#include <limits.h>




static XtResource 
resources[] = {
#define offset(field) XtOffset(XmPieChartWidget, pie_chart.field)
  {
      XmNitems, XmCItems, XtRPointer,
      sizeof(XtPointer), offset(items),
      XtRImmediate, (caddr_t)NULL
  },
  
  {
      XmNitemCount, XmCItemCount, XtRInt,
      sizeof(int), offset(itemCount),
      XtRImmediate, (caddr_t)0
  },
  {
      "tags", "Tags", XtRPointer,
      sizeof(XtPointer), offset(tags),
      XtRImmediate, (caddr_t)NULL
  },
  
  {
      XmNmarginWidth, XmCMarginWidth, XtRDimension,
      sizeof(Dimension), offset(marginWidth),
      XtRImmediate, (caddr_t)10
  },
  
  {
      XmNmarginHeight, XmCMarginHeight, XtRDimension,
      sizeof(Dimension), offset(marginHeight),
      XtRImmediate, (caddr_t)10
  },
  
  {
      XmNspacing, XmCSpacing, XtRDimension,
      sizeof(Dimension), offset(spacing),
      XtRImmediate, (caddr_t)5
  },
#undef offset
};





static void
ClassPartInitializeProc(WidgetClass wc)
{

}
  

#define DEPL 1
static void
BuildPieChartDrawing(Widget pie_chart)
{
    XmPieChartWidget gw = (XmPieChartWidget) pie_chart;
#define THIS gw->pie_chart
    Cardinal i;
    Dimension w, h;		/* available space for drawing */
    int total = 0;
    int start_angle = 0, angle, ma;
    float ratio;
    KnO arc;
    char tname[8];
    Position x, y, xd, yd;

    w = pie_chart->core.width - THIS.marginWidth*2;
    h = pie_chart->core.height - THIS.marginHeight*2;
    x = THIS.marginWidth;
    y = THIS.marginHeight;

    THIS.layer = KnCreateLayer(pie_chart);

    THIS.usedtags = XtMalloc(THIS.itemCount*sizeof(KnTag));
    
    for(i = 0; i < THIS.itemCount; i++) {
	sprintf(tname, "tag%d", i);
	THIS.usedtags[i] = KnCreateTag(pie_chart, tname);
    }
    
    for(i = 0; i < THIS.itemCount; i++) {
	total += THIS.items[i];
    }
    start_angle = 0;
    for(i = 0; i < THIS.itemCount; i++) {
	ratio = (float)THIS.items[i] / (float)total;
	angle = 360 * ratio;
	xd = 0; yd = 0;
	ma = start_angle + (angle  / 2);

	xd += ((ma<90) || (ma>=270)) ? DEPL : -DEPL ;

	yd += ((ma>0) && (ma<=180)) ? -DEPL : DEPL ;

	arc = KnCreateFArc(pie_chart, THIS.layer, x+xd, y+yd,w, h,
			  start_angle, angle);
	KnSetTag(pie_chart, arc, THIS.usedtags[THIS.tags[i]]);
	start_angle += angle;
    }
    
    
#undef THIS
    
}    


static void 
InitializeProc(Widget w, Widget neww, ArgList args, Cardinal *n)
{
    
    if(w->core.width != neww->core.width)
	neww->core.width = w->core.width;
    if(w->core.height != neww->core.height)
	neww->core.height = w->core.height;
    
    BuildPieChartDrawing(neww);
}







XmPieChartClassRec xmPieChartClassRec = {
  { /* core fields */
      /* superclass		*/	(WidgetClass) &knvasClassRec,
    /* class_name		*/	"KnPieChart",
    /* widget_size		*/	sizeof(XmPieChartRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	ClassPartInitializeProc,
    /* class_inited		*/	FALSE,
    /* initialize		*/	InitializeProc,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	XtInheritResize,
    /* expose			*/	XtInheritExpose,
    /* set_values		*/	NULL,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	XtInheritTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* composite fields */
    /* geometry_manager     */  NULL,
    /* change_managed       */  NULL,
    /* insert_child	    */  XtInheritInsertChild,
    /* delete_child	    */  XtInheritDeleteChild,
    /* extension	    */  NULL
    },
    {
    /* constraint_class fields */
	/* resources			*/ NULL,
	/* num_resources		*/ 0,
	/* constraint_size		*/ 0,
	/* initialize			*/ NULL,
	/* destroy			*/ NULL,
	/* set_values			*/ NULL,
	/* extension			*/ NULL
    },
    {
    /* manager_class fields */
	/* translations			*/  XtInheritTranslations,
	/* syn_resources		*/  NULL,
	/* num_syn_resources		*/  0,
	/* syn_constraint_resources	*/  NULL,
	/* num_syn_constraint_resources */  0,
	/* parent_process		*/  XmInheritParentProcess,
	/* extension			*/  NULL
    },
/*  { 
      0
  },
  */
  { /* pie_chart fields */
    /* empty			*/	0
  }
};

WidgetClass xmPieChartWidgetClass = (WidgetClass)&xmPieChartClassRec;

