#########################################################################
#
#       MAKEFILE FOR STAND-ALONE XT CODE APPLICATION.  
#
#       EXECUTABLE      is the name of the executable to be created 
#       MAIN            is the .c file containing your main() function 
#       INTERFACES      is a list of the generated C code files
#       APP_OBJS        is a (possibly empty) list of the object code
#                       files that form the non-interface portion of
#                       your application
#
#       In the first three statements, the variables on the right 
#	of the equal sign will be replaced with their corresponding
#       values when the makefile is automatically generated.
#
#       This template is used for makefiles which do not reference 
#       the Ux runtime library.
#
#  	$Date: 93/05/05 21:39:30 $ 		$Revision: 2.13.3.3 $
#########################################################################


EXECUTABLE	= bterm
MAIN		= bterm.c
INTERFACES	= topLevelShell1.c \
	help_msg.c \
	softkeyform.c 

LANGUAGE        = ANSI C
APPL_OBJS       = UxXt.o UxMethod.o

UX_DIR		= /usr/uimx2.5
UX_LIBPATH	= $(UX_DIR)/lib
X_LIBS		= -lprc -lVt -lXm -lXt -lX11

X_LIBPATH       = -L/usr/lib/X11R5
MOTIF_LIBPATH   = -L/usr/lib/Motif1.2 -L../lib
X_CFLAGS        = -I/usr/include/X11R5
MOTIF_CFLAGS    = -I/usr/include/Motif1.2 -I../include


KR_CC           = cc
ANSI_CC         = cc
CPLUS_CC        = CC
KR_CFLAGS       = -D_NO_PROTO
ANSI_CFLAGS     = -Aa
CPLUS_CFLAGS    = 
CFLAGS          = -DMOTIF -DVT -DSYSV  -DXT_CODE -DXOPEN_CATALOG \
		  $(X_CFLAGS) $(MOTIF_CFLAGS) +DA1.0 +DS1.1
LIBPATH         = $(X_LIBPATH) $(MOTIF_LIBPATH)
LIBS            = $(X_LIBS) -lPW -lm


OBJS = $(MAIN:.c=.o) $(INTERFACES:.c=.o) $(APPL_OBJS)

$(EXECUTABLE): $(OBJS)
	@echo Linking    $(EXECUTABLE)
	$(CC) $(OBJS) $(LIBPATH) $(LIBS) -o $(EXECUTABLE)
	@echo "Done"


.SUFFIXES: 
.SUFFIXES: .o .c .c

.c.o:
	@echo Compiling $< [$(LANGUAGE)] [XT-CODE]
	$(CC) -c $(CFLAGS) $< -o $@
.c.o:
	@echo Compiling $< [$(LANGUAGE)] [XT-CODE]
	$(CC) -c $(CFLAGS) $< -o $@



CC = \
@`if [ "$(LANGUAGE)" = "C++" ]; then echo $(CPLUS_CC) $(CPLUS_CFLAGS);fi` \
`if [ "$(LANGUAGE)" = "ANSI C" ]; then echo $(ANSI_CC) $(ANSI_CFLAGS); fi`\
`if [ "$(LANGUAGE)" = "KR-C" ]; then echo $(KR_CC) $(KR_CFLAGS); fi`
