#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/MenuShell.h>
#include "UxXt.h"

#include <Xm/PushB.h>
#include <Xm/Separator.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/Form.h>

#define  READMODE           ( "r" )
#define  HOME               ( "HOME" )

Widget set_up_popup_menu();
Widget create_one_option();
void dynamic_popup();
void DynamicMenuPost();
void activateCB_dynamic_menu_pb();
void qpretrim();

Widget set_up_popup_menu( parent, name, title )
Widget parent;
char *name;
char *title;
{
    char working_name[BUFSIZ];
    Widget dynamic_menu_shell = NULL;
    Widget dynamic_menu = NULL;
    Widget dynamic_menu2_p1_title = NULL;
    Widget dynamic_menu2_p1_b3 = NULL;

    dynamic_menu_shell = XtVaCreatePopupShell (name,
		    xmMenuShellWidgetClass, parent,
		    XmNwidth, 1,
		    XmNheight, 1,
		    XmNallowShellResize, TRUE,
		    XmNoverrideRedirect, TRUE,
		    NULL );

    sprintf( working_name, "base_%s", name );
    dynamic_menu = XtVaCreateWidget( working_name,
		    xmRowColumnWidgetClass, dynamic_menu_shell,
		    XmNmenuAccelerator, "<KeyUp>F4",
		    XmNrowColumnType, XmMENU_POPUP,
		    NULL );

    sprintf( working_name, "%s_title", name );
    dynamic_menu2_p1_title = XtVaCreateManagedWidget( working_name,
		    xmLabelWidgetClass, dynamic_menu,
		    RES_CONVERT( XmNlabelString, title ),
		    NULL );

    sprintf( working_name, "%s_sep", name );
    dynamic_menu2_p1_b3 = XtVaCreateManagedWidget( working_name,
		    xmSeparatorWidgetClass, dynamic_menu,
		    NULL );

    XtAddEventHandler( parent, ButtonPressMask,
		       False, DynamicMenuPost, dynamic_menu );
    return( dynamic_menu );
}

void DynamicMenuPost( wgt, client_data, event, ctd )
	Widget		wgt;
	XtPointer	client_data;
	XEvent		*event;
	Boolean		*ctd;
{
	Widget	menu = (Widget) client_data;
	int 	which_button;

	XtVaGetValues( menu, XmNwhichButton, &which_button, NULL );

	if ( event->xbutton.button == which_button )
	{
		XmMenuPosition( menu, event );
		XtManageChild( menu );
	}
}

Widget create_one_option( parent, name, lable, value )
Widget parent;
char *name;
char *lable;
char *value;
{
    char *storevalue = NULL;
    char memnonic[2];
    Widget dynamic_menu_pb = NULL;
    memnonic[0]=lable[0];
    memnonic[1]=0;
    dynamic_menu_pb = XtVaCreateManagedWidget( name,
		    xmPushButtonWidgetClass, parent,
		    RES_CONVERT( XmNmnemonic, memnonic ),
		    RES_CONVERT( XmNlabelString, lable ),
		    NULL );
    storevalue = ( char * )malloc( strlen( value ) + 1 );
    strcpy( storevalue, value );
    XtAddCallback( dynamic_menu_pb, XmNactivateCallback,
		    activateCB_dynamic_menu_pb,
		    storevalue );
    return( dynamic_menu_pb );
}
void activateCB_dynamic_menu_pb( UxWidget, UxClientData, UxCallbackArg )
	Widget		UxWidget;
	char *   	UxClientData; 
	XtPointer       UxCallbackArg;
{
        Widget greatgrandfather = NULL;
	greatgrandfather = XtParent( XtParent( XtParent( UxWidget ) ) );
        MyUxPutText( greatgrandfather, ( char * )UxClientData );
}

void dynamic_popup( parent, name, title, filename )
Widget parent;
char *name;
char *title;
char *filename;
{
    char opname[BUFSIZ];
    char lable[BUFSIZ];
    char value[BUFSIZ];
    char bitmap[BUFSIZ];
    int  count = 0;
    int  inx = 0;
    FILE *input_file = NULL;
    char buffer[BUFSIZ];
    Widget new_popup = NULL;
    Widget one_option = NULL;
    input_file = fopen( filename, READMODE );
    if( input_file != NULL )
    {
	new_popup = set_up_popup_menu( parent, name, title );
	while( fgets( buffer, BUFSIZ, input_file ) != NULL )
	{
	    buffer[strlen(buffer)-1] = 0;
	    for( inx = 0; inx < strlen( buffer ); inx++ )
		if( isspace( buffer[inx] ) ) buffer[inx] = ' ';
	    if( buffer[0] != '#' )
	    {
		sprintf( opname, "%sPB%d", name, count++ );
		strcpy( value, strtok( buffer, " " ) );
		qtrim( value );
		qpretrim( value );
		strcpy( lable, strtok( NULL, "" ) );
		qtrim( lable );
		qpretrim( lable );
		one_option=create_one_option( new_popup, opname, lable, value );
	    }
	}
	fclose( input_file );
    }
}

/******************************************************************************/
/*                                                                            */
/* Function name: qpretrim                                                    */
/*                                                                            */
/* Program ID:    full                                                        */
/*                                                                            */
/* Description: Trim leading spaces on a string.                              */
/*                                                                            */
/* Parameters:  string        - char *     - String to operate on             */
/*                                                                            */
/* Input:      string                                                         */
/*                                                                            */
/* Output:     None                                                           */
/*                                                                            */
/* Special Logic Notes: None                                                  */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/*                            MODIFICATION LOG                                */
/*                                                                            */
/*    DATE        AUTHOR         DESCRIPTION                                  */
/*  --------    --------------   -------------------------------------------- */
/*  07/07/93    Bruce M. Corwin  Initial Release                              */
/*                                                                            */
/******************************************************************************/
void qpretrim( string )
char *string;
{
    int inx = 0;
    int jnx = 0;
    int flag = 0;
    for( inx = 0; inx <= strlen( string ); inx++ )
    {
        if( !isspace( string[inx] ) )
            flag = -1;
        if( flag )
            string[jnx++] = string[inx];
    }
}
