#########################################################################
# 
#    	MAKEFILE FOR STAND-ALONE APPLICATION [XT-CODE].
#
#       EXECUTABLE      is the name of the executable to be created 
#       MAIN            is the .c file containing your main() function
#       INTERFACES      is a list of the generated C code files 
#       APP_OBJS        is a (possibly empty) list of the object code
#                       files that form the non-interface portion of
#                       your application 
#
#       In the first several statements, the variables on the right 
#	of the equal sign will be replaced with their corresponding 
#       values when the makefile is automatically generated. 
#
#       This template is used for makefiles which do not reference
#       the Ux runtime library.
#
#  	$Date: 94/05/10 03:09:57 $ 		$Revision: 1.1 $
#########################################################################

EXECUTABLE	= ftpterm
MAIN		= ftpterm.c
INTERFACES	= topLevelShell1.c \
	help_msg.c \
	login_dialog.c \
	file_dialog.c \
	lfile_dialog.c 

LANGUAGE        = ANSI C
APPL_OBJS       = UxXt.o UxMethod.o dynamic_popup.o

UIL_FILES       =
UILFILES        =
UIDFILES        =
UIL	        =
# UIL compiler, if needed, must be in PATH, or be an absolute pathname.

CODE_TYPE       = XT-CODE
UX_DIR	        = /usr/uimx2.6
UX_LIBPATH      =
UX_INCPATH      =
UX_LIB	        =
DXT	        = -DXT_CODE
DUIL	        =
MRMLIB	        =



# Changes below this line may be appropriate for other templates as well.

SHELL		= /bin/sh

X_LIBS	        = $(MRMLIB) -lprc -lVt -lXm /usr/std/lib/X11R5/libXmu.a -lXt -lX11

X_LIBPATH       = -L/usr/lib/X11R5
MOTIF_LIBPATH   = -L/usr/lib/Motif1.2
X_CFLAGS        = -I/usr/include/X11R5
MOTIF_CFLAGS    = -DMOTIF -I/usr/include/Motif1.2

KR_CC           = cc
ANSI_CC         = cc 
CPLUS_CC        = cc
KR_CFLAGS	= -D_NO_PROTO -Wp,-H400000 -z
ANSI_CFLAGS	= -Aa
CPLUS_CFLAGS	= +a1 -Aa

CFLAGS          = -DMOTIF +O3 -Y -DSYSV -DVT -DXOPEN_CATALOG -D_HPUX_SOURCE \
		  $(UX_INCPATH) -I../include \
		  $(X_CFLAGS) $(MOTIF_CFLAGS) $(DXT) $(DUIL) \
		  +DA1.0 +DS1.1
LIBPATH	        = $(UX_LIBPATH) $(MOTIF_LIBPATH) $(X_LIBPATH) -L../lib
LIBS            = $(UX_LIB) $(X_LIBS) -lPW -lm


OBJS = $(MAIN:.c=.o) $(INTERFACES:.c=.o) \
       $(APPL_OBJS) $(EXTRA_OBJS)

$(EXECUTABLE): $(OBJS) $(UIDFILES)
	@echo Linking    $(EXECUTABLE)
	@$(CPLUS_CC) $(OBJS) $(LIBPATH) $(LIBS) -o $(EXECUTABLE)
	@echo "Done"



.SUFFIXES: 
.SUFFIXES: .o .uil .uid .c .c

.c.o:
	@echo Compiling $< [$(LANGUAGE)] [$(CODE_TYPE)]
	$(CC) -c $(CFLAGS) $< -o $@
.c.o:
	@echo Compiling $< [$(LANGUAGE)] [$(CODE_TYPE)]
	$(CC) -c $(CFLAGS) $< -o $@

.uil.uid:
	@echo Compiling  $< [UIL]
	@$(UIL) -s $< -o $@
# Remove -s option from previous line for UIL compiles without locale flag set


UxMethod.o: UxMethod.c
	@echo Compiling $< [ANSI-C] [$(CODE_TYPE)]
	@$(ANSI_CC) $(ANSI_CFLAGS) $(CFLAGS) -c $< -o $@


CC = \
@`if [ "$(LANGUAGE)" = "C++" ]; then echo $(CPLUS_CC) $(CPLUS_CFLAGS);fi` \
`if [ "$(LANGUAGE)" = "ANSI C" ]; then echo $(ANSI_CC) $(ANSI_CFLAGS); fi`\
`if [ "$(LANGUAGE)" = "KR-C" ]; then echo $(KR_CC) $(KR_CFLAGS); fi`

LD = \
@`if [ "$(LANGUAGE)" = "C++" ]; then echo $(CPLUS_CC);fi` \
`if [ "$(LANGUAGE)" = "ANSI C" ]; then echo $(ANSI_CC); fi`\
`if [ "$(LANGUAGE)" = "KR-C" ]; then echo $(KR_CC); fi`

LD_FLAGS = \
`if [ "$(LANGUAGE)" = "C++" ]; then echo $(CPLUS_LDFLAGS);fi`\
`if [ "$(LANGUAGE)" = "ANSI C" ]; then echo $(ANSI_LDFLAGS); fi`\
`if [ "$(LANGUAGE)" = "KR-C" ]; then echo $(KR_LDFLAGS); fi`


