
/*******************************************************************************
	lfile_dialog.c

       Associated Header file: lfile_dialog.h
*******************************************************************************/

#include <stdio.h>

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/MwmUtil.h>
#include <X11/Shell.h>
#include <Xm/MenuShell.h>
#endif /* MOTIF */

#include "UxXt.h"
#include <Xm/FileSB.h>

/*******************************************************************************
       Includes, Defines, and Global variables from the Declarations Editor:
*******************************************************************************/


extern Widget vt1;
void popup_lfile_dialog();


static	int _UxIfClassId;
/*******************************************************************************
       The following header file defines the context structure.
*******************************************************************************/

#ifndef XKLOADDS
#define XKLOADDS
#endif /* XKLOADDS */

#define CONTEXT_MACRO_ACCESS 1
#include "lfile_dialog.h"
#undef CONTEXT_MACRO_ACCESS

Widget	lfile_dialog;

/*******************************************************************************
Auxiliary code from the Declarations Editor:
*******************************************************************************/

void popup_lfile_dialog()
{
    UxPopupInterface( lfile_dialog, no_grab );
}

/*******************************************************************************
       The following are callback functions.
*******************************************************************************/

static void  cancelCB_lfile_dialog(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxClfile_dialog        *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxLfile_dialogContext;
	UxLfile_dialogContext = UxContext =
			(_UxClfile_dialog *) UxGetContext( UxWidget );
	{
	UxPopdownInterface( lfile_dialog );
	}
	UxLfile_dialogContext = UxSaveCtx;
}

static void  okCallback_lfile_dialog(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxClfile_dialog        *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxLfile_dialogContext;
	UxLfile_dialogContext = UxContext =
			(_UxClfile_dialog *) UxGetContext( UxWidget );
	{
	char command[BUFSIZ];
	XmFileSelectionBoxCallbackStruct *call_data;
	char *line = NULL;
	int inx = 0;
	int jnx = 0;
	char tempname[BUFSIZ];
	
#ifdef VT
	call_data = ( XmFileSelectionBoxCallbackStruct * )UxCallbackArg;
	XmStringGetLtoR( call_data->value, XmSTRING_DEFAULT_CHARSET, &line );
	for( inx = 0; inx <= strlen( line ); inx++ )
	{
	    tempname[jnx++] = line[inx];
	    if( line[inx] == '/' ) jnx = 0;
	}
	sprintf( command, "put %s %s\n", line, tempname );
	XmVtSend( vt1, command );
#endif
	}
	UxLfile_dialogContext = UxSaveCtx;
}

/*******************************************************************************
       The 'build_' function creates all the widgets
       using the resource values specified in the Property Editor.
*******************************************************************************/

static Widget	_Uxbuild_lfile_dialog()
{
	Widget		_UxParent;


	/* Creation of lfile_dialog */
	_UxParent = XtVaCreatePopupShell( "lfile_dialog_shell",
			topLevelShellWidgetClass, UxTopLevel,
			XmNx, 391,
			XmNy, 400,
			XmNwidth, 533,
			XmNheight, 427,
			XmNallowShellResize, TRUE,
			XmNshellUnitType, XmPIXELS,
			XmNtitle, "lfile_dialog",
			XmNiconName, "lfile_dialog",
			NULL );

	lfile_dialog = XtVaCreateManagedWidget( "lfile_dialog",
			xmFileSelectionBoxWidgetClass,
			_UxParent,
			XmNresizePolicy, XmRESIZE_ANY,
			XmNunitType, XmPIXELS,
			XmNwidth, 533,
			XmNheight, 427,
			RES_CONVERT( XmNdialogTitle, "Local Files" ),
			XmNnoResize, FALSE,
			NULL );
	XtAddCallback( lfile_dialog, XmNcancelCallback,
		(XtCallbackProc) cancelCB_lfile_dialog,
		(XtPointer) UxLfile_dialogContext );
	XtAddCallback( lfile_dialog, XmNokCallback,
		(XtCallbackProc) okCallback_lfile_dialog,
		(XtPointer) UxLfile_dialogContext );

	UxPutContext( lfile_dialog, (char *) UxLfile_dialogContext );
	UxPutClassCode( lfile_dialog, _UxIfClassId );


	XtAddCallback( lfile_dialog, XmNdestroyCallback,
		(XtCallbackProc) UxDestroyContextCB,
		(XtPointer) UxLfile_dialogContext);


	return ( lfile_dialog );
}

/*******************************************************************************
       The following is the 'Interface function' which is the
       external entry point for creating this interface.
       This function should be called from your application or from
       a callback function.
*******************************************************************************/

Widget	create_lfile_dialog()
{
	Widget                  rtrn;
	_UxClfile_dialog        *UxContext;
	static int		_Uxinit = 0;

	UxLfile_dialogContext = UxContext =
		(_UxClfile_dialog *) UxNewContext( sizeof(_UxClfile_dialog), False );


	if ( ! _Uxinit )
	{
		_UxIfClassId = UxNewInterfaceClassId();
		_Uxinit = 1;
	}

	rtrn = _Uxbuild_lfile_dialog();

	return(rtrn);
}

/*******************************************************************************
       END OF FILE
*******************************************************************************/

