/*+****************************************************************************/
/*+                                                                           */
/*+ Copyright (c) 1996 Bruce M. Corwin                                        */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Program ID:  genesc                                                       */
/*+                                                                           */
/*+ Description: This program is used to generate the include file screen.h.  */
/*+              This include file has many of the explicit escape sequences  */
/*+              as well as integer defines that numericaly identify those    */
/*+              sequences.                                                   */
/*+                                                                           */
/*+ Entry Points: main()                                                      */
/*+                                                                           */
/*+ Input Parms:  None                                                        */
/*+                                                                           */
/*+ Exit Value:   None                                                        */
/*+                                                                           */
/*+ Input Files:  User Specified                                              */
/*+                                                                           */
/*+ Output Files: None                                                        */
/*+                                                                           */
/*+ Link Procedures: None                                                     */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  01-30-96    Bruce M. Corwin   Initial Release                            */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Module Name: genesc.c                                                     */
/*+                                                                           */
/*+ Program ID:  genesc                                                       */
/*+                                                                           */
/*+ Functions:  main                                                          */
/*+                                                                           */
/*+****************************************************************************/

#include <stdio.h>
#include <string.h>

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: main                                                       */
/*+                                                                           */
/*+ Program ID:    genesc                                                     */
/*+                                                                           */
/*+ Description: This main routine performs an input of the screen.dat file   */
/*+              parsing it for first the define value and then the escape    */
/*+              sequence. It ignores lines begining with #.                  */
/*+                                                                           */
/*+ Parameters: argc          - int        - Number of command line           */
/*+                                          parameters passed from the       */
/*+                                          invoking environment             */
/*+             argv          - char *[]   - Array of command line parameters */
/*+                                          passed from the invoking         */
/*+                                          environment                      */
/*+                                                                           */
/*+ Input:      argc, argv                                                    */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  01-30-96    Bruce M. Corwin   Initial Release                            */
/*+                                                                           */
/*+****************************************************************************/
int main (argc, argv)
     int argc;
     char *argv[];
{
    FILE *table_fp = NULL;
    FILE *include_fp = NULL;
    char buffer[BUFSIZ];
    int count = 0;
    char *name = NULL;
    char *seq = NULL;
    int rcode = 0;
    char *seqarray[2000];
    int inx = 0;

    if (argc == 3)
    {
	table_fp = fopen (argv[1], "r");
	include_fp = fopen (argv[2], "w");
	if (table_fp != NULL && include_fp != NULL)
	{
	    fprintf
		(
		    include_fp,
		    "#define BADCOMMAND             (-1)\n"
		);
	    while (fgets (buffer, BUFSIZ, table_fp) != NULL)
	    {
		buffer[strlen (buffer) - 1] = 0;
		if (buffer[0] != '#')
		{
		    name = strtok (buffer, ":");
		    if (name == NULL)
		    {
			fprintf (stderr, "genesc: format error on table.\n");
			rcode = 1;
			break;
		    }
		    seq = strtok (NULL, ":");
		    if (seq == NULL)
		    {
			fprintf (stderr, "genesc: format error on table.\n");
			rcode = 2;
			break;
		    }
		    fprintf
			(
			    include_fp,
			    "#define %-15s        (%d)\n", name, count
			);
		    seqarray[count] = (char *) malloc (strlen (seq) + 1);
		    strcpy (seqarray[count], seq);
		    count++;
		}
	    }
	}
	else
	{
	    fprintf (stderr, "genesc: file open error.\n");
	    rcode = 3;
	}
	if (table_fp != NULL)
	    fclose (table_fp);
	if (include_fp != NULL)
	{
	    fprintf
		(
		    include_fp,
		    "#define NUMVT100               (%d)\n", count + 1
		);
	    fprintf
		(
		    include_fp,
		    "\nchar *vt100[NUMVT100] =\n{\n"
		);
	    for (inx = 0; inx < count; inx++)
	    {
		fprintf (include_fp, "    \"%s\",\n", seqarray[inx]);
		free (seqarray[inx]);
	    }
	    fprintf
		(
		    include_fp,
		    "    NULL\n};\n"
		);
	    fprintf (include_fp, "#ifndef True\n");
	    fprintf (include_fp, "#define True (1)\n");
	    fprintf (include_fp, "#endif\n");
	    fprintf (include_fp, "#ifndef False\n");
	    fprintf (include_fp, "#define False (0)\n");
	    fprintf (include_fp, "#endif\n");
	    fprintf (include_fp, "#ifdef NOTX\n");
	    fprintf (include_fp, "#define Boolean        int\n");
	    fprintf (include_fp, "#endif\n");
	}
	if (include_fp != NULL)
	    fclose (include_fp);
    }
    else
    {
	fprintf (stderr, "genesc: usage error.\n");
	fprintf (stderr, "genesc screen.dat screen.h\n");
	rcode = 4;
    }
    return (rcode);
}
