/*+****************************************************************************/
/*+                                                                           */
/*+ Copyright (c) 1992-1996 Bruce M. Corwin                                   */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Module Name: register.c                                                   */
/*+                                                                           */
/*+ Program ID:  Process Control Sub                                          */
/*+                                                                           */
/*+ Functions:  addutmp, addutmp, delutmp, delutmp,                           */
/*+             getuser                                                       */
/*+                                                                           */
/*+****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <utmp.h>
#include <pwd.h>
void getuser ();
void addutmp ();
void delutmp ();
struct utmp saveent;
#define  LOGIN       ( "LOGIN" )
#ifdef _HPUX_SOURCE

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: addutmp                                                    */
/*+                                                                           */
/*+ Program ID:    Process Control Sub                                        */
/*+                                                                           */
/*+ Description: This function is used to register an interactive session     */
/*+              with the utmp system file. It varies between different types */
/*+              of UNIX systems so there are several different #ifdefs to    */
/*+              distinguish between the methods useds. It stores the utmp    */
/*+              structure in a global varable for delutmp to access in the   */
/*+              future. addutmp and delutmp are not multithreaded compatable */
/*+              routines as a result of this storage of global information.  */
/*+              This routine stores the time, userid, ttyline and DISPLAY    */
/*+              variable in the utmp structure.                              */
/*+                                                                           */
/*+ Parameters: user          - char *     - Input username to register.      */
/*+             ttyxx         - char *     - The tty line to register.        */
/*+             pid           - int        - Input pid to register.           */
/*+                                                                           */
/*+ Input:      user, ttyxx, pid                                              */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  11-08-91    Bruce M Corwin   Initial Release                             */
/*+                                                                           */
/*+****************************************************************************/
void addutmp (user, ttyxx, pid)
     char *user;
     char *ttyxx;
     int pid;
{
    char *display = NULL;
    struct utmp newent;
    struct utmp blank;
    struct utmp *cur;
    struct utmp *res;
    setutent ();
    strncpy (newent.ut_user, user, 8);
    display = getenv ("DISPLAY");
    if (display != NULL)
	strncpy (newent.ut_host, display, 16);
    else
	strcpy (newent.ut_host, "unknown");
    strcpy (newent.ut_line, ttyxx);
    newent.ut_id[0] = ' ';
    newent.ut_id[1] = ' ';
    newent.ut_id[2] = newent.ut_line[3];
    newent.ut_id[3] = newent.ut_line[4];
    newent.ut_type = USER_PROCESS;
    newent.ut_pid = pid;
    time (&newent.ut_time);
    res = _pututline (&newent);
    saveent = newent;
    endutent ();
    if (res == NULL)
	fprintf (stderr, "Warning: Could not register process.\n");
}
#else

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: addutmp                                                    */
/*+                                                                           */
/*+ Program ID:    Process Control Sub                                        */
/*+                                                                           */
/*+ Description: This function is used to register an interactive session     */
/*+              with the utmp system file. It varies between different types */
/*+              of UNIX systems so there are several different #ifdefs to    */
/*+              distinguish between the methods useds. It stores the utmp    */
/*+              structure in a global varable for delutmp to access in the   */
/*+              future. addutmp and delutmp are not multithreaded compatable */
/*+              routines as a result of this storage of global information.  */
/*+              This routine stores the time, userid, ttyline and DISPLAY    */
/*+              variable in the utmp structure.                              */
/*+                                                                           */
/*+ Parameters: user          - char *     - Input username to register.      */
/*+             ttyxx         - char *     - The tty line to register.        */
/*+             pid           - int        - Input pid to register.           */
/*+                                                                           */
/*+ Input:      user, ttyxx, pid                                              */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  11-08-91    Bruce M Corwin   Initial Release                             */
/*+                                                                           */
/*+****************************************************************************/
void addutmp (user, ttyxx, pid)
     char *user;
     char *ttyxx;
     int pid;
{
    fprintf
	(
      stderr, "Warning: Utmp entry insert is not implemented for this OS.\n"
	);
}
#endif
#ifdef _HPUX_SOURCE

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: delutmp                                                    */
/*+                                                                           */
/*+ Program ID:    Process Control Sub                                        */
/*+                                                                           */
/*+ Description: This function is used to unregister an interactive session   */
/*+              with the utmp system file. It is the inverse function to     */
/*+              addutmp. It varies between different types of UNIX systems   */
/*+              so there are several different #ifdefs to distinguish        */
/*+              between the methods useds. It uses the stored global utmp    */
/*+              structure to remove the utmp entry.                          */
/*+                                                                           */
/*+ Parameters: None                                                          */
/*+                                                                           */
/*+ Input:      None                                                          */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  11-08-91    Bruce M Corwin   Initial Release                             */
/*+                                                                           */
/*+****************************************************************************/
void delutmp ()
{
    struct utmp *res;
    saveent.ut_exit.e_termination = 0;
    saveent.ut_exit.e_exit = 0;
    saveent.ut_type = DEAD_PROCESS;
    time (&(saveent.ut_time));
    res = _pututline (&saveent);
    if (res == NULL)
	fprintf (stderr, "Warning: Could not unregister process.\n");
    endutent ();
}
#else

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: delutmp                                                    */
/*+                                                                           */
/*+ Program ID:    Process Control Sub                                        */
/*+                                                                           */
/*+ Description: This function is used to unregister an interactive session   */
/*+              with the utmp system file. It is the inverse function to     */
/*+              addutmp. It varies between different types of UNIX systems   */
/*+              so there are several different #ifdefs to distinguish        */
/*+              between the methods useds. It uses the stored global utmp    */
/*+              structure to remove the utmp entry.                          */
/*+                                                                           */
/*+ Parameters: ttyxx         - char *     - The tty line to register.        */
/*+                                                                           */
/*+ Input:      ttyxx                                                         */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  11-08-91    Bruce M Corwin   Initial Release                             */
/*+                                                                           */
/*+****************************************************************************/
void delutmp (ttyxx)
     char *ttyxx;
{
    fprintf
	(
     stderr, "Warning: Utmp entry removal is not implemented for this OS.\n"
	);
}
#endif

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: getuser                                                    */
/*+                                                                           */
/*+ Program ID:    Process Control Sub                                        */
/*+                                                                           */
/*+ Description: This function returns the current username as determined     */
/*+              from the real UID.                                           */
/*+                                                                           */
/*+ Parameters: user          - char *     - Input username to register.      */
/*+                                                                           */
/*+ Input:      user                                                          */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  08-10-93    Bruce M. Corwin  Initial Release                             */
/*+                                                                           */
/*+****************************************************************************/
void getuser (user)
     char *user;
{
    int uid = 0;
    struct passwd *here;
    uid = getuid ();
    here = (struct passwd *) getpwuid (uid);
    strcpy (user, here->pw_name);
}
