/*+****************************************************************************/
/*+                                                                           */
/*+ Copyright (c) 1995-1996 Bruce M. Corwin                                   */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Program ID:  vls                                                          */
/*+                                                                           */
/*+ Description: This program is used similer to ls with a long listing. The  */
/*+              main difference is that it highlights directories with       */
/*+              underscores. These underscores then can be traversed by      */
/*+              clicking on them with the mouse.                             */
/*+                                                                           */
/*+ Entry Points: main()                                                      */
/*+                                                                           */
/*+ Input Parms:  None                                                        */
/*+                                                                           */
/*+ Exit Value:   None                                                        */
/*+                                                                           */
/*+ Input Files:  User Specified                                              */
/*+                                                                           */
/*+ Output Files: None                                                        */
/*+                                                                           */
/*+ Link Procedures: None                                                     */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  05-22-95    Bruce M. Corwin   Initial Release                            */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Module Name: vls.c                                                        */
/*+                                                                           */
/*+ Program ID:  vls                                                          */
/*+                                                                           */
/*+ Functions:  main, output_special, set_value                               */
/*+                                                                           */
/*+****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
int output_special ();
void set_value ();

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: main                                                       */
/*+                                                                           */
/*+ Program ID:    vls                                                        */
/*+                                                                           */
/*+ Description: This program calls ls with the long listing and a -p flag to */
/*+              determine which lines are subdirectories.                    */
/*+                                                                           */
/*+ Parameters: argc          - int        - Number of command line           */
/*+                                          parameters passed from the       */
/*+                                          invoking environment             */
/*+             argv          - char *[]   - Array of command line parameters */
/*+                                          passed from the invoking         */
/*+                                          environment                      */
/*+                                                                           */
/*+ Input:      argc, argv                                                    */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  05-22-95    Bruce M. Corwin   Initial Release                            */
/*+                                                                           */
/*+****************************************************************************/
int main (argc, argv)
     int argc;
     char *argv[];
{
    FILE *dirout = NULL;
    char command[BUFSIZ];
    char hyper[BUFSIZ];
    char buffer[BUFSIZ];
    int checkc = 0;
    int inx = 0;
    char pwd[BUFSIZ];
    char *term = NULL;
    int flag = 0;

    term = getenv ("TERM");
    if (term != NULL && strcmp (term, "console") != 0 && strcmp (term, "vt100") != 0 && strcmp (term, "hpterm") != 0)
	flag = -1;
    getcwd (pwd, BUFSIZ);
    if (argc > 1 && argv[1][0] != '-')
	strcpy (pwd, argv[1]);
    if (pwd[strlen (pwd) - 1] != '/')
	strcat (pwd, "/");
    sprintf (hyper, "cd %s\\s\\ntput clear\\nvls\\n", pwd);
    if (flag)
	set_value ("hyperFilter", hyper);
    strcpy (command, "ls -L -a -l -p");
    for (inx = 1; inx < argc; inx++)
    {
	strcat (command, " ");
	strcat (command, argv[inx]);
    }
    dirout = popen (command, "r");
    if (dirout != NULL)
    {
	while (fgets (buffer, BUFSIZ, dirout) != NULL)
	{
	    buffer[strlen (buffer) - 1] = 0;
	    checkc = buffer[strlen (buffer) - 1];
            if (flag)
            {
		if (checkc != '/')
		{
		    puts (buffer);
		}
		else
		{
		    buffer[strlen (buffer) - 1] = 0;
		    output_special (buffer);
		}
	    }
            else
            {
		puts (buffer);
            }
	}
	pclose (dirout);
    }
    return (0);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: output_special                                             */
/*+                                                                           */
/*+ Program ID:    vls                                                        */
/*+                                                                           */
/*+ Description: This routine check through a line and finds the last word    */
/*+              that is delimited by a space. It then highlights and         */
/*+              underlines this word.                                        */
/*+                                                                           */
/*+ Parameters: buffer        - char *     - String to output.                */
/*+                                                                           */
/*+ Input:      buffer                                                        */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  01/05/96    Bruce M. Corwin  Initial Release                             */
/*+                                                                           */
/*+****************************************************************************/
int output_special (buffer)
     char *buffer;
{
    int inx = 0;
    int mark = 0;
    char first[BUFSIZ];
    char last[BUFSIZ];
    for (inx = strlen (buffer) - 1; inx >= 0; inx--)
    {
	if (buffer[inx] == ' ')
	{
	    mark = inx + 1;
	    break;
	}
    }
    strcpy (last, buffer + mark);
    strcpy (first, buffer);
    first[mark] = 0;
    printf ("%s\033[1m\033[4m%s\033[0m\n", first, last);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: set_value                                                  */
/*+                                                                           */
/*+ Program ID:    vls                                                        */
/*+                                                                           */
/*+ Description: This routine is used to set a resource value for the local   */
/*+              Vt widget.                                                   */
/*+                                                                           */
/*+ Parameters: resource      - char *     - Resource to define.              */
/*+             value         - char *     - Value to set resource to.        */
/*+                                                                           */
/*+ Input:      resource, value                                               */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  01/05/96    Bruce M. Corwin  Initial Release                             */
/*+                                                                           */
/*+****************************************************************************/
void set_value (resource, value)
     char *resource;
     char *value;
{
    printf ("\033}8:%s:%s\007", resource, value);
    fflush (stdout);
}
