/*+****************************************************************************/
/*+                                                                           */
/*+ Copyright (c) 1992-1997 Bruce M. Corwin                                   */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Module Name: attributes.c                                                 */
/*+                                                                           */
/*+ Program ID:  vtwidget                                                     */
/*+                                                                           */
/*+ Functions:  set, clr, isset, reset_attr, isany,                           */
/*+             isnone, hasmatching, isequal                                  */
/*+                                                                           */
/*+****************************************************************************/

#include "attributes.h"

#define  SET(val,flag)          (val)|=(1<<flag)
#define  CLR(val,flag)          (val)&=~(1<<flag)
#define  ISSET(val,flag)        (val&(1<<flag))!=0
#define  ISANY(val)             (val)!=0
#define  RESET_ATTR(val)        (val)=0
#define  ISNONE(val)            (val)==0
#define  ISEQUAL(val1,val2)     (val1)==(val2)
#define  HASMATCHING(val1,val2) (val1)&(val2)


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: set                                                        */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function sets the appropriate bit in an attribute.      */
/*+                                                                           */
/*+ Parameters: attr          - attribute *                                   */
/*+                                        - Type of characters               */
/*+             flag          - int        - Modified flag                    */
/*+                                                                           */
/*+ Input:      attr, flag                                                    */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void set (attribute * attr, int flag)
{
    switch (flag / 8)
    {
	case 0:
	    SET (attr->attrib0, flag);
	    break;
	case 1:
	    SET (attr->attrib1, flag - 8);
	    break;
	case 2:
	    SET (attr->attrib2, flag - 16);
	    break;
	case 3:
	    SET (attr->attrib3, flag - 24);
	    break;
	case 4:
	    SET (attr->attrib4, flag - 32);
	    break;
	case 5:
	    SET (attr->attrib5, flag - 40);
	    break;
	case 6:
	    SET (attr->attrib6, flag - 48);
	    break;
	case 7:
	    SET (attr->attrib7, flag - 56);
	    break;
    }
    return;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: clr                                                        */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function clears the appropriate bit in an attribute.    */
/*+                                                                           */
/*+ Parameters: attr          - attribute *                                   */
/*+                                        - Type of characters               */
/*+             flag          - int        - Modified flag                    */
/*+                                                                           */
/*+ Input:      attr, flag                                                    */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void clr (attribute * attr, int flag)
{
    switch (flag / 8)
    {
	case 0:
	    CLR (attr->attrib0, flag);
	    break;
	case 1:
	    CLR (attr->attrib1, flag - 8);
	    break;
	case 2:
	    CLR (attr->attrib2, flag - 16);
	    break;
	case 3:
	    CLR (attr->attrib3, flag - 24);
	    break;
	case 4:
	    CLR (attr->attrib4, flag - 32);
	    break;
	case 5:
	    CLR (attr->attrib5, flag - 40);
	    break;
	case 6:
	    CLR (attr->attrib6, flag - 48);
	    break;
	case 7:
	    CLR (attr->attrib7, flag - 56);
	    break;
    }
    return;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: isset                                                      */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is a boolean function that determines if a     */
/*+              particular bit is set in an attribute.                       */
/*+                                                                           */
/*+ Parameters: attr          - attribute  - Type of characters               */
/*+             flag          - int        - Modified flag                    */
/*+                                                                           */
/*+ Input:      attr, flag                                                    */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int isset (attribute attr, int flag)
{
    int rcode = 0;
    switch (flag / 8)
    {
	case 0:
	    rcode = ISSET (attr.attrib0, flag);
	    break;
	case 1:
	    rcode = ISSET (attr.attrib1, flag - 8);
	    break;
	case 2:
	    rcode = ISSET (attr.attrib2, flag - 16);
	    break;
	case 3:
	    rcode = ISSET (attr.attrib3, flag - 24);
	    break;
	case 4:
	    rcode = ISSET (attr.attrib4, flag - 32);
	    break;
	case 5:
	    rcode = ISSET (attr.attrib5, flag - 40);
	    break;
	case 6:
	    rcode = ISSET (attr.attrib6, flag - 48);
	    break;
	case 7:
	    rcode = ISSET (attr.attrib7, flag - 56);
	    break;
    }
    return (rcode);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: reset_attr                                                 */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function clears an attribute variable.                  */
/*+                                                                           */
/*+ Parameters: attr          - attribute *                                   */
/*+                                        - Type of characters               */
/*+                                                                           */
/*+ Input:      attr                                                          */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void reset_attr (attribute * attr)
{
    attr->attrib0 = 0;
    attr->attrib1 = 0;
    attr->attrib2 = 0;
    attr->attrib3 = 0;
    attr->attrib4 = 0;
    attr->attrib5 = 0;
    attr->attrib6 = 0;
    attr->attrib7 = 0;
    return;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: isany                                                      */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is true if any attributes are set in an        */
/*+              attribute variable.                                          */
/*+                                                                           */
/*+ Parameters: attr          - attribute  - Type of characters               */
/*+                                                                           */
/*+ Input:      attr                                                          */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int isany (attribute attr)
{
    int rcode = 0;
    int sum = 0;
    sum = attr.attrib0 | attr.attrib1 | attr.attrib2 | attr.attrib3 |
	attr.attrib4 | attr.attrib5 | attr.attrib6 | attr.attrib7;
    if (sum)
	rcode = -1;
    return (rcode);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: isnone                                                     */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is true only if there are no attributes set in */
/*+              an attribute variable.                                       */
/*+                                                                           */
/*+ Parameters: attr          - attribute  - Type of characters               */
/*+                                                                           */
/*+ Input:      attr                                                          */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int isnone (attribute attr)
{
    int rcode = 0;
    int sum = 0;
    sum = attr.attrib0 | attr.attrib1 | attr.attrib2 | attr.attrib3 |
	attr.attrib4 | attr.attrib5 | attr.attrib6 | attr.attrib7;
    if (sum == 0)
	rcode = -1;
    return (rcode);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: hasmatching                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function compares two attribute variables to determine  */
/*+              if they have any matching set attributes.                    */
/*+                                                                           */
/*+ Parameters: attr1         - attribute  - Attribute number 1 for compare.  */
/*+             attr2         - attribute  - Attribute number 2 for compare.  */
/*+                                                                           */
/*+ Input:      attr1, attr2                                                  */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int hasmatching (attribute attr1, attribute attr2)
{
    int rcode = 0;
    if ((attr1.attrib0 & attr2.attrib0))
	rcode = -1;
    if ((attr1.attrib1 & attr2.attrib1))
	rcode = -1;
    if ((attr1.attrib2 & attr2.attrib2))
	rcode = -1;
    if ((attr1.attrib3 & attr2.attrib3))
	rcode = -1;
    if ((attr1.attrib4 & attr2.attrib4))
	rcode = -1;
    if ((attr1.attrib5 & attr2.attrib5))
	rcode = -1;
    if ((attr1.attrib6 & attr2.attrib6))
	rcode = -1;
    if ((attr1.attrib7 & attr2.attrib7))
	rcode = -1;
    return (rcode);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: isequal                                                    */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is true if the two provided attribute          */
/*+              variables have the same attributes set.                      */
/*+                                                                           */
/*+ Parameters: attr1         - attribute  - Attribute number 1 for compare.  */
/*+             attr2         - attribute  - Attribute number 2 for compare.  */
/*+                                                                           */
/*+ Input:      attr1, attr2                                                  */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int isequal (attribute attr1, attribute attr2)
{
    int rcode = 0;
    int dat0 = 0;
    int dat1 = 0;
    int dat2 = 0;
    int dat3 = 0;
    int dat4 = 0;
    int dat5 = 0;
    int dat6 = 0;
    int dat7 = 0;
    dat0 = (attr1.attrib0 == attr2.attrib0);
    dat1 = (attr1.attrib1 == attr2.attrib1);
    dat2 = (attr1.attrib2 == attr2.attrib2);
    dat3 = (attr1.attrib3 == attr2.attrib3);
    dat4 = (attr1.attrib4 == attr2.attrib4);
    dat5 = (attr1.attrib5 == attr2.attrib5);
    dat6 = (attr1.attrib6 == attr2.attrib6);
    dat7 = (attr1.attrib7 == attr2.attrib7);
    if (dat0 && dat1 && dat2 && dat3 && dat4 && dat5 && dat6 && dat7)
	rcode = -1;
    return (rcode);
}
