#ifndef _PI_UTILS_
#define _PI_UTILS_

///////////////////////////////////////////////////////////////////////
//
// General I/O routines & utility functions
// Written by Neville Richards
//
///////////////////////////////////////////////////////////////////////

#ifndef _BREEZE_PLUGIN_
#include "plugin.h"
#endif
#ifndef _PI_TOOLS_
#include "pitools.h"
#endif

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif	/* __cplusplus */

#ifndef PIEXPORT
#define PIEXPORT	__declspec( dllexport ) extern
#endif

typedef PointXYZ Point3d, POINT3D, *LPPOINT3D;


///////////////////////////////////////////////////////////////////////
//
// Debugging Routines
//
///////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
PIEXPORT void FAR cdecl pitTracePrintf(LPSTR lpFmt, ...);
PIEXPORT void FAR cdecl pitTracePrintfF( LPSTR lpFmt, ...);

#ifndef TRACE
#define TRACE pitTracePrintf
#endif
#define TRACEF pitTracePrintfF
#ifndef ASSERT
#define ASSERT(p) if(!(p)) pitTracePrintf(" ASSERTion failed: %s\n", (LPSTR)#p);
#endif

#else
PIEXPORT void FAR cdecl pitTracePrintf(LPSTR lpFmt, ...);
PIEXPORT void FAR cdecl pitTracePrintfF( LPSTR lpFmt, ...);

#ifndef TRACE
#define TRACE 1 ? (void)0: pitTracePrintf
#endif
#define TRACEF 1 ? (void)0: pitTracePrintf
#ifndef ASSERT
#define ASSERT(p)
#endif
#endif

//
// Standard library functions
//
PIEXPORT BOOL piLibInit( UINT nVersion, LPPLUGININFO lpInfo, LPPIFNS lpFunctions, UINT nFunctions );
PIEXPORT BOOL piLibFuncInit( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData, UINT nMode );
PIEXPORT BOOL piLibDefault( DWORD nOperation, LPVOID lpLocalData, LPPLUGINDATA lpCall );
PIEXPORT BOOL piGetLocalPluginProperty( LPPIPROPERTY lpProp, LPPIPROPERTY lpSettings );
PIEXPORT BOOL piSetLocalPluginProperty( LPPIPROPERTY lpProp, LPPIPROPERTY lpSettings );


//
// Point handling functions
//
PIEXPORT BOOL CopyPoint( const Point3d *pSource, Point3d *pDest );
PIEXPORT BOOL ZeroPoint( Point3d *pPoint );

//
// File I/O Routines
//
PIEXPORT BOOL FlushLine( HFILE fh );
PIEXPORT BOOL RewindLine( HFILE fh );
PIEXPORT int GetChar( HFILE fh );
PIEXPORT LPSTR GetLine( HFILE fh );
PIEXPORT LPSTR GetNextArg( HFILE fh );
PIEXPORT BOOL PutLine(  HFILE fh, char far *lpFmt, ... );
PIEXPORT LPSTR AddExt( LPCSTR szFileName, LPSTR szExtension );
PIEXPORT LPSTR AddNewExt( LPSTR szFileName, LPSTR ext);
PIEXPORT HFILE FileOpen( LPCSTR szFilename );
PIEXPORT void FileClose( HFILE fh );

//
// Misc Routines
//
PIEXPORT BOOL SetDlgItemDouble( HWND hDlg, int iControl, double dValue );
PIEXPORT double GetDlgItemDouble( HWND hDlg, int iControl );
PIEXPORT LPSTR dtoa( double dNumber );
PIEXPORT BOOL PrintFont(HDC hdc, int x, int y, int theta, PLOGFONT plf, LPSTR szText);
PIEXPORT BOOL ScreenToClientRect( HWND hWnd, UINT nCtrl, RECT *rectPosition );
PIEXPORT BOOL BuildFilter( HINSTANCE hInst, UINT nResource, LPSTR szFilter, UINT nFilterLength );

//
// Transformation Routines
//
PIEXPORT void InitTransform(double a1, double a2, double a3, double v1, double v2, double v3, double alpha);
PIEXPORT void RotateZ(double x, double y, double z, double *pxl, double *pyl, double *pzl);
PIEXPORT void Rotate(double x, double y, double z,	double *pxl, double *pyl, double *pzl);

//
// Local Error Reporting Routines
//
PIEXPORT void ErrorMessage( char far *lpFmt, ... );

//
// Handy Macros
//
#define INVERTBOOL( n ) n = ( n ? FALSE : TRUE )


#ifdef __cplusplus
}                       /* End of extern "C" { */
#endif	/* __cplusplus */

#endif

