/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1994, William Cheng.
 *
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights (including the right to sell "tgif" and the right to sell derivative
 * works of tgif) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /export/bourbon/multimedia/william/X11/TGIF2/RCS/arc.e,v 2.11 1994/03/21 03:13:20 william Exp $
 */

#ifndef _ARC_E_
#define _ARC_E_

extern int	arcDrawn;

extern void	PointsToArc ARGS_DECL((int xc, int yc, int x1, int y1,
		                       int x2, int y2, int dir,
		                       int *ltx, int *lty, int *w, int *h,
		                       int *angle1, int *angle2));
extern void	ArcRealX2Y2 ARGS_DECL((struct ArcRec *, int *X2, int *Y2));
extern void	CalcArcBBox ARGS_DECL((struct ArcRec *, struct BBRec obbox,
		                       struct BBRec *bbox));
extern void	DumpArcObj ARGS_DECL((FILE *, struct ObjRec *));
extern void	DrawArcObj ARGS_DECL((Window, int X, int Y, struct ObjRec *));
extern void	UpdArcBBox ARGS_DECL((struct ObjRec *));
extern void	DrawArc ARGS_DECL((XEvent *));
extern void	SaveArcObj ARGS_DECL((FILE *, struct ObjRec *));
extern void	ReadArcObj ARGS_DECL((char *, struct ObjRec **));
extern void	FreeArcObj ARGS_DECL((struct ObjRec *));
extern void	MakePreciseArc ARGS_DECL((void));

#endif /*_ARC_E_*/
