/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1994, William Cheng.
 *
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights (including the right to sell "tgif" and the right to sell derivative
 * works of tgif) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /export/bourbon/multimedia/william/X11/TGIF2/RCS/cmd.e,v 2.13 1994/11/26 02:27:15 william Exp $
 */

#ifndef _CMD_E_
#define _CMD_E_

extern int		recordCmdIncludeTgifObj;
extern int		historyDepth, historyCount, defaultHistoryDepth;
extern struct CmdRec	* firstCmd, * lastCmd, * curCmd;

extern void	CleanUpCmds ARGS_DECL((void));
extern void	RestoreDefaultHistoryDepth ARGS_DECL((void));
extern void	DisableUndo ARGS_DECL((void));
extern void	EnableUndo ARGS_DECL((void));
extern void	UndoCmd ARGS_DECL((void));
extern void	RedoCmd ARGS_DECL((void));
extern void	StartCompositeCmd ARGS_DECL((void));
extern void	EndCompositeCmd ARGS_DECL((void));
extern void	PrepareToRecord ARGS_DECL((int, struct SelRec *Top,
		                           struct SelRec *Bot, int NumObjs));
extern void	RecordCmd ARGS_DECL((int, struct SubCmdRec *,
		                     struct SelRec *Top, struct SelRec *Bot,
		                     int NumObjs));
extern void	AbortPrepareCmd ARGS_DECL((int CmdType));
extern void	RecordNewObjCmd ARGS_DECL((void));
extern void	PrepareToReplaceAnObj ARGS_DECL((struct ObjRec *));
extern void	RecordReplaceAnObj ARGS_DECL((struct ObjRec *));
extern void	ChangeReplaceOneCmdToDeleteCmd ARGS_DECL((void));

#endif /*_CMD_E_*/
