/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1994, William Cheng.
 *
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights (including the right to sell "tgif" and the right to sell derivative
 * works of tgif) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /export/bourbon/multimedia/william/X11/TGIF2/RCS/raster.c,v 2.57 1994/11/10 05:24:43 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "choice.e"
#include "color.e"
#include "file.e"
#include "font.e"
#include "pattern.e"
#include "poly.e"
#ifndef _NO_EXTERN
#include "raster.e"
#endif
#include "setup.e"

#include "xbm/arrow.xbm"
#include "xbm/text.xbm"
#include "xbm/box.xbm"
#include "xbm/oval.xbm"
#include "xbm/poly.xbm"
#include "xbm/polygon.xbm"
#include "xbm/arc.xbm"
#include "xbm/rcbox.xbm"
#include "xbm/freehand.xbm"
#include "xbm/vmode.xbm"

#include "xbm/pat0.xbm"
#include "xbm/pat1.xbm"
#include "xbm/pat2.xbm"
#include "xbm/pat3.xbm"
#include "xbm/pat4.xbm"
#include "xbm/pat5.xbm"
#include "xbm/pat6.xbm"
#include "xbm/pat7.xbm"
#include "xbm/pat8.xbm"
#include "xbm/pat9.xbm"
#include "xbm/pat10.xbm"
#include "xbm/pat11.xbm"
#include "xbm/pat12.xbm"
#include "xbm/pat13.xbm"
#include "xbm/pat14.xbm"
#include "xbm/pat15.xbm"
#include "xbm/pat16.xbm"
#include "xbm/pat17.xbm"
#include "xbm/pat18.xbm"
#include "xbm/pat19.xbm"
#include "xbm/pat20.xbm"
#include "xbm/pat21.xbm"
#include "xbm/pat22.xbm"
#include "xbm/pat23.xbm"
#include "xbm/pat24.xbm"
#include "xbm/pat25.xbm"
#include "xbm/pat26.xbm"
#include "xbm/pat27.xbm"
#include "xbm/pat28.xbm"
#include "xbm/pat29.xbm"
#include "xbm/pat30.xbm"
#include "xbm/pat31.xbm"
#include "xbm/pat32.xbm"

#include "xbm/just_l.xbm"
#include "xbm/just_c.xbm"
#include "xbm/just_r.xbm"

#include "xbm/align_n.xbm"

#include "xbm/align_l.xbm"
#include "xbm/align_c.xbm"
#include "xbm/align_r.xbm"

#include "xbm/align_t.xbm"
#include "xbm/align_m.xbm"
#include "xbm/align_b.xbm"

#include "xbm/align_s.xbm"

#include "xbm/lw0.xbm"
#include "xbm/lw1.xbm"
#include "xbm/lw2.xbm"
#include "xbm/lw3.xbm"
#include "xbm/lw4.xbm"
#include "xbm/lw5.xbm"
#include "xbm/lw6.xbm"

#include "xbm/lt0.xbm"
#include "xbm/lt1.xbm"
#include "xbm/lt2.xbm"

#include "xbm/ls0.xbm"
#include "xbm/ls1.xbm"
#include "xbm/ls2.xbm"
#include "xbm/ls3.xbm"

#include "xbm/ld0.xbm"
#include "xbm/ld1.xbm"
#include "xbm/ld2.xbm"
#include "xbm/ld3.xbm"
#include "xbm/ld4.xbm"
#include "xbm/ld5.xbm"
#include "xbm/ld6.xbm"
#include "xbm/ld7.xbm"
#include "xbm/ld8.xbm"

#include "xbm/lw0s.xbm"
#include "xbm/lw1s.xbm"
#include "xbm/lw2s.xbm"
#include "xbm/lw3s.xbm"
#include "xbm/lw4s.xbm"
#include "xbm/lw5s.xbm"
#include "xbm/lw6s.xbm"

#include "xbm/lt0s.xbm"
#include "xbm/lt1s.xbm"
#include "xbm/lt2s.xbm"

#include "xbm/ls0s.xbm"
#include "xbm/ls1s.xbm"
#include "xbm/ls2s.xbm"
#include "xbm/ls3s.xbm"

#include "xbm/ld0s.xbm"
#include "xbm/ld1s.xbm"
#include "xbm/ld2s.xbm"
#include "xbm/ld3s.xbm"
#include "xbm/ld4s.xbm"
#include "xbm/ld5s.xbm"
#include "xbm/ld6s.xbm"
#include "xbm/ld7s.xbm"
#include "xbm/ld8s.xbm"

#include "xbm/printer.xbm"
#include "xbm/latex.xbm"
#include "xbm/psfile.xbm"
#include "xbm/xbm.xbm"
#include "xbm/ascii.xbm"
#include "xbm/epsi.xbm"

#include "xbm/file.xbm"
#include "xbm/landscape.xbm"
#include "xbm/special.xbm"
#include "xbm/vspace.xbm"

#include "xbm/rcbradius.xbm"
#include "xbm/const_move.xbm"
#include "xbm/unconst_mv.xbm"
#include "xbm/edit.xbm"
#include "xbm/intr.xbm"
#include "xbm/intr90.xbm"
#include "xbm/trek.xbm"
#include "xbm/stack.xbm"
#include "xbm/tile.xbm"

#include "xbm/rotate_0.xbm"
#include "xbm/rotate_90.xbm"
#include "xbm/rotate_180.xbm"
#include "xbm/rotate_270.xbm"

#include "xbm/btn1.xbm"
#include "xbm/btn2.xbm"
#include "xbm/btn3.xbm"

#include "xbm/stop.xbm"
#include "xbm/question.xbm"
#include "xbm/info.xbm"

extern int	atoi ARGS_DECL((char *));

GC	rasterGC;

Pixmap	patPixmap[MAXPATTERNS+1];
GC	patGC;

unsigned long	xorOne;
unsigned long	xorZero;

GC	drawGC = NULL;
GC	defaultGC = NULL;
GC	revDefaultGC = NULL;
GC	revGrayGC = NULL;

Pixmap	choicePixmap[MAXCHOICES];
Pixmap	* lineWidthPixmap;
Pixmap	lineTypePixmap[MAXLINETYPES];
Pixmap	dashPixmap[MAXDASHES];
Pixmap	lineStylePixmap[MAXLINESTYLES];
Pixmap	justPixmap[MAXJUSTS];
Pixmap	alignHoriPixmap[MAXALIGNS];
Pixmap	alignVertPixmap[MAXALIGNS];
Pixmap	* shortLineWidthPixmap;
Pixmap	filePixmap;
Pixmap	landscapePixmap;
Pixmap	specialPixmap;
Pixmap	vspacePixmap;
Pixmap	rcbRadiusPixmap;
Pixmap	moveModePixmap[MAXMOVEMODES];
Pixmap	editPixmap;
Pixmap	intrPixmap[MAXINTRS];
Pixmap	trekPixmap;
Pixmap	pageLayoutPixmap[MAXPAGELAYOUTMODES];

Pixmap	rotatePixmap[4];
Pixmap	whereToPrintPixmap[MAXWHERETOPRINT];
Pixmap	shortLineTypePixmap[MAXLINETYPES];
Pixmap	shortLineStylePixmap[MAXLINESTYLES];
Pixmap	shortDashPixmap[MAXDASHES];

Pixmap	statusBtnPixmap[MAX_STATUS_BTNS];
Pixmap	msgBoxPixmap[MAX_MB_ICONS];

int	maxLineWidths = MAXLINEWIDTHS;

int	pat_w[MAXPATTERNS+1], pat_h[MAXPATTERNS+1];
int	dashListLength[MAXDASHES] = { 0, 2, 2, 2, 4, 2, 6, 2, 2 };
char	* dashList[MAXDASHES] =
      {"","\004\014","\010\010","\014\004","\024\004\004\004",
       "\004\004","\014\004\004\004\004\004","\020\020","\002\002"};

static char	* patData[MAXPATTERNS+1];

static int	newLineWidthAllocated = FALSE;

static Pixmap	defaultLineWidthPixmap[MAXLINEWIDTHS];
static Pixmap	defaultShortLineWidthPixmap[MAXLINEWIDTHS];

static
void InitLines ()
{
   register int	i;
   int		y, short_y, len, x;
   char		* c_ptr, buf[80], s[MAXSTRING];
   XGCValues	values;
   GC		tmp_gc, tmp_rev_gc;
   Pixmap	dummy_pixmap;

   newLineWidthAllocated = FALSE;

   maxLineWidths = MAXLINEWIDTHS;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "MaxLineWidths")) != NULL)
   {
      maxLineWidths = atoi (c_ptr);

      curWidthOfLine = (short *) calloc (maxLineWidths, sizeof (short));
      curArrowHeadW = (short *) calloc (maxLineWidths, sizeof (short));
      curArrowHeadH = (short *) calloc (maxLineWidths, sizeof (short));

      for (i = 0; i < maxLineWidths; i++)
      {
         sprintf (buf, "LineWidth%1d", i);
         if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, buf)) == NULL) break;
         curWidthOfLine[i] = atoi (c_ptr);
         sprintf (buf, "ArrowWidth%1d", i);
         if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, buf)) == NULL) break;
         curArrowHeadW[i] = atoi (c_ptr);
         sprintf (buf, "ArrowHeight%1d", i);
         if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, buf)) == NULL) break;
         curArrowHeadH[i] = atoi (c_ptr);
      }
      if (i != maxLineWidths)
      {
         fprintf (stderr, "%s %s.  Default widths used.\n",
               "Error in getting X default", buf);

         cfree (curWidthOfLine);
         cfree (curArrowHeadW);
         cfree (curArrowHeadH);
      }
      else
      {
         y = HALF_W(menuImageH);
         short_y = HALF_W(choiceImageH);

         lineWidthPixmap = (Pixmap *) calloc (maxLineWidths, sizeof (Pixmap));
         shortLineWidthPixmap = (Pixmap *) calloc (maxLineWidths,
               sizeof (Pixmap));

         dummy_pixmap = XCreatePixmap (mainDisplay, mainWindow, 1, 1, 1);

         values.foreground = 1;
         values.background = 0;
         values.fill_style = FillSolid;
         values.function = GXcopy;
         values.font = rulerFontPtr->fid;
         tmp_gc = XCreateGC (mainDisplay, dummy_pixmap,
               GCForeground | GCBackground | GCFillStyle | GCFunction | GCFont,
               &values);

         values.foreground = 0;
         tmp_rev_gc = XCreateGC (mainDisplay, dummy_pixmap,
               GCForeground | GCBackground | GCFillStyle | GCFunction | GCFont,
               &values);

         for (i = 0; i < maxLineWidths; i++)
         {
            lineWidthPixmap[i] = XCreatePixmap (mainDisplay, mainWindow,
               menuImageW, menuImageH, 1);
            shortLineWidthPixmap[i] = XCreatePixmap (mainDisplay, mainWindow,
               choiceImageW, choiceImageH, 1);

            XFillRectangle (mainDisplay, lineWidthPixmap[i], tmp_rev_gc,
                  0, 0, menuImageW, menuImageH);
            XFillRectangle (mainDisplay, shortLineWidthPixmap[i], tmp_rev_gc,
                  0, 0, choiceImageW, choiceImageH);

            values.line_width = curWidthOfLine[i];
#ifdef NO_THIN_LINE
            if (values.line_width < 1) values.line_width = 1;
#endif
            XChangeGC (mainDisplay, tmp_gc, GCLineWidth, &values);

            XDrawLine (mainDisplay, lineWidthPixmap[i], tmp_gc,
                4, y, menuImageW-4, y);
            XDrawLine (mainDisplay, shortLineWidthPixmap[i], tmp_gc,
                4, short_y, choiceImageW-4, short_y);

            sprintf (s, "%1d", curWidthOfLine[i]);
            len = strlen (s);

            x = HALF_W(menuImageW-len*rulerFontWidth);
            if (curWidthOfLine[i] > menuImageH-4)
               XDrawString (mainDisplay, lineWidthPixmap[i], tmp_rev_gc, x,
                  y+HALF_W(rulerFontHeight)-rulerFontDes, s, len);

            x = HALF_W(choiceImageW-len*rulerFontWidth);
            if (curWidthOfLine[i] > choiceImageH-4)
               XDrawString (mainDisplay, shortLineWidthPixmap[i], tmp_rev_gc, x,
                  y+HALF_W(rulerFontHeight)-rulerFontDes, s, len);
         }
         XFreeGC (mainDisplay, tmp_gc);
         XFreeGC (mainDisplay, tmp_rev_gc);
         XFreePixmap (mainDisplay, dummy_pixmap);

         newLineWidthAllocated = TRUE;
      }
   }

   lineWidth = 0;
   if ((c_ptr = XGetDefault(mainDisplay,TOOL_NAME,"DefaultLineWidth"))!=NULL)
      lineWidth = atoi (c_ptr);
   if (lineWidth >= maxLineWidths)
   {
      fprintf (stderr, "%s, use 0 for DefaultLineWidth.\n",
            "Warning:  DefaultLineWidth >= MaxLineWidths in X default");
      lineWidth = 0;
   }

   if (!newLineWidthAllocated)
   {
      maxLineWidths = MAXLINEWIDTHS;

      curWidthOfLine = (short *) calloc (maxLineWidths, sizeof (short));
      curArrowHeadW = (short *) calloc (maxLineWidths, sizeof (short));
      curArrowHeadH = (short *) calloc (maxLineWidths, sizeof (short));

      lineWidthPixmap = (Pixmap *) calloc (maxLineWidths, sizeof (Pixmap));
      shortLineWidthPixmap = (Pixmap *) calloc (maxLineWidths, sizeof (Pixmap));

      for (i = 0; i < maxLineWidths; i++)
      {
         curWidthOfLine[i] = origWidthOfLine[i];
         curArrowHeadW[i] = origArrowHeadW[i];
         curArrowHeadH[i] = origArrowHeadH[i];
         lineWidthPixmap[i] = defaultLineWidthPixmap[i];
         shortLineWidthPixmap[i] = defaultShortLineWidthPixmap[i];
      }
   }
}

void InitPattern ()
{
   register int	i;
   XGCValues	values;

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillOpaqueStippled;

   rasterGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFillStyle, &values);

   values.fill_style = FillOpaqueStippled;
   patGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFillStyle, &values);

   values.background = myBgPixel;
   values.graphics_exposures = False;
   drawGC = XCreateGC (mainDisplay, mainWindow,
         GCBackground | GCGraphicsExposures, &values);

   values.font = defaultFontPtr->fid;
   values.line_width = 1;
   defaultGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFont | GCLineWidth, &values);

   values.foreground = xorOne;
   values.background = xorZero;
   values.function = GXxor;
   values.fill_style = FillSolid;
   revDefaultGC = XCreateGC (mainDisplay, mainWindow, GCForeground |
         GCBackground | GCFunction | GCFillStyle | GCFont, &values);

   pat_w[0] = pat0_width; pat_h[0] = pat0_height; patData[0] = pat0_bits;
   pat_w[1] = pat1_width; pat_h[1] = pat1_height; patData[1] = pat1_bits;
   pat_w[2] = pat2_width; pat_h[2] = pat2_height; patData[2] = pat2_bits;
   pat_w[3] = pat3_width; pat_h[3] = pat3_height; patData[3] = pat3_bits;
   pat_w[4] = pat4_width; pat_h[4] = pat4_height; patData[4] = pat4_bits;
   pat_w[5] = pat5_width; pat_h[5] = pat5_height; patData[5] = pat5_bits;
   pat_w[6] = pat6_width; pat_h[6] = pat6_height; patData[6] = pat6_bits;
   pat_w[7] = pat7_width; pat_h[7] = pat7_height; patData[7] = pat7_bits;
   pat_w[8] = pat8_width; pat_h[8] = pat8_height; patData[8] = pat8_bits;
   pat_w[9] = pat9_width; pat_h[9] = pat9_height; patData[9] = pat9_bits;
   pat_w[10] = pat10_width; pat_h[10] = pat10_height; patData[10] = pat10_bits;
   pat_w[11] = pat11_width; pat_h[11] = pat11_height; patData[11] = pat11_bits;
   pat_w[12] = pat12_width; pat_h[12] = pat12_height; patData[12] = pat12_bits;
   pat_w[13] = pat13_width; pat_h[13] = pat13_height; patData[13] = pat13_bits;
   pat_w[14] = pat14_width; pat_h[14] = pat14_height; patData[14] = pat14_bits;
   pat_w[15] = pat15_width; pat_h[15] = pat15_height; patData[15] = pat15_bits;
   pat_w[16] = pat16_width; pat_h[16] = pat16_height; patData[16] = pat16_bits;
   pat_w[17] = pat17_width; pat_h[17] = pat17_height; patData[17] = pat17_bits;
   pat_w[18] = pat18_width; pat_h[18] = pat18_height; patData[18] = pat18_bits;
   pat_w[19] = pat19_width; pat_h[19] = pat19_height; patData[19] = pat19_bits;
   pat_w[20] = pat20_width; pat_h[20] = pat20_height; patData[20] = pat20_bits;
   pat_w[21] = pat21_width; pat_h[21] = pat21_height; patData[21] = pat21_bits;
   pat_w[22] = pat22_width; pat_h[22] = pat22_height; patData[22] = pat22_bits;
   pat_w[23] = pat23_width; pat_h[23] = pat23_height; patData[23] = pat23_bits;
   pat_w[24] = pat24_width; pat_h[24] = pat24_height; patData[24] = pat24_bits;
   pat_w[25] = pat25_width; pat_h[25] = pat25_height; patData[25] = pat25_bits;
   pat_w[26] = pat26_width; pat_h[26] = pat26_height; patData[26] = pat26_bits;
   pat_w[27] = pat27_width; pat_h[27] = pat27_height; patData[27] = pat27_bits;
   pat_w[28] = pat28_width; pat_h[28] = pat28_height; patData[28] = pat28_bits;
   pat_w[29] = pat29_width; pat_h[29] = pat29_height; patData[29] = pat29_bits;
   pat_w[30] = pat30_width; pat_h[30] = pat30_height; patData[30] = pat30_bits;
   pat_w[31] = pat31_width; pat_h[31] = pat31_height; patData[31] = pat31_bits;
   pat_w[32] = pat32_width; pat_h[32] = pat32_height; patData[32] = pat32_bits;

   for (i = 0; i < MAXPATTERNS+1; i++)
      patPixmap[i] = XCreateBitmapFromData (mainDisplay, mainWindow,
            patData[i], pat_w[i], pat_h[i]);

   values.foreground = xorOne;
   values.background = xorZero;
   values.function = GXxor;
   values.fill_style = FillStippled;
   values.stipple = patPixmap[SCROLLPAT];
   revGrayGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFunction | GCFillStyle | GCStipple,
         &values);

   justPixmap[JUST_L] = XCreateBitmapFromData (mainDisplay, mainWindow,
         just_l_bits, just_l_width, just_l_height);
   justPixmap[JUST_C] = XCreateBitmapFromData (mainDisplay, mainWindow,
         just_c_bits, just_c_width, just_c_height);
   justPixmap[JUST_R] = XCreateBitmapFromData (mainDisplay, mainWindow,
         just_r_bits, just_r_width, just_r_height);

   alignHoriPixmap[ALIGN_N] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_n_bits, align_n_width, align_n_height);
   alignHoriPixmap[ALIGN_L] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_l_bits, align_l_width, align_l_height);
   alignHoriPixmap[ALIGN_C] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_c_bits, align_c_width, align_c_height);
   alignHoriPixmap[ALIGN_R] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_r_bits, align_r_width, align_r_height);
   alignHoriPixmap[ALIGN_S] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_s_bits, align_s_width, align_s_height);

   alignVertPixmap[ALIGN_N] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_n_bits, align_n_width, align_n_height);
   alignVertPixmap[ALIGN_T] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_t_bits, align_t_width, align_t_height);
   alignVertPixmap[ALIGN_M] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_m_bits, align_m_width, align_m_height);
   alignVertPixmap[ALIGN_B] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_b_bits, align_b_width, align_b_height);
   alignVertPixmap[ALIGN_S] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_s_bits, align_s_width, align_s_height);

   defaultLineWidthPixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw0_bits, lw0_width, lw0_height);
   defaultLineWidthPixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw1_bits, lw1_width, lw1_height);
   defaultLineWidthPixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw2_bits, lw2_width, lw2_height);
   defaultLineWidthPixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw3_bits, lw3_width, lw3_height);
   defaultLineWidthPixmap[4] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw4_bits, lw4_width, lw4_height);
   defaultLineWidthPixmap[5] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw5_bits, lw5_width, lw5_height);
   defaultLineWidthPixmap[6] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw6_bits, lw6_width, lw6_height);

   lineStylePixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls0_bits, ls0_width, ls0_height);
   lineStylePixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls1_bits, ls1_width, ls1_height);
   lineStylePixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls2_bits, ls2_width, ls2_height);
   lineStylePixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls3_bits, ls3_width, ls3_height);

   lineTypePixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lt0_bits, lt0_width, lt0_height);
   lineTypePixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lt1_bits, lt1_width, lt1_height);
   lineTypePixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lt2_bits, lt2_width, lt2_height);

   dashPixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld0_bits, ld0_width, ld0_height);
   dashPixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld1_bits, ld1_width, ld1_height);
   dashPixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld2_bits, ld2_width, ld2_height);
   dashPixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld3_bits, ld3_width, ld3_height);
   dashPixmap[4] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld4_bits, ld4_width, ld4_height);
   dashPixmap[5] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld5_bits, ld5_width, ld5_height);
   dashPixmap[6] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld6_bits, ld6_width, ld6_height);
   dashPixmap[7] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld7_bits, ld7_width, ld7_height);
   dashPixmap[8] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld8_bits, ld8_width, ld8_height);

   shortLineStylePixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls0s_bits, ls0s_width, ls0s_height);
   shortLineStylePixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls1s_bits, ls1s_width, ls1s_height);
   shortLineStylePixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls2s_bits, ls2s_width, ls2s_height);
   shortLineStylePixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls3s_bits, ls3s_width, ls3s_height);

   filePixmap = XCreateBitmapFromData (mainDisplay, mainWindow,
         file_bits, file_width, file_height);

   landscapePixmap = XCreateBitmapFromData (mainDisplay, mainWindow,
         landscape_bits, landscape_width, landscape_height);

   specialPixmap = XCreateBitmapFromData (mainDisplay, mainWindow,
         special_bits, special_width, special_height);

   vspacePixmap = XCreateBitmapFromData (mainDisplay, mainWindow,
         vspace_bits, vspace_width, vspace_height);

   rcbRadiusPixmap = XCreateBitmapFromData (mainDisplay, mainWindow,
         rcbradius_bits, rcbradius_width, rcbradius_height);

   moveModePixmap[CONST_MOVE] = XCreateBitmapFromData (mainDisplay, mainWindow,
         const_move_bits, const_move_width, const_move_height);

   moveModePixmap[UNCONST_MOVE] = XCreateBitmapFromData (mainDisplay,
         mainWindow, unconst_mv_bits, unconst_mv_width,
         unconst_mv_height);

   editPixmap = XCreateBitmapFromData (mainDisplay, mainWindow,
         edit_bits, edit_width, edit_height);

   intrPixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         intr_bits, intr_width, intr_height);
   intrPixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         intr90_bits, intr90_width, intr90_height);

   trekPixmap = XCreateBitmapFromData (mainDisplay, mainWindow,
         trek_bits, trek_width, trek_height);

   pageLayoutPixmap[PAGE_STACK] = XCreateBitmapFromData (mainDisplay,
         mainWindow, stack_bits, stack_width, stack_height);

   pageLayoutPixmap[PAGE_TILE] = XCreateBitmapFromData (mainDisplay,
         mainWindow, tile_bits, tile_width, tile_height);

   rotatePixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         rotate_0_bits, rotate_0_width, rotate_0_height);
   rotatePixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         rotate_90_bits, rotate_90_width, rotate_90_height);
   rotatePixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         rotate_180_bits, rotate_180_width, rotate_180_height);
   rotatePixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         rotate_270_bits, rotate_270_width, rotate_270_height);

   whereToPrintPixmap[PRINTER] = XCreateBitmapFromData (mainDisplay, mainWindow,
         printer_bits, printer_width, printer_height);
   whereToPrintPixmap[LATEX_FIG] = XCreateBitmapFromData (mainDisplay,
         mainWindow, latex_bits, latex_width, latex_height);
   whereToPrintPixmap[PS_FILE] = XCreateBitmapFromData (mainDisplay,
         mainWindow, psfile_bits, psfile_width, psfile_height);
   whereToPrintPixmap[XBM_FILE] = XCreateBitmapFromData (mainDisplay,
         mainWindow, xbm_bits, xbm_width, xbm_height);
   whereToPrintPixmap[TEXT_FILE] = XCreateBitmapFromData (mainDisplay,
         mainWindow, ascii_bits, ascii_width, ascii_height);
   whereToPrintPixmap[EPSI_FILE] = XCreateBitmapFromData (mainDisplay,
         mainWindow, epsi_bits, epsi_width, epsi_height);

   shortLineTypePixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lt0s_bits, lt0s_width, lt0s_height);
   shortLineTypePixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lt1s_bits, lt1s_width, lt1s_height);
   shortLineTypePixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lt2s_bits, lt2s_width, lt2s_height);

   shortDashPixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld0s_bits, ld0s_width, ld0s_height);
   shortDashPixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld1s_bits, ld1s_width, ld1s_height);
   shortDashPixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld2s_bits, ld2s_width, ld2s_height);
   shortDashPixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld3s_bits, ld3s_width, ld3s_height);
   shortDashPixmap[4] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld4s_bits, ld4s_width, ld4s_height);
   shortDashPixmap[5] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld5s_bits, ld5s_width, ld5s_height);
   shortDashPixmap[6] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld6s_bits, ld6s_width, ld6s_height);
   shortDashPixmap[7] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld7s_bits, ld7s_width, ld7s_height);
   shortDashPixmap[8] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld8s_bits, ld8s_width, ld8s_height);

   defaultShortLineWidthPixmap[0] = XCreateBitmapFromData (mainDisplay,
         mainWindow, lw0s_bits, lw0s_width, lw0s_height);
   defaultShortLineWidthPixmap[1] = XCreateBitmapFromData (mainDisplay,
         mainWindow, lw1s_bits, lw1s_width, lw1s_height);
   defaultShortLineWidthPixmap[2] = XCreateBitmapFromData (mainDisplay,
         mainWindow, lw2s_bits, lw2s_width, lw2s_height);
   defaultShortLineWidthPixmap[3] = XCreateBitmapFromData (mainDisplay,
         mainWindow, lw3s_bits, lw3s_width, lw3s_height);
   defaultShortLineWidthPixmap[4] = XCreateBitmapFromData (mainDisplay,
         mainWindow, lw4s_bits, lw4s_width, lw4s_height);
   defaultShortLineWidthPixmap[5] = XCreateBitmapFromData (mainDisplay,
         mainWindow, lw5s_bits, lw5s_width, lw5s_height);
   defaultShortLineWidthPixmap[6] = XCreateBitmapFromData (mainDisplay,
         mainWindow, lw6s_bits, lw6s_width, lw6s_height);

   choicePixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         arrow_bits, arrow_width, arrow_height);
   choicePixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         text_bits, text_width, text_height);
   choicePixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         box_bits, box_width, box_height);
   choicePixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         oval_bits, oval_width, oval_height);
   choicePixmap[4] = XCreateBitmapFromData (mainDisplay, mainWindow,
         poly_bits, poly_width, poly_height);
   choicePixmap[5] = XCreateBitmapFromData (mainDisplay, mainWindow,
         polygon_bits, polygon_width, polygon_height);
   choicePixmap[6] = XCreateBitmapFromData (mainDisplay, mainWindow,
         arc_bits, arc_width, arc_height);
   choicePixmap[7] = XCreateBitmapFromData (mainDisplay, mainWindow,
         rcbox_bits, rcbox_width, rcbox_height);
   choicePixmap[8] = XCreateBitmapFromData (mainDisplay, mainWindow,
         freehand_bits, freehand_width, freehand_height);
   choicePixmap[9] = XCreateBitmapFromData (mainDisplay, mainWindow,
         vmode_bits, vmode_width, vmode_height);

   statusBtnPixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         btn1_bits, btn1_width, btn1_height);
   statusBtnPixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         btn2_bits, btn2_width, btn2_height);
   statusBtnPixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         btn3_bits, btn3_width, btn3_height);

   msgBoxPixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         stop_bits, stop_width, stop_height);
   msgBoxPixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         question_bits, question_width, question_height);
   msgBoxPixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         info_bits, info_width, info_height);

   InitLines();
}

void RedrawChoiceWindow ()
{
   ShowMode ();
   ShowColor (FALSE);
   ShowFile ();
   ShowEdit ();
   ShowWhereToPrint ();
   ShowSpecial ();
   ShowHoriAlign ();
   ShowVertAlign ();
   ShowRotate ();
   ShowMoveMode ();
   ShowRCBRadius ();
   ShowZoom ();
   ShowCurFont ();
   ShowJust ();
   ShowTextSize ();
   ShowTextVSpace ();
   ShowLineWidth ();
   ShowLineStyle ();
   ShowLineType ();
   ShowDash ();
   ShowFill ();
   ShowPen ();
   ShowPage ();
   ShowPageLayout ();
}

void CleanUpRasters ()
{
   register int	i;

   for (i = 0; i < MAXCHOICES; i++) XFreePixmap (mainDisplay, choicePixmap[i]);
   for (i = 0; i < MAXPATTERNS+1; i++) XFreePixmap (mainDisplay, patPixmap[i]);
   for (i = 0; i < MAXLINEWIDTHS; i++)
      XFreePixmap (mainDisplay, defaultLineWidthPixmap[i]);
   for (i = 0; i < MAXLINESTYLES; i++)
      XFreePixmap (mainDisplay, lineStylePixmap[i]);
   for (i = 0; i < MAXLINETYPES; i++)
      XFreePixmap (mainDisplay, lineTypePixmap[i]);
   for (i = 0; i < MAXDASHES; i++)
      XFreePixmap (mainDisplay, dashPixmap[i]);
   for (i = 0; i < MAXJUSTS; i++) XFreePixmap (mainDisplay, justPixmap[i]);
   XFreePixmap (mainDisplay, alignHoriPixmap[0]);
   for (i = 1; i < MAXALIGNS; i++)
      XFreePixmap (mainDisplay, alignHoriPixmap[i]);
   for (i = 1; i < MAXALIGNS; i++)
      XFreePixmap (mainDisplay, alignVertPixmap[i]);
   for (i = 0; i < MAXLINEWIDTHS; i++)
      XFreePixmap (mainDisplay, defaultShortLineWidthPixmap[i]);
   XFreePixmap (mainDisplay, filePixmap);
   XFreePixmap (mainDisplay, landscapePixmap);
   XFreePixmap (mainDisplay, specialPixmap);
   XFreePixmap (mainDisplay, vspacePixmap);
   XFreePixmap (mainDisplay, rcbRadiusPixmap);
   for (i = 0; i < MAXMOVEMODES; i++)
      XFreePixmap (mainDisplay, moveModePixmap[i]);
   XFreePixmap (mainDisplay, editPixmap);
   for (i = 0; i < MAXINTRS; i++)
      XFreePixmap (mainDisplay, intrPixmap[i]);
   XFreePixmap (mainDisplay, trekPixmap);
   for (i = 0; i < MAXPAGELAYOUTMODES; i++)
      XFreePixmap (mainDisplay, pageLayoutPixmap[i]);
   for (i = 0; i < 4; i++)
      XFreePixmap (mainDisplay, rotatePixmap[i]);
   for (i = 0; i < MAXWHERETOPRINT; i++)
      XFreePixmap (mainDisplay, whereToPrintPixmap[i]);
   for (i = 0; i < MAXLINETYPES; i++)
      XFreePixmap (mainDisplay, shortLineTypePixmap[i]);
   for (i = 0; i < MAXLINESTYLES; i++)
      XFreePixmap (mainDisplay, shortLineStylePixmap[i]);
   for (i = 0; i < MAXDASHES; i++)
      XFreePixmap (mainDisplay, shortDashPixmap[i]);

   for (i = 0; i < MAX_STATUS_BTNS; i++)
      XFreePixmap (mainDisplay, statusBtnPixmap[i]);

   for (i = 0; i < MAX_MB_ICONS; i++)
      XFreePixmap (mainDisplay, msgBoxPixmap[i]);

   if (newLineWidthAllocated)
   {
      for (i = 0; i < maxLineWidths; i++)
         XFreePixmap (mainDisplay, lineWidthPixmap[i]);
      for (i = 0; i < maxLineWidths; i++)
         XFreePixmap (mainDisplay, shortLineWidthPixmap[i]);
   }
   cfree (lineWidthPixmap); lineWidthPixmap = NULL;
   cfree (shortLineWidthPixmap); shortLineWidthPixmap = NULL;
   cfree (curWidthOfLine); curWidthOfLine = NULL;
   cfree (curArrowHeadW); curArrowHeadW = NULL;
   cfree (curArrowHeadH); curArrowHeadH = NULL;

   XFreeGC (mainDisplay, rasterGC);
   XFreeGC (mainDisplay, patGC);
   XFreeGC (mainDisplay, drawGC); drawGC = NULL;
   XFreeGC (mainDisplay, defaultGC); defaultGC = NULL;
   XFreeGC (mainDisplay, revDefaultGC); revDefaultGC = NULL;
   XFreeGC (mainDisplay, revGrayGC); revGrayGC = NULL;
}

int UpgradePenFill (pen_or_fill)
   int	pen_or_fill;
{
   if (fileVersion <= 17 && pen_or_fill >= 8 && pen_or_fill < 12)
      return (pen_or_fill+12);
   else
      return (pen_or_fill);
}
