/*
 * Globally accessible information from xgraph
 */

#ifndef _XGRAPH_H_
#define _XGRAPH_H_

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

#include "xgout.h"

#define VERSION_STRING	"11.4 March 1991"

#define MAXKEYS		50
#define MAXATTR 	8
#define MAXSETS		64
#define MAXBUFSIZE 	120
#define MAXLS		50

#define STRDUP(xx)	(strcpy(Malloc((unsigned) (strlen(xx)+1)), (xx)))
#define SCREENX(ws, userX) \
    (((int) (((userX) - ws->UsrOrgX)/ws->XUnitsPerPixel + 0.5)) + ws->XOrgX)
#define SCREENY(ws, userY) \
    (ws->XOppY - ((int) (((userY) - ws->UsrOrgY)/ws->YUnitsPerPixel + 0.5)))
#define HARDCOPY_IN_PROGRESS	0x01

/* Portability */
#ifdef  CRAY
#undef  MAXFLOAT
#define MAXFLOAT 10.e300
#endif				/* CRAY */

#ifndef MAXFLOAT
#define MAXFLOAT	HUGE
#endif

#define BIGINT		0xfffffff

#define GRIDPOWER 	10
#define INITSIZE 	128

#define CONTROL_D	'\004'
#define CONTROL_C	'\003'
#define TILDE		'~'

#define BTNPAD		1
#define BTNINTER	3

#define MAX(a,b)	((a) > (b) ? (a) : (b))
#define MIN(a,b)	((a) < (b) ? (a) : (b))
#define ABS(x)		((x) < 0 ? -(x) : (x))
#define ZERO_THRES	1.0E-07

/* To get around an inaccurate log */
#define nlog10(x)	(x == 0.0 ? 0.0 : log10(x) + 1e-15)

#define ISCOLOR		(wi->dev_info.dev_flags & D_COLOR)

#define PIXVALUE(set) 	((set) % MAXATTR)

#define LINESTYLE(set) \
(ISCOLOR ?  ((set)/MAXATTR) : ((set) % MAXATTR))

#define MARKSTYLE(set) \
(colorMark ? COLMARK(set) : BWMARK(set))

#define COLMARK(set) \
((set) / MAXATTR)

#define BWMARK(set) \
((set) % MAXATTR)

#define LOG_X	0x01
#define LOG_Y	0x02
#define STK	0x04
#define FITX	0x08
#define FITY	0x10
typedef unsigned long Pixel;

/* Globally accessible values */
extern Display *disp;		/* Open display            */
extern Visual *vis;		/* Standard visual         */
extern Colormap cmap;		/* Standard colormap       */
extern int screen;		/* Screen number           */
extern int depth;		/* Depth of screen         */

extern void do_hardcopy();	/* Carries out hardcopy    */
extern void ho_dialog();	/* Hardcopy dialog         */
extern void set_X();		/* Initializes X device    */

typedef struct point_list {
    int     numPoints;		/* Number of points in group */
    int     allocSize;		/* Allocated size            */
    double *xvec;		/* X values                  */
    double *yvec;		/* Y values                  */
    struct point_list *next;	/* Next set of points        */
}       PointList;

typedef struct new_data_set {
    char   *setName;		/* Name of data set     */
    PointList *list;		/* List of point arrays */
}       NewDataSet;

typedef struct local_win {
    double  loX,
            loY,
            hiX,
            hiY;		/* Local bounding box of window         */
    int     XOrgX,
            XOrgY;		/* Origin of bounding box on screen     */
    int     XOppX,
            XOppY;		/* Other point defining bounding box    */
    double  UsrOrgX,
            UsrOrgY;		/* Origin of bounding box in user space */
    double  UsrOppX,
            UsrOppY;		/* Other point of bounding box          */
    double  XUnitsPerPixel;	/* X Axis scale factor                  */
    double  YUnitsPerPixel;	/* Y Axis scale factor                  */
    struct xg_out   dev_info;	/* Device information                   */
    Window  close,
            hardcopy;		/* Buttons for closing and hardcopy     */
    Window  about;		/* Version information                  */
    int     flags;		/* Window flags                         */
}       LocalWin;

extern NewDataSet PlotData[MAXSETS];
extern  XSegment *Xsegs[2];		/* Point space for X */
extern double llx, lly, urx, ury;	/* Bounding box of all data */
extern int numFiles;			/* Number of input files   */
extern char *inFileNames[MAXSETS];	/* File names              */

/* Total number of active windows */
extern int Num_Windows;
extern char *Prog_Name;
extern char *disp_name;

/* To make lint happy */
extern char *Malloc();
extern char *Realloc();
#ifdef _AIX370
extern int sprintf();
#else
extern char *sprintf();
#endif
extern char *strcpy();
extern char *strcat();
extern char *rindex();
extern char *index();
extern void exit();
extern void Free();
extern double atof();
extern void abort();

#endif				/* _XGRAPH_H_ */
