package main;

use 5.006;

use strict;
use warnings;

use Test::More 0.88;	# Because of done_testing();

use lib qw{ inc };
use My::Module::Test;


note 'Literals';

parse   ( '/x/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 1, 1 );
width   ( 1, 1 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );


note 'Character classes';

parse   ( '/\\w/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 1, 1 );
width   ( 1, 1 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/[xy]/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 1, 1 );
width   ( 1, 1 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 2 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/(?[ \\w | [.] ])/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 1, 1 );
width   ( 1, 1 );
value   ( perl_version_introduced => [], '5.017008' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::RegexSet' );
count   ( 6 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 2 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(?[' );
choose  ( child => 1, child => 0, start => 1 );
klass   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '])' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 0, child => 2 );
klass   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 0, child => 3 );
klass   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 0, child => 4 );
klass   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 4, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 4, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, child => 4, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, child => 4, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 4, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 4, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( '.' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 5 );
klass   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );


note 'Quantifiers';

parse   ( '/x?/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 0, 1 );
width   ( 0, 1 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 0, 1 );
width   ( 0, 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 0, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/x*/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 0, INFINITY );
width   ( 0, INFINITY );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 0, INFINITY );
width   ( 0, INFINITY );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 0, INFINITY );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/x+/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 1, INFINITY );
width   ( 1, INFINITY );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 1, INFINITY );
width   ( 1, INFINITY );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, INFINITY );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/x{2}/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 2, 2 );
width   ( 2, 2 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 2, 2 );
width   ( 2, 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 2, 2 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 0, 0 );
choose  ( child => 1, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 2 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/x{2,3}/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 2, 3 );
width   ( 2, 3 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 2, 3 );
width   ( 2, 3 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 2, 3 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 3 );
raw_width( 3, 3 );
width   ( 0, 0 );
choose  ( child => 1, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 2 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1, child => 2 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/x{2,}/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 2, INFINITY );
width   ( 2, INFINITY );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 2, INFINITY );
width   ( 2, INFINITY );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 2, INFINITY );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 2 );
raw_width( 2, 2 );
width   ( 0, 0 );
choose  ( child => 1, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 2 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/x{,3}/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 0, 3 );
width   ( 0, 3 );
value   ( perl_version_introduced => [], '5.033006' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 0, 3 );
width   ( 0, 3 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 0, 3 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 2 );
raw_width( 2, 2 );
width   ( 0, 0 );
choose  ( child => 1, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/x{,$foo}/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 0, undef );
width   ( 0, undef );
value   ( perl_version_introduced => [], '5.033006' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 0, undef );
width   ( 0, undef );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 0, undef );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 2 );
raw_width( undef, undef );
width   ( 0, 0 );
choose  ( child => 1, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( undef, undef );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/(xy?)/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 1, 2 );
width   ( 1, 2 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
raw_width( 1, 2 );
width   ( 1, 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 3 );
raw_width( 1, 2 );
width   ( 1, 2 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 0, 1 );
choose  ( child => 1, child => 0, child => 2 );
klass   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/(xy)?/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 0, 2 );
width   ( 0, 2 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 0, 2 );
width   ( 0, 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 2 );
raw_width( 2, 2 );
width   ( 0, 2 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/(xy?)?/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 0, 2 );
width   ( 0, 2 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 0, 2 );
width   ( 0, 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 3 );
raw_width( 1, 2 );
width   ( 0, 2 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 0, 1 );
choose  ( child => 1, child => 0, child => 2 );
klass   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/(xy?){,2}/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 0, 4 );
width   ( 0, 4 );
value   ( perl_version_introduced => [], '5.033006' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 0, 4 );
width   ( 0, 4 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 3 );
raw_width( 1, 2 );
width   ( 0, 4 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 0, 1 );
choose  ( child => 1, child => 0, child => 2 );
klass   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 2 );
raw_width( 2, 2 );
width   ( 0, 0 );
choose  ( child => 1, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 2 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/\\w+/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 1, INFINITY );
width   ( 1, INFINITY );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 1, INFINITY );
width   ( 1, INFINITY );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, INFINITY );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/[xy]?/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 0, 1 );
width   ( 0, 1 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 0, 1 );
width   ( 0, 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 2 );
raw_width( 1, 1 );
width   ( 0, 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );


note 'Alternation';

parse   ( '/x|yz/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 1, 2 );
width   ( 1, 2 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
raw_width( 1, 2 );
width   ( 1, 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 2 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 3 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );


note 'Interpolation';

parse   ( '/$foo/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( undef, undef );
width   ( undef, undef );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
raw_width( undef, undef );
width   ( undef, undef );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( undef, undef );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/a|$foo/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( undef, undef );
width   ( undef, undef );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 3 );
raw_width( undef, undef );
width   ( undef, undef );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 2 );
klass   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( undef, undef );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/$foo|a/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( undef, undef );
width   ( undef, undef );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 3 );
raw_width( undef, undef );
width   ( undef, undef );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( undef, undef );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 2 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/x{2,$foo}/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 2, undef );
width   ( 2, undef );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 2, undef );
width   ( 2, undef );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 2, undef );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 3 );
raw_width( undef, undef );
width   ( 0, 0 );
choose  ( child => 1, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 2 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1, child => 2 );
klass   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( undef, undef );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );


note 'Branch reset';

parse   ( '/(?|(foo)|(bazzle))/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 3, 6 );
width   ( 3, 6 );
value   ( perl_version_introduced => [], '5.009005' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
raw_width( 3, 6 );
width   ( 3, 6 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::BranchReset' );
count   ( 3 );
raw_width( 3, 6 );
width   ( 3, 6 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
klass   ( 'PPIx::Regexp::Token::GroupType::BranchReset' );
content ( '?|' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 3 );
raw_width( 3, 3 );
width   ( 3, 3 );
choose  ( child => 1, child => 0, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 0, child => 2 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 0, child => 2 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 6 );
raw_width( 6, 6 );
width   ( 6, 6 );
choose  ( child => 1, child => 0, child => 2, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 2, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, child => 2, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, child => 2, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 2, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 2, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 2, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 2, child => 2 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 2, child => 3 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 2, child => 4 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'l' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 2, child => 5 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'e' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );


note 'Condition';

parse   ( '/(x)(?(1)y|z)/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 2, 2 );
width   ( 2, 2 );
value   ( perl_version_introduced => [], '5.005' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 2, 2 );
width   ( 2, 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Structure::Switch' );
count   ( 4 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 1, type => [] );
count   ( 1 );
choose  ( child => 1, child => 1, type => 0 );
klass   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( child => 1, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Condition' );
content ( '(1)' );
value   ( perl_version_introduced => [], '5.005' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1, child => 2 );
klass   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 1, child => 3 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/(x)(?(1)y)/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 1, 2 );
width   ( 1, 2 );
value   ( perl_version_introduced => [], '5.005' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 1, 2 );
width   ( 1, 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Structure::Switch' );
count   ( 2 );
raw_width( 0, 1 );
width   ( 0, 1 );
choose  ( child => 1, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 1, type => [] );
count   ( 1 );
choose  ( child => 1, child => 1, type => 0 );
klass   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( child => 1, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Condition' );
content ( '(1)' );
value   ( perl_version_introduced => [], '5.005' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/(?(DEFINE)(?<FOO>fubar))/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 0, 0 );
width   ( 0, 0 );
value   ( perl_version_introduced => [], '5.009005' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Switch' );
count   ( 2 );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
klass   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Condition' );
content ( '(DEFINE)' );
value   ( perl_version_introduced => [], '5.009005' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Structure::NamedCapture' );
count   ( 5 );
raw_width( 5, 5 );
width   ( 5, 5 );
choose  ( child => 1, child => 0, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, child => 1, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 1, type => 0 );
klass   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?<FOO>' );
choose  ( child => 1, child => 0, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'u' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1, child => 2 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1, child => 3 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1, child => 4 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );


note 'Look-around assertion';

parse   ( '/(?=foo)/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 0, 0 );
width   ( 0, 0 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Assertion' );
count   ( 3 );
raw_width( 3, 3 );
width   ( 0, 0 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
klass   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?=' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 2 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );


note 'Back reference';

parse   ( '/(x)\\1)/' );
value   ( failures => [], 1 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 2, 2 );
width   ( 2, 2 );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 3 );
raw_width( 2, 2 );
width   ( 2, 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\1' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 2 );
klass   ( 'PPIx::Regexp::Token::Unmatched' );
content ( ')' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/(x)\\g{-1})/' );
value   ( failures => [], 1 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 2, 2 );
width   ( 2, 2 );
value   ( perl_version_introduced => [], '5.009005' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 3 );
raw_width( 2, 2 );
width   ( 2, 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\g{-1}' );
value   ( perl_version_introduced => [], '5.009005' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 2 );
klass   ( 'PPIx::Regexp::Token::Unmatched' );
content ( ')' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/(?|(x)|(y))\\1/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 2, 2 );
width   ( 2, 2 );
value   ( perl_version_introduced => [], '5.009005' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 2, 2 );
width   ( 2, 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::BranchReset' );
count   ( 3 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
klass   ( 'PPIx::Regexp::Token::GroupType::BranchReset' );
content ( '?|' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 0, child => 2 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 2, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 2, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, child => 2, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, child => 2, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 2, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 2, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\1' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/(?|(x)|(yz))\\1/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( undef, undef );
width   ( undef, undef );
value   ( perl_version_introduced => [], '5.009005' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( undef, undef );
width   ( undef, undef );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::BranchReset' );
count   ( 3 );
raw_width( 1, 2 );
width   ( 1, 2 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
klass   ( 'PPIx::Regexp::Token::GroupType::BranchReset' );
content ( '?|' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 1 );
klass   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1, child => 0, child => 2 );
klass   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 2 );
raw_width( 2, 2 );
width   ( 2, 2 );
choose  ( child => 1, child => 0, child => 2, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 2, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, child => 2, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, child => 2, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 2, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 2, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, child => 2, child => 1 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\1' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( undef, undef );
width   ( undef, undef );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

parse   ( '/(?<x>y)\\g{x}/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( 2, 2 );
width   ( 2, 2 );
value   ( perl_version_introduced => [], '5.009005' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( 2, 2 );
width   ( 2, 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Structure::NamedCapture' );
count   ( 1 );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
klass   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?<x>' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\g{x}' );
value   ( perl_version_introduced => [], '5.009005' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );


note 'Recursion';

parse   ( '/x(?R)/' );
value   ( failures => [], 0 );
klass   ( 'PPIx::Regexp' );
count   ( 3 );
raw_width( undef, undef );
width   ( undef, undef );
value   ( perl_version_introduced => [], '5.009005' );
value   ( perl_version_removed => [], undef );
choose  ( child => 0 );
klass   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );
choose  ( child => 1 );
klass   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
raw_width( undef, undef );
width   ( undef, undef );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
klass   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
klass   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 1, 1 );
width   ( 1, 1 );
choose  ( child => 1, child => 1 );
klass   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?R)' );
value   ( perl_version_introduced => [], '5.009005' );
value   ( perl_version_removed => [], undef );
raw_width( undef, undef );
width   ( undef, undef );
choose  ( child => 2 );
klass   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
value   ( perl_version_introduced => [], '5.000' );
value   ( perl_version_removed => [], undef );
raw_width( 0, 0 );
width   ( 0, 0 );

# TODO: references
#       PPIx::Regexp::Token::Reference
#       This is actually an abstract class with a number of subclasses:
#     PPIx::Regexp::Token::Backreference
#       This is the \1 (absolute) and \g{-1} (relative) thingy. If I can
#       match them to their capture groups I'm set, because they match
#       whatever the capture group does.
#       I think the logic here is to take the unit_width of the corresponding
#       capture if it can be identified uniquely. This may fail in the
#       presence of branch resets (numeric back references) or multiple
#       definintions (named back references).
#     PPIx::Regexp::Token::Condition
#       The unit_width() is zero because the condition does not match
#       anything, it just determines whether a match occurred.
#       unit_raw_width() will be the same as for ::Backreference
#     PPIx::Regexp::Token::Regression (DONE)
#       Indeterminate by static analysis.
#   It might make this job much easier if I could track capture numbers
#   and names as they are created. This doesn't work for regressions,
#   but I'm not targeting them anyway at this point.

done_testing;

1;

# ex: set textwidth=72 :
