use 5.014; use warnings;
use Test::More;

plan tests => 22;

use Perl6::Form;

my $num = -13141.143131;


is form("{(>,{12.0},>>>)}", $num), "    (1,3141)\n";
is form("{(>,{12},>>>)}", $num), "    (1,3141)\n";

is form("{>{6.1}>,>>>,>>>.<}",  $num),  "####.#\n";
is form("{>{7.1}>,>>>,>>>.<}",  $num),  "#####.#\n";
is form("{>{8.1}>,>>>,>>>.<}",  $num),  "######.#\n";
is form("{>{9.1}>,>>>,>>>.<}",  $num),  "-13,141.1\n";
is form("{>{10.1}>,>>>,>>>.<}", $num),  " -13,141.1\n";
is form("{>{11.1}>,>>>,>>>.<}", $num),  "  -13,141.1\n";
is form("{>{12.1}>,>>>,>>>.<}", $num),  "   -13,141.1\n";

is form("{>{6}>,>>>,>>>}",  $num),  "######\n";
is form("{>{7}>,>>>,>>>}",  $num),  "-13,141\n";
is form("{>{8}>,>>>,>>>}",  $num),  " -13,141\n";
is form("{>{9}>,>>>,>>>}",  $num),  "  -13,141\n";
is form("{>{10}>,>>>,>>>}", $num),  "   -13,141\n";
is form("{>{11}>,>>>,>>>}", $num),  "    -13,141\n";
is form("{>{12}>,>>>,>>>}", $num),  "     -13,141\n";

is form("{,>>>,>>>}",      $num),  "   -13,141\n";
is form("{>>,>>>,>>>}",    $num),  "     -13,141\n";
is form("{>>>,>>>,>>>}",   $num),  "      -13,141\n";

is form("{-,>>>,>>>}",     $num),  "    -13,141\n";
is form("{->,>>>,>>>}",    $num),  "     -13,141\n";
is form("{->>,>>>,>>>}",   $num),  "      -13,141\n";

