#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include "cursor.h"

#include "logo1.xpm"
#include "logo2.xpm"
#include "logo3.xpm"

static char **logo[] = { logo1, logo2, logo3 };

Display *display;
Window w;

Window create_screen_window(void);
void create_null_cursor(void);
Bool create_logo_pixmap(Pixmap pix[], XpmAttributes attr[], char *logo[]);
void set_expiry_timer(long sec);
void expire_banner(int sig);
void event_loop(Pixmap pix[], const XpmAttributes attr[]);

int main(void)
{
	int i;
	Pixmap pix[3];
	XpmAttributes attr[3];

	if ((display = XOpenDisplay(NULL)) == NULL) {
		fprintf(stderr, "plamo_banner: Can't open display\n");
		exit(1);
	}
	XGrabServer(display);
	w = create_screen_window();
	create_null_cursor();
	XMapRaised(display, w);
	XFlush(display);
	for (i = 0; i < 3; i++)
		if (!create_logo_pixmap(&pix[i], &attr[i], logo[i])) {
			XCloseDisplay(display);
			exit(1);
		}
	set_expiry_timer(10);
	event_loop(pix, attr);
}

Window create_screen_window(void)
{
	unsigned long value_mask;
	XSetWindowAttributes attributes;

	value_mask = CWBackPixel | CWEventMask | CWOverrideRedirect;
	attributes.event_mask = ExposureMask;
	attributes.background_pixel = WhitePixel(display, 0);
	attributes.override_redirect = True;
	return XCreateWindow(display, RootWindow(display, 0), 0, 0,
			DisplayWidth(display, 0), DisplayHeight(display, 0),
			0, CopyFromParent, InputOutput, CopyFromParent,
			value_mask, &attributes);
}

void create_null_cursor(void)
{
	Pixmap pix_cursor, pix_mask;
	XColor black, dummy_color;
	Cursor cursor;

	pix_cursor = XCreateBitmapFromData(display, w, curbm_bits,
			cursor_width, cursor_height);
	pix_mask = XCreateBitmapFromData(display, w, maskbm_bits,
			cursor_width, cursor_height);
	XAllocNamedColor(display, DefaultColormap(display, 0), "black",
			&black, &dummy_color);
	cursor = XCreatePixmapCursor(display, pix_cursor, pix_mask,
			&black, &black, 0, 0);
	XDefineCursor(display, w, cursor);
}

Bool create_logo_pixmap(Pixmap pix[], XpmAttributes attr[], char *logo[])
{
	attr->valuemask = XpmColormap | XpmDepth | XpmCloseness;
	attr->colormap = DefaultColormap(display, 0);
	attr->depth = DefaultDepth(display, 0);
	attr->closeness = 65535;
	if (XpmCreatePixmapFromData(display, w, logo,
			pix, NULL, attr) != XpmSuccess) {
		fprintf(stderr, "plamo_banner: pixmap error\n");
		return False;
	}
	return True;
}

void set_expiry_timer(long sec)
{
	struct itimerval itv;

	itv.it_value.tv_sec = sec;
	itv.it_value.tv_usec = 0;
	itv.it_interval.tv_sec = 0;
	itv.it_interval.tv_usec = 0;
	setitimer(ITIMER_REAL, &itv, NULL);
	signal(SIGALRM, expire_banner);
}

void expire_banner(int sig)
{
	Window this_window;

	XDestroyWindow(display, this_window);
	exit(0);
}

void event_loop(Pixmap pix[], const XpmAttributes attr[])
{
	XEvent ev;
	GC gc = XCreateGC(display, w, 0, 0);
	unsigned int d_width = DisplayWidth(display, 0);
	unsigned int d_height = DisplayHeight(display, 0);
	int i = (d_width / 1280 > 2) ? 2 : d_width / 1280;

	while (True) {
		XNextEvent(display, &ev);
		if (ev.type == Expose)
			XCopyArea(display, pix[i], w, gc, 0, 0,
					attr[i].width, attr[i].height,
					(d_width - attr[i].width) / 2,
					(d_height - attr[i].height) / 2);
	}
}

