/*
 *  Emi Clock $B!=(B $HOME/.emiclockrc $BJ]B8!?I|5"=hM}(B
 */

/*
 *  Copyright (c) 1994, 1995, 1997, 1999 Masayuki Koba
 *
 *  $BK\%=%U%H%&%'%"$N%=!<%9$d%P%$%J%j$r:FG[I[$9$k>l9g$O!"<!$N>r7o$r=e<i$7$F(B
 *  $B2<$5$$!#(B
 *
 *  1. $BK\%=%U%H%&%'%"$rF~<j$7$?J}$K$O!"(BX11$BHG(B Emi Clock $B$N;HMQ8"$H!"Bh;0<T(B
 *     $B$X$N:FG[I[8"$,G'$a$i$l$^$9!#$?$@$7!":FG[I[$K4X$7$F$O!"F~<j;~$N%*%j(B
 *     $B%8%J%k$N$^$^2~JQ$;$:$K9T$&$3$H$,>r7o$G$9!#(B
 *  2. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$G2~JQ$7$FG[I[$9$k$3(B
 *     $B$H$O$G$-$^$;$s!#(B
 *  3. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$GFs<!MxMQ$9$k$3$H$O(B
 *     $B$G$-$^$;$s!#(B
 *  4. $BK\%=%U%H%&%'%"$r%7%9%F%`$K%P%s%I%k$7$?$j!"%7%9%F%`$NDI2C%Q%C%1!<%8(B
 *     $B$H$7$FBh;0<T$K:FG[I[$7$?$j$9$k>l9g$O!";vA0$KCx:n8"<T$K5v2D$,I,MW$G(B
 *     $B$9!#(B
 *  5. $BK\%=%U%H%&%'%"$r>&MQ$K;HMQ$9$k>l9g(B($B6bA,E*Mx1W$rF@$k>l9g(B)$B$O!";vA0$K(B
 *     $BCx:n8"<T$K5v2D$,I,MW$G$9!#$3$N>l9g!"4pK\E*$KM-=~$H$J$j$^$9!#(B
 *  6. $BK\%=%U%H%&%'%"$rMxMQ$9$k$3$H$K$h$C$FH/@8$7$?$$$+$J$kB;32$b!"Cx:n8"(B
 *     $B<T$OIi$o$J$$$b$N$H$7$^$9!#$3$l$K9g0U$G$-$J$$>l9g$O!";HMQ8"$,$J$$$b(B
 *     $B$N$H$7$^$9!#(B
 *  7. $B!H(BEmi Clock$B!I$N>&I8$*$h$SK\%=%U%H%&%'%"$N2hA|$d%G%6%$%s$K4X$9$kCx:n(B
 *     $B8"$O!"(BMotosoft $B$3$H!HK\(B $B=SLi!I;a$,M-$7$^$9!#(B
 *  8. $B!H(BEmi Clock$B!I$N>&I8$*$h$S2hA|$d%G%6%$%s$O!"(BX11$BHG(B Emi Clock $B3+H/$N$?(B
 *     $B$a!"(BMotosoft $B$h$j!H8E>l(B $B@59T!I$X8D?ME*$K%i%$%;%s%96!M?$5$l$F$^$9!#(B
 *     $BBh;0<T$XFs<!%i%$%;%s%96!M?$9$k$3$H$OG'$a$i$l$F$*$j$^$;$s!#(B
 *  9. Motosoft $B$H8E>l$KL5CG$G!"K\%=%U%H%&%'%"$N2hA|%G!<%?$rFs<!MxMQ$9$k$3(B
 *     $B$H$r6X;_$7$^$9!#(B
 * 10. $B$3$3$K5-=R$7$?0J30$N8"Mx$K$D$$$F$O!"F|K\9q$NCx:n8"K!$K$h$k$b$N$H$7(B
 *     $B$^$9!#(B
 */


/* $B#X%D!<%k%-%C%H%W%m%0%i%_%s%0$KI,MW$J%X%C%@!<(B */
#include <X11/Intrinsic.h>		/* $B%$%s%H%j%s%7%C%/$NDj5A(B */

/* Widgets */
#include "EmiClock.h"			/* EmiClock Widget */

/* kernel $B4X78$N%X%C%@!<(B */
#include <sys/param.h>			/* $B%7%9%F%`%Q%i%a!<%?(B */

/* $B#C8@8l%i%$%V%i%j(B */
#include <stdio.h>			/* $BI8=`F~=PNO%i%$%V%i%j(B */
#include <stdlib.h>			/* $BI8=`%i%$%V%i%j(B */
#include <sys/types.h>			/* $B7?$NDj5A(B */
#include <time.h>			/* $B;~4V4X78(B (1) */
#include <sys/time.h>			/* $B;~4V4X78(B (2) */
#include <string.h>			/* $BJ8;zNsA`:n%i%$%V%i%j(B */
#include <ctype.h>			/* $B%-%c%i%/%?A`:n(B */
#include <unistd.h>			/* unlink(2) $B$N%W%m%H%?%$%W@k8@(B */

/* Emi Clock $BFH<+$N%X%C%@!<(B */
#include "config.h"			/* $B%3%s%Q%$%k4D6-$NDj5A(B */
#include "include/system.h"		/* $B%7%9%F%`4D6-$N:9J,5[<}(B */
#include "include/const.h"		/* $BDj?tDj5A(B */
#include "include/types.h"		/* $BFC<l$J7?$NDj5A(B */
#include "include/public.h"		/* $BHFMQ4X?t!?30ItDj5A%G!<%?$N@k8@(B */
#include "include/util.h"		/* $B%^%/%mDj5A(B */

/* RCS ID */
rcsId(rcfileId, "$Id: rcfile.c,v 1.3 1999/09/02 14:33:49 koba Exp $")

/* $B%m!<%+%k4X?t$N%W%m%H%?%$%W@k8@(B */
static char *GetRcFileName __P((void));
static void CantWrite __P((FILE *, char *));
static int GetToken __P((FILE *, char *));
static Boolean GetWord __P((FILE *, char *));
static void ValueWarning __P((char *, char *, char *));
static void NoValueWarning __P((char *, char *));
#ifdef	USE_SOUND
static void SoundFileWarning __P((char *, char *, char *));
#endif	/* USE_SOUND */


/*
 *  $HOME/.emiclockrc $BJ]B8=hM}(B
 */
void
SaveRCFile()
{
    char	*rcFileName;
    FILE	*fp;
    char	buffer[MAXPATHLEN];
    RcData	rcData;
    AlarmTime	*alarmTime;

    if ((rcFileName = GetRcFileName()) == NULL) {
	return;
    }

    if ((fp = fopen(rcFileName, "w")) == NULL) {
	sprintf(buffer, "%s: Can't open \"%s\".", programName, rcFileName);
	XtWarning(buffer);
	return;
    }

    if (fprintf(fp, "%s %s version %s\n\n",
			RC_COMMENT, PRODUCT_STR, GetVersion()) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

    XtVaGetValues(emiclock,
    	XtNnoSecond,			&(rcData.isNoSecond),
    	XtNhourlyCharacterChange,	&(rcData.isHourlyCharChange),
    	XtNanimateCharacter,		&(rcData.isAnimateCharacter),
    	XtNcharNo,			&(rcData.charNo),
    	XtNcbaseNo,			&(rcData.cbaseNo),
    	XtNhourlyChime,			&(rcData.isHourlyChime),
    	XtNhalfHourChime,		&(rcData.isHalfHourChime),
    	XtNplayAlarm,			&(rcData.isPlayAlarm),
    	XtNoneTime,			&(rcData.isOneTime),
    	XtNdailyAlarm,			&(rcData.isDailyAlarm),
    	XtNalarmTime,			&alarmTime,
    	NULL);

    rcData.isNoStartupSound = app_data.isNoStartupSound;

    if (fprintf(fp, "%s\t\t%s\n", RC_IS_NO_SECOND,
			rcData.isNoSecond ? RC_TRUE : RC_FALSE) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

    if (fprintf(fp, "%s\t%s\n", RC_IS_NO_STARTUP_SOUND,
			rcData.isNoStartupSound ? RC_TRUE : RC_FALSE) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

    if (fprintf(fp, "%s\t%s\n", RC_IS_HOURLY_CHAR_CHANGE,
			rcData.isHourlyCharChange ? RC_TRUE : RC_FALSE) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

    if (fprintf(fp, "%s\t%s\n", RC_IS_ANIMATE_CHARCTER,
			rcData.isAnimateCharacter ? RC_TRUE : RC_FALSE) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

    if (fprintf(fp, "%s\t\t\t%d\n", RC_CHAR_NO, rcData.charNo) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

    if (fprintf(fp, "%s\t\t%d\n", RC_CBASE_NO, rcData.cbaseNo) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

    if (fprintf(fp, "%s\t\t%s\n", RC_IS_HOURLY_CHIME,
			rcData.isHourlyChime ? RC_TRUE : RC_FALSE) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

#ifdef	USE_SOUND
    if (fprintf(fp, "%s\t%s\n", RC_HOURLY_CHIME_FILE_NAME,
					GetHourlyChimeFileName()) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }
#endif	/* USE_SOUND */

    if (fprintf(fp, "%s\t%s\n", RC_IS_HALF_HOUR_CHIME,
			rcData.isHalfHourChime ? RC_TRUE : RC_FALSE) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

#ifdef	USE_SOUND
    if (fprintf(fp, "%s\t%s\n", RC_HALF_HOUR_CHIME_FILE_NAME,
					GetHalfHourChimeFileName()) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }
#endif	/* USE_SOUND */

    if (fprintf(fp, "%s\t\t%s\n", RC_IS_PLAY_ALARM,
			rcData.isPlayAlarm ? RC_TRUE : RC_FALSE) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

#ifdef	USE_SOUND
    if (fprintf(fp, "%s\t\t%s\n", RC_ALARM_FILE_NAME,
					GetAlarmFileName()) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }
#endif	/* USE_SOUND */

    if (fprintf(fp, "%s\t\t%02d:%02d\n", RC_ALATM_TIME,
			alarmTime->hour, alarmTime->minute) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

    if (fprintf(fp, "%s\t\t%04d/%02d/%02d\n", RC_ALATM_DATE,
		alarmTime->year, alarmTime->month, alarmTime->date) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

    if (fprintf(fp, "%s\t\t%s\n", RC_IS_ONE_TIME,
			rcData.isOneTime ? RC_TRUE : RC_FALSE) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

    if (fprintf(fp, "%s\t\t%s\n", RC_IS_DAILY_ALARM,
			rcData.isDailyAlarm ? RC_TRUE : RC_FALSE) == EOF) {
	CantWrite(fp, rcFileName);
	return;
    }

    fclose(fp);
}


/*
 *  "Can't write" Warning $BI=<((B
 */
static void
CantWrite(fp, rcFileName)
    FILE	*fp;
    char	*rcFileName;
{
    char	buffer[MAXPATHLEN];

    sprintf(buffer, "%s: Can't write \"%s\".", programName, rcFileName);
    XtWarning(buffer);
    fclose(fp);
    unlink(rcFileName);

    return;
}


/*
 *  $HOME/.emiclockrc $BI|5"=hM}(B
 */
Boolean
RestoreRCFile(rcData)
    RcData	*rcData;
{
    char	*rcFileName;
    FILE	*fp;
    int		token;
    char	tokenStr[MAXPATHLEN];
    char	buffer[MAXPATHLEN];
    long	now;
    struct tm	*tm;

    if ((rcFileName = GetRcFileName()) == NULL) {
	return(False);
    }

    if ((fp = fopen(rcFileName, "r")) == NULL) {
	return(False);
    }

    /* rcData $B$NFbMF$r!"LdBj$N$J$$CM$G=i4|2=$7$F$*$/(B */
    rcData->isNoSecond = False;
    rcData->isHourlyCharChange = False;
    rcData->isAnimateCharacter = False;
    rcData->charNo = 0;
    rcData->cbaseNo = 0;
    rcData->isHourlyChime = False;
    rcData->isHalfHourChime = False;
    rcData->isPlayAlarm = False;
    rcData->isOneTime = False;
    rcData->isDailyAlarm = False;
    now = time(NULL);
    tm = localtime(&now);
    rcData->alarmTime.year = tm->tm_year + 1900;
    rcData->alarmTime.month = tm->tm_mon + 1;
    rcData->alarmTime.date = tm->tm_mday;
    rcData->alarmTime.hour = 0;
    rcData->alarmTime.minute = 0;
    rcData->alarmTime.second = 0;

    /* $B%U%!%$%kFbMF$NFI$_9~$_(B */
    do {
	switch (token = GetToken(fp, tokenStr)) {
	case TOKEN_COMMENT:
	    do {
		token = GetToken(fp, tokenStr);
	    } while (token != TOKEN_NEWLINE);
	    break;
	case TOKEN_IS_NO_SECOND:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_TRUE:
		rcData->isNoSecond = True;
		break;
	    case TOKEN_FALSE:
		rcData->isNoSecond = False;
		break;
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_IS_NO_SECOND);
		break;
	    default:
		ValueWarning(tokenStr, rcFileName, RC_IS_NO_SECOND);
		break;
	    }
	    break;
	case TOKEN_IS_NO_STARTUP_SOUND:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_TRUE:
		rcData->isNoStartupSound = True;
		break;
	    case TOKEN_FALSE:
		rcData->isNoStartupSound = False;
		break;
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_IS_NO_STARTUP_SOUND);
		break;
	    default:
		ValueWarning(tokenStr, rcFileName, RC_IS_NO_STARTUP_SOUND);
		break;
	    }
	    break;
	case TOKEN_IS_HOURLY_CHAR_CHANGE:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_TRUE:
		rcData->isHourlyCharChange = True;
		break;
	    case TOKEN_FALSE:
		rcData->isHourlyCharChange = False;
		break;
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_IS_HOURLY_CHAR_CHANGE);
		break;
	    default:
		ValueWarning(tokenStr, rcFileName, RC_IS_HOURLY_CHAR_CHANGE);
		break;
	    }
	    break;
	case TOKEN_IS_ANIMATE_CHARCTER:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_TRUE:
		rcData->isAnimateCharacter = True;
		break;
	    case TOKEN_FALSE:
		rcData->isAnimateCharacter = False;
		break;
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_IS_ANIMATE_CHARCTER);
		break;
	    default:
		ValueWarning(tokenStr, rcFileName, RC_IS_ANIMATE_CHARCTER);
		break;
	    }
	    break;
	case TOKEN_CHAR_NO:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_DIGIT:
		rcData->charNo = atoi(tokenStr);
		if ((rcData->charNo < 0) ||
				(rcData->charNo > (NUM_OF_CHAR - 2))) {
		    rcData->charNo = 0;
		}
		break;
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_CHAR_NO);
		break;
	    default:
		ValueWarning(tokenStr, rcFileName, RC_CHAR_NO);
		break;
	    }
	    break;
	case TOKEN_CBASE_NO:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_DIGIT:
		rcData->cbaseNo = atoi(tokenStr);
		if ((rcData->cbaseNo < 0) ||
				(rcData->cbaseNo > (NUM_OF_CBASE - 1))) {
		    rcData->cbaseNo = 0;
		}
		break;
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_CBASE_NO);
		break;
	    default:
		ValueWarning(tokenStr, rcFileName, RC_CBASE_NO);
		break;
	    }
	    break;
	case TOKEN_IS_HOURLY_CHIME:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_TRUE:
		rcData->isHourlyChime = True;
		break;
	    case TOKEN_FALSE:
		rcData->isHourlyChime = False;
		break;
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_IS_HOURLY_CHIME);
		break;
	    default:
		ValueWarning(tokenStr, rcFileName, RC_IS_HOURLY_CHIME);
		break;
	    }
	    break;
	case TOKEN_IS_HALF_HOUR_CHIME:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_TRUE:
		rcData->isHalfHourChime = True;
		break;
	    case TOKEN_FALSE:
		rcData->isHalfHourChime = False;
		break;
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_IS_HALF_HOUR_CHIME);
		break;
	    default:
		ValueWarning(tokenStr, rcFileName, RC_IS_HALF_HOUR_CHIME);
		break;
	    }
	    break;
	case TOKEN_IS_PLAY_ALARM:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_TRUE:
		rcData->isPlayAlarm = True;
		break;
	    case TOKEN_FALSE:
		rcData->isPlayAlarm = False;
		break;
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_IS_PLAY_ALARM);
		break;
	    default:
		ValueWarning(tokenStr, rcFileName, RC_IS_PLAY_ALARM);
		break;
	    }
	    break;
	case TOKEN_HOURLY_CHIME_FILE_NAME:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_HOURLY_CHIME_FILE_NAME);
		break;
	    default:
#ifdef	USE_SOUND
		if (IsSoundFileExist(tokenStr)) {
		    StoreHourlyChimeFileName(tokenStr);
		} else {
		    SoundFileWarning(tokenStr,
					rcFileName, RC_HOURLY_CHIME_FILE_NAME);
		    StoreHourlyChimeFileName(GetStartupSoundFileName());
		}
#endif	/* USE_SOUND */
		break;
	    }
	    break;
	case TOKEN_HALF_HOUR_CHIME_FILE_NAME:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_HALF_HOUR_CHIME_FILE_NAME);
		break;
	    default:
#ifdef	USE_SOUND
		if (IsSoundFileExist(tokenStr)) {
		    StoreHalfHourChimeFileName(tokenStr);
		} else {
		    SoundFileWarning(tokenStr,
				rcFileName, RC_HALF_HOUR_CHIME_FILE_NAME);
		    StoreHalfHourChimeFileName(GetStartupSoundFileName());
		}
#endif	/* USE_SOUND */
		break;
	    }
	    break;
	case TOKEN_ALARM_FILE_NAME:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_ALARM_FILE_NAME);
		break;
	    default:
#ifdef	USE_SOUND
		if (IsSoundFileExist(tokenStr)) {
		    StoreAlarmFileName(tokenStr);
		} else {
		    SoundFileWarning(tokenStr,
					rcFileName, RC_ALARM_FILE_NAME);
		    StoreAlarmFileName(GetStartupSoundFileName());
		}
#endif	/* USE_SOUND */
		break;
	    }
	    break;
	case TOKEN_ALATM_TIME:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_ALATM_TIME);
		break;
	    default:
		sscanf(tokenStr, "%02d:%02d",
			&(rcData->alarmTime.hour),
			&(rcData->alarmTime.minute));
		break;
	    }
	    break;
	case TOKEN_ALATM_DATE:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_ALATM_DATE);
		break;
	    default:
		sscanf(tokenStr, "%04d/%02d/%02d",
			&(rcData->alarmTime.year),
			&(rcData->alarmTime.month),
			&(rcData->alarmTime.date));
		break;
	    }
	    break;
	case TOKEN_IS_ONE_TIME:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_TRUE:
		rcData->isOneTime = True;
		break;
	    case TOKEN_FALSE:
		rcData->isOneTime = False;
		break;
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_IS_ONE_TIME);
		break;
	    default:
		ValueWarning(tokenStr, rcFileName, RC_IS_ONE_TIME);
		break;
	    }
	    break;
	case TOKEN_IS_DAILY_ALARM:
	    switch (token = GetToken(fp, tokenStr)) {
	    case TOKEN_TRUE:
		rcData->isDailyAlarm = True;
		break;
	    case TOKEN_FALSE:
		rcData->isDailyAlarm = False;
		break;
	    case TOKEN_NEWLINE:
		NoValueWarning(rcFileName, RC_IS_DAILY_ALARM);
		break;
	    default:
		ValueWarning(tokenStr, rcFileName, RC_IS_DAILY_ALARM);
		break;
	    }
	    break;
	case TOKEN_UNKNOWN:
	    sprintf(buffer, "%s: Unknown keyword \"%s\" in \"%s\".",
					programName, tokenStr, rcFileName);
	    XtWarning(buffer);
	    do {
		token = GetToken(fp, tokenStr);
	    } while (token != TOKEN_NEWLINE);
	    break;
	case TOKEN_NEWLINE:
	case TOKEN_EOF:
	default:
	    break;
	}
    } while (token != TOKEN_EOF);

    fclose(fp);

    return(True);
}


/*
 *  $B%H!<%/%sJ8;zNs@Z$j=P$7(B
 */
static int
GetToken(fp, tokenStr)
    FILE	*fp;
    char	*tokenStr;
{
    if (!GetWord(fp, tokenStr)) {
	return(TOKEN_EOF);
    }

    if (strcmp(tokenStr, "\n") == 0) {
	return(TOKEN_NEWLINE);
    } else if (strcmp(tokenStr, RC_COMMENT) == 0) {
	return(TOKEN_COMMENT);
    } else if (strcmp(tokenStr, RC_TRUE) == 0) {
	return(TOKEN_TRUE);
    } else if (strcmp(tokenStr, RC_FALSE) == 0) {
	return(TOKEN_FALSE);
    } else if (strcmp(tokenStr, RC_IS_NO_SECOND) == 0) {
	return(TOKEN_IS_NO_SECOND);
    } else if (strcmp(tokenStr, RC_IS_NO_STARTUP_SOUND) == 0) {
	return(TOKEN_IS_NO_STARTUP_SOUND);
    } else if (strcmp(tokenStr, RC_CHAR_NO) == 0) {
	return(TOKEN_CHAR_NO);
    } else if (strcmp(tokenStr, RC_IS_HOURLY_CHAR_CHANGE) == 0) {
	return(TOKEN_IS_HOURLY_CHAR_CHANGE);
    } else if (strcmp(tokenStr, RC_IS_ANIMATE_CHARCTER) == 0) {
	return(TOKEN_IS_ANIMATE_CHARCTER);
    } else if (strcmp(tokenStr, RC_CBASE_NO) == 0) {
	return(TOKEN_CBASE_NO);
    } else if (strcmp(tokenStr, RC_IS_HOURLY_CHIME) == 0) {
	return(TOKEN_IS_HOURLY_CHIME);
    } else if (strcmp(tokenStr, RC_IS_HALF_HOUR_CHIME) == 0) {
	return(TOKEN_IS_HALF_HOUR_CHIME);
    } else if (strcmp(tokenStr, RC_IS_PLAY_ALARM) == 0) {
	return(TOKEN_IS_PLAY_ALARM);
    } else if (strcmp(tokenStr, RC_HOURLY_CHIME_FILE_NAME) == 0) {
	return(TOKEN_HOURLY_CHIME_FILE_NAME);
    } else if (strcmp(tokenStr, RC_HALF_HOUR_CHIME_FILE_NAME) == 0) {
	return(TOKEN_HALF_HOUR_CHIME_FILE_NAME);
    } else if (strcmp(tokenStr, RC_ALARM_FILE_NAME) == 0) {
	return(TOKEN_ALARM_FILE_NAME);
    } else if (strcmp(tokenStr, RC_ALATM_TIME) == 0) {
	return(TOKEN_ALATM_TIME);
    } else if (strcmp(tokenStr, RC_ALATM_DATE) == 0) {
	return(TOKEN_ALATM_DATE);
    } else if (strcmp(tokenStr, RC_IS_ONE_TIME) == 0) {
	return(TOKEN_IS_ONE_TIME);
    } else if (strcmp(tokenStr, RC_IS_DAILY_ALARM) == 0) {
	return(TOKEN_IS_DAILY_ALARM);
    } else {
	char	*p;
	Boolean	isAllDigit;

	for (p = tokenStr, isAllDigit = True; *p != '\0'; p++) {
	    if (!isdigit(*p)) {
		isAllDigit = False;
	    }
	}

	if (isAllDigit) {
	    return(TOKEN_DIGIT);
	}
    }

    return(TOKEN_UNKNOWN);
}


/*
 *  $BC18l@Z$j=P$7(B
 */
static Boolean
GetWord(fp, tokenStr)
    FILE	*fp;
    char	*tokenStr;
{
    int		c;
    int		count = 0;

    /* $B%[%o%$%H%9%Z!<%9$NFI$_Ht$P$7(B */
    if (isspace(c = fgetc(fp))) {
	while (isspace(c)) {
	    if (c == '\n') {
		*(tokenStr++) = c;
		*tokenStr = '\0';
		return(True);
	    }
	    c = fgetc(fp);
	}
    }

    if (c == EOF) {
	*tokenStr = '\0';
	return(False);
    }

    /* $BC18l$N@Z$j=P$7(B */
    while (!isspace(c)) {
	if (c == EOF) {
	    *tokenStr = '\0';
	    return(True);
	}

	*(tokenStr++) = c;
	count++;
	if (count >= (MAXPATHLEN - 1)) {
	    *tokenStr = '\0';
	    return(True);
	}

	c = fgetc(fp);
    }
    *tokenStr = '\0';
    ungetc(c, fp);

    return(True);
}


/*
 *  $BIT@5$J(B value $B$N7Y9p(B
 */
static void
ValueWarning(value, rcFileName, keyword)
    char	*value;
    char	*rcFileName;
    char	*keyword;
{
    char	buffer[MAXPATHLEN];

    sprintf(buffer, "%s: Unknown value \"%s\" in \"%s\", keyword \"%s\".",
				programName, value, rcFileName, keyword);
    XtWarning(buffer);
}


/*
 *  value $B$J$7$N7Y9p(B
 */
static void
NoValueWarning(rcFileName, keyword)
    char	*rcFileName;
    char	*keyword;
{
    char	buffer[MAXPATHLEN];

    sprintf(buffer, "%s: No value in \"%s\", keyword \"%s\".",
				programName, rcFileName, keyword);
    XtWarning(buffer);
}


/*
 *  $BB8:_$7$J$$%5%&%s%I%U%!%$%k$N7Y9p(B
 */
#ifdef	USE_SOUND
static void
SoundFileWarning(soundFileName, rcFileName, keyword)
    char	*soundFileName;
    char	*rcFileName;
    char	*keyword;
{
    char	buffer[MAXPATHLEN];

    sprintf(buffer, "%s: Can't open \"%s\" in \"%s\", keyword \"%s\".",
			programName, soundFileName, rcFileName, keyword);
    XtWarning(buffer);
}
#endif	/* USE_SOUND */


/*
 *  $HOME/.emiclockrc $B@dBP%Q%9L><hF@(B
 */
static char *
GetRcFileName()
{
    char	*home;
    char	buffer[MAXPATHLEN];
    static char	rcFileName[MAXPATHLEN];

    if ((home = getenv("HOME")) == NULL) {
	sprintf(buffer, "%s: Can't getenv(\"HOME\").", programName);
	XtWarning(buffer);
	return(NULL);
    }

    sprintf(rcFileName, "%s/%s", home, RC_FILE);

    return(rcFileName);
}
