#!/bin/bash
# Heimdal
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2010-06-17
# require:
#	OpenLDAP
#	readline
#
SRC_URI="http://www.h5l.org/dist/src/heimdal-1.3.3.tar.gz"
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/secure
PAC_DIR=$PLAMO/Packages/4.8/03_ext
BUILD_DIR=$PLAMO/heimdal
CUSTOM_DIR=$BUILD_DIR/Custom

#PAT_URI=
PAT_FILE=${PAT_URI##*/}

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R6/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME
./configure --enable-shared \
	    --infodir=/usr/heimdal/info --mandir=/usr/heimdal/man \
		--with-openssl=/usr --with-readline=/usr

make
make install DESTDIR=$WORK

mkdir -p $WORK/usr/heimdal/etc
cp -a $CUSTOM_DIR/etc/* $WORK/usr/heimdal/etc
cp -a krb5.conf $WORK/usr/heimdal/etc
cp $CUSTOM_DIR/krb5.conf.template $WORK/usr/heimdal/etc
cp $CUSTOM_DIR/services.append $WORK/usr/heimdal/etc
chown -R root:root  $WORK/usr/heimdal/etc


DOC_DIR=$WORK/usr/share/doc/$PAC_NAME
mkdir -p $DOC_DIR
cp -a TODO-shadow TODO-1.0 TODO README NEWS ChangeLog* config.log \
	doc/standardisation  	$DOC_DIR
#head config.log > $DOC_DIR/config.log.head
cp -p $BUILD_DIR/`basename $0`  $DOC_DIR/
chown -R root.root $DOC_DIR
chmod -R a+rX $DOC_DIR

cd $WORK
mkdir -p var/heimdal
mkdir -p install
cp $CUSTOM_DIR/doinst.sh install


chown -R root.root $WORK/*
chmod -R a+rX $WORK/*


echo "y
1
" | makepkg ${PAC_NAME}.tgz
# put 2 instead of 1 above if you want to append
#cat $CUSTOM_DIR/doinst.sh >> install/doinst.sh 
#tar cvfz ${PAC_NAME}.tgz  usr/heimdal/ usr/share/*/* install/doinst.sh 

mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz
cd $CWD
