/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.sei;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.server.sei.DispatchException;
import com.sun.xml.internal.ws.server.sei.EndpointMethodDispatcher;
import com.sun.xml.internal.ws.server.sei.EndpointMethodHandler;
import com.sun.xml.internal.ws.server.sei.SEIInvokerTube;
import java.util.HashMap;
import java.util.Map;

final class ActionBasedDispatcher
implements EndpointMethodDispatcher {
    private final WSBinding binding;
    private final Map<String, EndpointMethodHandler> actionMethodHandlers;
    @NotNull
    private final AddressingVersion av;

    public ActionBasedDispatcher(AbstractSEIModelImpl abstractSEIModelImpl, WSBinding wSBinding, SEIInvokerTube sEIInvokerTube) {
        this.binding = wSBinding;
        assert (wSBinding.getAddressingVersion() != null);
        this.av = wSBinding.getAddressingVersion();
        this.actionMethodHandlers = new HashMap<String, EndpointMethodHandler>();
        for (JavaMethodImpl javaMethodImpl : abstractSEIModelImpl.getJavaMethods()) {
            EndpointMethodHandler endpointMethodHandler = new EndpointMethodHandler(sEIInvokerTube, javaMethodImpl, wSBinding);
            String string = javaMethodImpl.getInputAction();
            if (string != null && !string.equals("")) {
                this.actionMethodHandlers.put(string, endpointMethodHandler);
                continue;
            }
            string = javaMethodImpl.getOperation().getOperation().getInput().getAction();
            if (string == null) continue;
            this.actionMethodHandlers.put(string, endpointMethodHandler);
        }
    }

    public EndpointMethodHandler getEndpointMethodHandler(Packet packet) throws DispatchException {
        HeaderList headerList = packet.getMessage().getHeaders();
        String string = headerList.getAction(this.av, this.binding.getSOAPVersion());
        if (string == null) {
            return null;
        }
        EndpointMethodHandler endpointMethodHandler = this.actionMethodHandlers.get(string);
        if (endpointMethodHandler != null) {
            return endpointMethodHandler;
        }
        Message message = Messages.create(string, this.av, this.binding.getSOAPVersion());
        throw new DispatchException(message);
    }
}

