#!/bin/bash
# GRASS
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2009-08-31
# require:
#	postgis
#	proj
#	gdal
#	fftw
#
SRC_URI=http://download.osgeo.org/grass/grass63/source/grass-6.3.0.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}
VERSION=${PAC_NAME##*-}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/gis
PAC_DIR=$PLAMO/Packages/4.7/10_gis
BUILD_DIR=$PLAMO/grass
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


tar xvfz $SRC_DIR/$SRC_FILE
if [ -f "$PAT_FILE" ]; then
  patch < $PAT_FILE
fi
cd $PAC_NAME || exit 1
 ./configure --prefix=/usr --enable-shared --disable-static \
    --with-proj-share=/usr/share/proj \
    --with-gdal \
    --with-postgres \
      --with-postgres-includes=/opt/pgsql/include \
      --with-postgres-libs=/opt/pgsql/lib \
    --with-sqlite \
    --with-python \
    --with-freetype --with-freetype-includes=/usr/include/freetype2 \
    --with-fftw \
    --without-readline --without-opengl

#   --with-readline --with-readline-libs=/usr/lib
#  --with-proj-includes=/usr/include
#  --with-proj-libs=/usr/lib
 make
 make install DESTDIR=$WORK
 mkdir -p $WORK/usr/bin
 cp -p /usr/bin/grass63 $WORK/usr/bin/


DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR || exit
cp -p AUTHORS ChangeLog_${VERSION}.gz SUBMITTING TODO CHANGES GPL.TXT README \
    SUBMITTING_SCRIPTS COPYING INSTALL  REQUIREMENTS.html SUBMITTING_TCLTK \
	$WORK/$DOC_DIR
chown -R root.root $WORK/$DOC_DIR
chmod -R a+rX $WORK/$DOC_DIR


# make package
cd $WORK
mkdir -p install/ || exit;
cat >install/doinst.sh<<__EOF__
#%% begin ${PAC_NAME}-${SYS_NAME}
# GRASS install script
rm -f $ROOT/usr/grass
( cd $ROOT/usr/; ln -sf grass-${VERSION} grass )

if ! fgrep "/usr/grass/lib" $ROOT/etc/ld.so.conf 1> /dev/null 2>&1; then
  echo "/usr/grass/lib" >> $ROOT/etc/ld.so.conf
else
  echo "Entry /usr/grass/lib is already in $ROOT/etc/ld.so.conf."
fi
if [ "$ROOT" != "" ] ; then
  /sbin/ldconfig
fi
#%% end
__EOF__

tar cf - /usr/bin/gem /usr/bin/grass62 /usr/grass-${VERSION}/ | tar xvf -


tar cvfz ${PAC_NAME}-${SYS_NAME}.tgz \
    usr/bin/gem    usr/bin/grass*  usr/grass-${VERSION}/ \
    $DOC_DIR install/doinst.sh

mv -v ${PAC_NAME}-${SYS_NAME}.tgz $PAC_DIR/
cd $CWD
