#!/bin/sh

SWNAME=ImageMagick-6.1.8
SWREV=9
MANDIR=/usr/share/man
DOCDIR=/usr/share/doc
ARCH=i386
BUILD=P1
PKG=${SWNAME}-${ARCH}-${BUILD}.tgz

rm -rf $SWNAME
tar zxf ${SWNAME}-${SWREV}.tar.gz
cd $SWNAME
patch -p1 < ../ImageMagick-6.1.7-ascii85encode+bugfix.patch
ln -s /usr/X11R6/include/freetype2/freetype .
patch <<EOF
--- configure._orig_	2004-05-24 00:15:22.000000000 +0900
+++ configure	2004-06-01 22:24:13.000000000 +0900
@@ -2784,9 +2784,9 @@
   CFLAGS=\$ac_save_CFLAGS
 elif test \$ac_cv_prog_cc_g = yes; then
   if test "\$GCC" = yes; then
-    CFLAGS="-g -O2"
+    CFLAGS="-O2"
   else
-    CFLAGS="-g"
+    CFLAGS=""
   fi
 else
   if test "\$GCC" = yes; then
EOF
./configure --prefix=/usr --mandir=$MANDIR
make

P=`pwd`/../pkg
rm -rf $P
mkdir -p ${P}${DOCDIR}/${SWNAME}
cp -p ../`basename $0` ../*.patch A* C* L* N* *.txt ${P}${DOCDIR}/${SWNAME}/.
chown -R root:root ${P}${DOCDIR}/${SWNAME}

_INSTALLARCHLIB=`perl -MConfig -e 'print $Config{installarchlib}'`
mkdir -p ${P}/${_INSTALLARCHLIB}

#cd PerlMagick
# perl Makefile.PL
# patch -p2 < ../../ImageMagick-6.0.1-PerlMagick-DESTDIR.patch
#cd ..
make install-strip DESTDIR=$P INSTALLMAN1DIR=${MANDIR}/man1 INSTALLMAN3DIR=${MANDIR}/man3

cd $P

(
cd ./${DOCDIR}/${SWNAME}
ln -s ../../${SWNAME}/www .
)

for i in 1 2 3 4 5 6 7 8 ; do
  if [ -d ${P}${MANDIR}/man$i ]; then
     ( cd ${P}${MANDIR}/man$i ; 
       for j in *."$i" ; do
         if [ -h $j ] ; then
           LN_TARGET=`ls -l $j | awk '{print $11}'`
           rm $j
           ln -sf $LN_TARGET.gz $j.gz
         else
           gzip $j
         fi
       done
     )
  fi
done

/sbin/makepkg $PKG <<EOF
y
y
EOF

mkdir -p install
mv ./${_INSTALLARCHLIB}/perllocal.pod install/.
ITIME=`cat install/perllocal.pod|awk 'NR==1{print $5}'`

cat >> install/doinst.sh <<EOF
touch .${_INSTALLARCHLIB}/perllocal.pod
F=\`grep "$ITIME" .${_INSTALLARCHLIB}/perllocal.pod\`
if [ "x.\$F" = "x." ] ; then
  cat install/perllocal.pod >> .${_INSTALLARCHLIB}/perllocal.pod
fi
rm install/perllocal.pod
EOF

tar zcf $PKG usr install

