/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;

public class PipedOutputStream
extends OutputStream {
    private PipedInputStream sink;
    boolean connected = false;

    public PipedOutputStream(PipedInputStream pipedInputStream) throws IOException {
        this.connect(pipedInputStream);
    }

    public PipedOutputStream() {
    }

    public void connect(PipedInputStream pipedInputStream) throws IOException {
        if (this.connected || pipedInputStream.connected) {
            throw new IOException("Already connected");
        }
        this.sink = pipedInputStream;
        pipedInputStream.closed = false;
        pipedInputStream.in = -1;
        pipedInputStream.out = 0;
        this.connected = true;
    }

    public void write(int n) throws IOException {
        this.sink.receive(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.sink.receive(byArray, n, n2);
    }

    public synchronized void flush() throws IOException {
        if (this.sink != null) {
            PipedInputStream pipedInputStream = this.sink;
            synchronized (pipedInputStream) {
                this.sink.notifyAll();
                return;
            }
        }
    }

    public void close() throws IOException {
        if (this.sink != null) {
            this.sink.receivedLast();
        }
    }
}

