<?php


class Cmd_backup
{
	public static function getinstance()
	{
		return new Cmd_backup;
	}
	
	
	public function run()
	{
		$get = KinoWiki::getinstance()->getGET();
		if(!isset($get['param'])){
			return $this->error('パラメータが足りません。');
		}
		
		switch($get['param']){
			case 'list':
				return $this->showlist();
			case 'show':
				return $this->show();
			case 'diff':
				return $this->diff();
			case 'diffnow':
				return $this->diffnow();
			case 'source':
				return $this->source();
			case 'restore':
				return $this->restore();
			case 'delete':
				return $this->delete();
			default:
				return $this->error('パラメータが違います。');
		}
	}
	
	
	protected function showlist()
	{
		$get = KinoWiki::getinstance()->getGET();
		if(isset($get['page'])){
			$page = Page::getinstance($get['page']);
			$smarty = new CmdSmarty('backup');
			$smarty->assign('pagename', $page->getpagename());
			$smarty->assign('list', $page->getbackuplist());
			$ret['title'] = $page->getpagename() . ' のバックアップ一覧';
			$ret['body'] = $smarty->fetch('list.tpl.htm');
		}
		else{
			$wiki = Wiki::getinstance();
			$smarty = new CmdSmarty('backup');
			$smarty->assign('list', $wiki->getbackuplist());
			$ret['title'] = 'バックアップ一覧';
			$ret['body'] = $smarty->fetch('alllist.tpl.htm');
		}
		return $ret;
	}
	
	
	protected function show()
	{
		$get = KinoWiki::getinstance()->getGET();
		if(!isset($get['page'])){
			return $this->error('パラメータが足りません。');
		}
		
		$num = isset($get['num']) ? $get['num'] : 1;
		$page = Page::getinstance($get['page']);
		$source = $page->getsource($num);
		$timestamp = $page->gettimestamp($num);
		
		$ret['title'] = $page->getpagename() . ' のバックアップ';
		$smarty = new CmdSmarty('backup');
		$smarty->assign('pagename', $page->getpagename());
		$smarty->assign('timestamp', $timestamp);
		$smarty->assign('backupnumber', $num);
		$smarty->assign('body', convert_block($source, $page->getpagename()));
		$ret['body'] = $smarty->fetch('show.tpl.htm');
		return $ret;
	}
	
	
	protected function diff()
	{
		$get = KinoWiki::getinstance()->getGET();
		if(!isset($get['page'])){
			return $this->error('パラメータが足りません。');
		}
		
		$num = isset($get['num']) ? $get['num'] : 1;
		$page = Page::getinstance($get['page']);
		$timestamp = $page->gettimestamp($num);
		$diff = $page->diff($num, $num+1);
		$renderer = new DiffRenderer($diff);
		
		$ret['title'] = $page->getpagename() . " の１つ前との差分";
		$smarty = new CmdSmarty('backup');
		$smarty->assign('pagename',  $page->getpagename());
		$smarty->assign('timestamp', $timestamp);
		$smarty->assign('backupnumber', $num);
		$smarty->assign('diff', $renderer->render());
		$ret['body'] = $smarty->fetch('diff.tpl.htm');
		return $ret;
	}
	
	
	protected function diffnow()
	{
		$get = KinoWiki::getinstance()->getGET();
		if(!isset($get['page'])){
			return $this->error('パラメータが足りません。');
		}
		
		$num = isset($get['num']) ? $get['num'] : 1;
		$page = Page::getinstance($get['page']);
		$timestamp = $page->gettimestamp($num);
		$diff = $page->diff(0, $num);
		$renderer = new DiffRenderer($diff);
		
		$ret['title'] = $page->getpagename() . " の現在との差分";
		$smarty = new CmdSmarty('backup');
		$smarty->assign('pagename',  $page->getpagename());
		$smarty->assign('timestamp', $timestamp);
		$smarty->assign('backupnumber', $num);
		$smarty->assign('diff', $renderer->render());
		$ret['body'] = $smarty->fetch('diffnow.tpl.htm');
		return $ret;
	}
	
	
	protected function source()
	{
		$get = KinoWiki::getinstance()->getGET();
		if(!isset($get['page'])){
			return $this->error('パラメータが足りません。');
		}
		
		$num = isset($get['num']) ? $get['num'] : 1;
		$page = Page::getinstance($get['page']);
		$source = $page->getsource($num);
		$timestamp = $page->gettimestamp($num);
		
		$ret['title'] = $page->getpagename() . ' のバックアップ';
		$smarty = new CmdSmarty('backup');
		$smarty->assign('pagename', $page->getpagename());
		$smarty->assign('timestamp', $timestamp);
		$smarty->assign('backupnumber', $num);
		$smarty->assign('source', $source);
		$ret['body'] = $smarty->fetch('source.tpl.htm');
		return $ret;
	}
	
	
	protected function restore()
	{
		$get = KinoWiki::getinstance()->getGET();
		if(!isset($get['page']) || !isset($get['num'])){
			return $this->error('パラメータが足りません。');
		}
		
		$num = isset($get['num']) ? $get['num'] : 1;
		$page = Page::getinstance($get['page']);
		$smarty = new CmdSmarty('backup');
		$smarty->assign('pagename', $page->getpagename());
		$smarty->assign('source', $page->getsource($num));
		$smarty->assign('seed', md5($page->getsource()));
		$ret['title'] = $page->getpagename() . " の復元";
		$ret['body'] = $smarty->fetch('restore.tpl.htm');
		return $ret;
	}
	
	
	protected function delete()
	{
		$get = KinoWiki::getinstance()->getGET();
		$post = KinoWiki::getinstance()->getPOST();
		if(!isset($get['page'])){
			return $this->error('パラメータが足りません。');
		}
		
		$ret['title'] = "バックアップの削除";
		$smarty = new CmdSmarty('backup');
		$smarty->assign('pagename', $get['page']);
		if(isset($post['password'])){
			if(md5($post['password']) == ADMINPASS){
				$pagename = $get['page'];
				$page = Page::getinstance($get['page']);
				$page->deletebackup();
				$ret['body'] = $smarty->fetch('delete_end.tpl.htm');
			}
			else{
				$smarty = new CmdSmarty('backup');
				$smarty->assign('error', true);
				$ret['body'] = $smarty->fetch('delete.tpl.htm');
			}
		}
		else{
			$ret['body'] = $smarty->fetch('delete.tpl.htm');
		}
		return $ret;
	}
	
	
	protected function error($str)
	{
		$ret['title'] = 'error';
		$ret['body'] = '<p class="error">' . $str . '</p>';
		return $ret;
	}
}




?>
