CREATE TABLE page(
	pagename TEXT PRIMARY KEY,
	source TEXT,
	timestamp INTEGER
);
CREATE INDEX index_page_timestamp ON page(timestamp);


CREATE TABLE pagebackup(
	number INTEGER PRIMARY KEY,
	pagename TEXT,
	source TEXT,
	timestamp INTEGER
);
CREATE INDEX index_pagebackup_pagename ON pagebackup(pagename);


CREATE TABLE attach(
	pagename TEXT,
	filename TEXT,
	binary BLOB,
	size INTEGER,
	timestamp INTEGER,
	count INTEGER
);
CREATE UNIQUE INDEX index_attach ON attach(pagename, filename);


CREATE TABLE linklist(
	linker TEXT,
	linked TEXT,
	times INTEGER
);
CREATE INDEX index_linklist_linked ON linklist(linked);


CREATE TABLE autolink(
	dir TEXT PRIMARY KEY,
	exp TEXT
);


CREATE TABLE trackback(
	num INTEGER PRIMARY KEY,
	pagename TEXT,
	title TEXT,
	excerpt TEXT,
	url TEXT,
	blog_name TEXT,
	timestamp INTEGER
);
CREATE INDEX index_trackback_pagename ON trackback(pagename);


CREATE TABLE counter(
	pagename TEXT PRIMARY KEY,
	total INTEGER,
	today INTEGER,
	yesterday INTEGER,
	date TEXT
);
CREATE INDEX index_counter_pagename ON counter(pagename);
