<?php

/* 
 *	W-AGORA 4.2
 *	-----------
 *	$Id: admin_forum.php5,v 1.42 2005/06/10 22:15:28 mdruilhe Exp $
 *	Usage:		Administration of a forum
 *	Authors:	Marc Druilhe <mdruilhe@w-agora.net>
 *				Franky <mailto:liedekef@pandora.be>
 */	

require ("init_admin.inc");

# ------------------------------------------------
# list forums if none has been selected, then exit
# ------------------------------------------------

$action = getFormVar('action');

if (empty($bn)) {
	require ("$site_cfg_file");
	display_header (sprintf (TITLE_FORUM_ADMINISTRATION, $site) );
	if ($auth->level >= ADMIN ) {

		if ($action == "quick_edit") {
			$state = getPostVar('state');
			$type = getPostVar('type');
			$moderated = (int) getPostVar('moderated');
			$query = "UPDATE $site SET state='$state', type='$type', moderated=$moderated WHERE category!=1";
			$db->query("UPDATE $site SET state='$state', type='$type', moderated=$moderated WHERE category!=1");
			msgWarning(LABEL_MASS_EDIT_FORUMS_DONE);
		}

#	get all forums if user is administrator
			$forums = $db->listForums ($site);
	} else {
#	gets only forums for which we are moderator
		$forums = $db->listForums ($site, $auth->userid);
	}

	if (is_array($forums)) {
		list_forums ($forums, LABEL_CHOOSE_FORUM, "_top");
	} else {
		if ($auth->level >= ADMIN ) {
			msgForm (sprintf(ERROR_NO_FORUM_ADMIN, $site), "create_forum.${ext}?site=$site");
		} else {
			msgForm (str_replace("{SITE}", $site, ERROR_NO_FORUM), "", "exit");
		}
	}

	if ($auth->level >= ADMIN ) {
		$state = isset($state) ? $state : 1;
		$type = isset($priv) ? $priv : 'type';
		$moderated = isset($moderated) ? $moderated : 0;

		beginForm("$WA_SELF");
		hiddenField ('action', 'quick_edit');
		table_header(TITLE_MASS_EDIT_FORUMS);
		echo "<div align=\"center\">";
		echo MSG_MASS_EDIT_FORUMS . "<br/><br/>";
?>
		
 <table border="0" width="100%">
  <tr>
   <td width="40%" align="right" valign="top" class="label"><?php echo LABEL_MASS_EDIT_FORUM_STATE ?>:</td>
   <td><?php listbox ("state", $forum_states, $state);?></td>
  </tr>
  <tr>
   <td align="right" class="label"><?php echo LABEL_MASS_EDIT_FORUM_ACCESS ?>:</td>
   <td><?php listBox ("type", $forum_types, $type); ?></td>
  </tr>
  <tr>
   <td align="right" class="label"><?php echo LABEL_MASS_EDIT_FORUM_MODERATED ?></TD>
   <td><?php radioButton ("moderated", 0, $moderated, LABEL_NO)?> <?php radioButton ("moderated", 1, $moderated, LABEL_YES)?></td>
  </tr>
 </table>
<br>
<?php 
		br();
		submitButton('go', BUTTON_UPDATE_ALL_FORUMS);
		echo "</div>";
		table_footer();
		endForm();
	}

	display_footer();
	exit;
}

$action = isset($action) ? $action : "main";

switch ($action) {

#	--------------------
#	LEFT FRAME - MENU 
#	--------------------
	case "menu":

		display_header("");
		$forum = $db->getForum($site, $bn);

		if ($auth->level >= ADMIN ) {
			$forums = $db->getForums ($site, "", "", 0);
		} else {
			$forums = $db->getForums ($site, $auth->userid, "", 0);
		} 
		if (is_array($forums) && count ($forums)>1) {
			$choose_forum_box = getListBox ("bn", $forums, "$bn", 0,  "top.location=('admin_forum.$ext?site=$site&bn='+this.options[this.selectedIndex].value)");
			$choose_forum_form = "<form action='admin_forum.$ext' target='_top'><input type='hidden' name='site' value='$site'>". LABEL_JUMP_TO . " $choose_forum_box <input type=\"submit\" value=\"".LABEL_GO.'"></form>';
		}
		print '<center><a href="http://www.w-agora.net" target="_top">';
		print '<img src="images/logo1_admin.jpg" border=0 alt="' .LABEL_AGORA_WEBSITE.'"></a></center>';

		left_menu_header (LABEL_FORUM . ": ". $forum['bn_title']);
		echo "<div class=\"menu_item\">" . LABEL_LOGGED_AS. " : <b>". $auth->userid . "</b></div>";
		echo "<div class=\"menu_item\">" . LABEL_PRIVILEGE. " : <b>". $user_privs[$auth->type] . "</b></div>";
		echo "<hr class=\"menu_sep\" />";

		left_menu_item ("admin_site.$ext?site=$site&force_login=1", "_top", LABEL_LOGIN, LABEL_RELOGIN);
		left_menu_item ("admin.$ext?site=agora&bn=", "_top", LABEL_SITES, LABEL_ADMINISTRATION_MAIN);
		left_menu_item ("admin.$ext?site=$site&bn=", "_top", LABEL_SITE." $site", sprintf(ALT_ADMINISTRATION_SITE, $site) );
		left_menu_item ("$main_page?site=$site&bn=$bn", "$bn", LABEL_ACCESS_THIS_FORUM, ALT_ACCESS_FORUM);
		if ($auth->level >= ADMIN ) {
			left_menu_item ("delete_forum.$ext?site=$site&bn=$bn", 'edit_frame', LABEL_DELETE_THIS_FORUM, sprintf (ALT_DELETE_FORUM, $forum_name)); 
		}

		if (is_array($forums) && count ($forums)>1) {
			echo "<div class=\"menu_item\">$choose_forum_form</div>";
		}
		left_menu_footer();

		include "$cfg_file";

		// NOTES
		left_menu_header (TITLE_NOTES_MANAGEMENT);
		left_menu_item ("admin_notes.$ext?site=$site&bn=$bn&hidden=all","edit_frame", LABEL_EDIT_NOTES, ALT_EDIT_NOTES);
		left_menu_item ("delete_threads.$ext?site=$site&bn=$bn","edit_frame",LABEL_MANAGE_THREADS, ALT_MANAGE_THREADS);		
		left_menu_item ("admin_notes.$ext?site=$site&bn=$bn&action=post","edit_frame",LABEL_POST_MSG, ALT_POST);
		left_menu_footer();

		//USERS
		left_menu_header (LABEL_USERS);
		left_menu_item ("admin_user.$ext?site=$site","edit_frame", COLUMN_ADMIN_USERS, ALT_USER_ADMIN);
		left_menu_item ("add_user.$ext?site=$site","edit_frame", LABEL_ADD_USER, ALT_USER_ADD);
		left_menu_item ("create_user.$ext?site=$site&bn=$bn","edit_frame", COLUMN_CREATE, ALT_USER_CREATE);
		left_menu_item ("mail_users.$ext?site=$site&bn=$bn", "edit_frame", COLUMN_MAIL_USERS, ALT_MAIL_USERS);
		if ($bn_user_mail) {
			left_menu_item ("mail_subscribed_users.$ext?site=$site&bn=$bn", "edit_frame", COLUMN_MAIL_SUBSCRIBED_USERS, ALT_MAIL_SUBSCRIBED_USERS);
			left_menu_item ("admin_subscribed_user.$ext?site=$site&bn=$bn", "edit_frame", COLUMN_ADMIN_SUBSCRIBED_USERS, ALT_ADMIN_SUBSCRIBED_USERS);
		}
		left_menu_footer();

		//CONFIGURATION
		if ($auth->level >= ADMIN ) {
			left_menu_header (LABEL_CONFIGURATION);
			left_menu_item ("editconf.$ext?site=$site&bn=$bn&mode=basic","edit_frame", LABEL_BASIC, ALT_BASIC);
			left_menu_item ("editconf.$ext?site=$site&bn=$bn&mode=advanced","edit_frame", LABEL_ADVANCED, ALT_ADVANCED);
			left_menu_item ("edit_forum.$ext?site=$site&bn=$bn","edit_frame", LABEL_PROPERTIES, ALT_PROPERTIES);
			left_menu_footer();
		}

		//LAYOUTS
		if ($auth->level > ADMIN ) {
			left_menu_header (LABEL_LAYOUT);
			left_menu_item ("editlist.$ext?site=$site&bn=$bn","edit_frame", COLUMN_NOTES_LISTING, ALT_NOTES_LISTING);
			left_menu_item ("editmsg.$ext?site=$site&bn=$bn","edit_frame", COLUMN_MESSAGES, ALT_AGORA_MESSAGES);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=form","edit_frame", COLUMN_FORM, ALT_FORM);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=mail_form","edit_frame", COLUMN_MAIL_FORM, ALT_MAIL_FORM);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=search_form","edit_frame", COLUMN_SEARCH_FORM, ALT_SEARCH_FORM);
			left_menu_item ("editfields.$ext?site=$site&bn=$bn","edit_frame", COLUMN_FIELDS, ALT_FIELDS);
			left_menu_item ("edittemplate.$ext?site=$site&bn=$bn","edit_frame", COLUMN_TEMPLATE, ALT_TEMPLATE);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=header","edit_frame", LABEL_HEADER, ALT_HEADER);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=footer","edit_frame", LABEL_FOOTER, ALT_FOOTER);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=style","edit_frame", LABEL_STYLESHEET, ALT_MODIFY_STYLESHEET);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=before_access","edit_frame", COLUMN_INCLUDED, ALT_INCLUDED);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=login_form","edit_frame", COLUMN_LOGIN, ALT_LOGIN_FORM);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=register_form","edit_frame", COLUMN_REGISTER, ALT_REGISTER_FORM);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=show_profile","edit_frame", COLUMN_PROFILE_FORM, ALT_PROFILE_FORM);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=change_password_form","edit_frame", COLUMN_CHANGE_PASSWORD, ALT_CHANGE_PASSWORD_FORM);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=forgot_password_form","edit_frame", COLUMN_FORGOT_PASSWORD, ALT_FORGOT_PASSWORD);
			left_menu_item ("editmail.$ext?site=$site&bn=$bn&file=mail_template","edit_frame",COLUMN_MAIL, ALT_MAIL_TEMPLATE);
			left_menu_item ("editform.$ext?site=$site&bn=$bn&file=subscribe_form","edit_frame", COLUMN_SUBSCRIBING, ALT_SUBSCRIBING);
			left_menu_footer();
		}
		display_footer();
	break;

#	-----------------------------------------
#	MAIN PAGE - ENTRY POINT
#	display frames : top menu + configuration
#	-----------------------------------------
	default:
		print '<head><title>'. LABEL_FORUM_ADMINISTRATION . $forum_name. '</title></head>';
		frameset ("$WA_SELF?action=menu&site=$site&bn=$bn", "admin_notes.$ext?site=$site&bn=$bn");
	break;

}

display_footer();

?>
