<?PHP

/*
 * W-AGORA 4.1
 * -----------
 * $Id: admin_sv.inc,v 1.10 2005/02/09 15:20:25 mdruilhe Exp $
 * Usage: Administration localized strings constant
 * Description: This script is used to define strings used by the administration part of the application
 * Language:		swedish
 * Translator:		Ulf Emanuelson <ulf.emanuelson@swipnet.se>		
 */

 ///////////////////
 // file setup.php3
 ///////////////////
 define ('ERROR_SETUP_ALREADY_DONE', 'w-Agora verkar redan vara installerad,<br> huvudkonfigurationsfilen (<tt>%s</tt>) finns redan,<br> du mste ta bort den (och DB tabellerna) manuellt f&ouml;r att kunna terinstallera.<br><br>tryck p knappen om du vill skapa en ny sajt');
 define ('ERROR_MISSING_ADMIN_NAME', 'Du mste ange ett namn p systemadministrat&ouml;ren');
 define ('ERROR_MISSING_ADMIN_EMAIL', 'Du mste ange en giltlig email adress');
 define ('ERROR_MISSING_DB_ACCESS', 'Du mste ange en DB access-metod');
 define ('ERROR_BAD_PASSWORD', 'l&ouml;senord mste anges och skrivas in tv g&aring;nger, var snll och bekrfta');
 define ('ERROR_MISSING_DB_NAME', 'Du m&aring;ste ange ett databasnamn');
 define ('ERROR_SF_CREATE_FILE', 'Kunde inte skapa en fil i biblioteket <u>%s</u>, kontrollera rttigheterna, eller ls instruktionerna f&ouml;r skert lge (safe mode) i <a href="doc/INSTALL.txt">INSTALL.txt filen</a>');
 define ('ERROR_COPY_FILE', 'kunde inte kopiera fil till <u>%s</u>');
 define ('ERROR_OPEN_DB', 'Kunde inte koppla upp mot databasen <u>%s</u> (host: <u>%s</u>, port: <u>%s</u>, anvndare: <u>%s</u>)');
 define ('ERROR_CREATE_CONFIG_FILE', 'Kan inte skapa konfigurationsfil <u>%s</u>, kontrollera r&auml;ttigheterna');
 define ('LABEL_SETUP_DONE', 'installationen av w-agora lyckades');
 define ('LABEL_SETUP_AGORA', 'w-agora installation');

 define ('CAPTION_DB_PARAMETERS', 'Databasparametrar (f&ouml;r sajt-tabeller)');
 define ('CAPTION_DEFAULT_PARAMETERS', 'Standardparametrar f&ouml;r sajt-konfiguration');
 define ('CAPTION_ADMIN_INFO', 'Systemadministrator\'s informationer (login : <u>admin</u>)');

 define ('LABEL_ADMIN_NAME', 'Namn');
 define ('LABEL_ADMIN_ADDRESS', 'email');
 define ('LABEL_ADMIN_PASSWORD1', 'V&auml;lj ett l&ouml;senord');
 define ('LABEL_ADMIN_PASSWORD2', 'Var sn&auml;ll och skriv in l&ouml;senordet p&aring; nytt');
 define ('BUTTON_INSTALL', 'Installera');

 /////////////////////
 //File Init_Admin.inc
 /////////////////////

 // function display_header
 define ('ADMINISTRATION_TITLE', "W-Agora administration");

 // function list_forums
 define ('COLUMN_FORUM_ADMIN', "Admin forum");
 define ('COLUMN_EDIT', "Redigera");
 define ('COLUMN_DELETE', "Radera");
 define ('COLUMN_CREATE', "Skapa");
 define ('COLUMN_ORDER', "Sortera");

 define ('MSG_ADMINISTRATE_FORUM', "Administrera forum");
 define ('ALT_DELETE_FORUM', "Radera forum : %s");
 define ('ALT_EDIT_FORUM', "Redigera forum : %s");

 define ('ERROR_SITE_EMPTY', "Du m&aring;ste ange en sajt f&ouml;r att komma in h&auml;r.");
 define ('ERROR_NO_CONFIG_FILE', "Kan inte komma &aring;t konfigurationsfilen: ");
 define ('ERROR_NO_ROOT', "Du m&aring;ste vara inloggad som systemadministrat&ouml;r f&ouml;r att f&aring; tillg&aring;ng till denna.");
 define ('ERROR_NO_ADMIN', "Du m&aring;ste vara inloggad som en administrat&ouml;r f&ouml;r att f&aring; tillg&aring;ng till denna.");
 define ('ERROR_NO_MODERATOR', "Tyv&auml;rr! Du har inte r&auml;ttighet som moderator f&ouml;r detta forum. Var sn&auml;ll och logga in igen.");

 define ('TITLE_ADMINISTRATION_LOGIN', "Administrations-login");
 define ('TITLE_INVALID_LOGIN', "Ogiltlig login. Var sn&auml;ll och logga in igen");

 define ('ERROR_NO_DATABASE', "Kunde inte koppla upp mot databasen. Kontrollera parametrarna.");

 //Function List User
 define ('COLUMN_USER_ID', "Id");
 define ('COLUMN_USER_NAME', "Namn");
 define ('COLUMN_USER_PRIVILEGE', "Rttighet");
 define ('COLUMN_USER_REGISTERED', "Registrerad");
 define ('COLUMN_USER_LOGIN_COUNT', "Antal login");
 define ('COLUMN_USER_LAST_LOGIN', "Senaste login");
 define ('COLUMN_USER_POST_COUNT', "Antal inl&auml;gg");
 define ('COLUMN_USER_LAST_POST', "Senaste inl&auml;gg");
 define ('COLUMN_ACTION', "<trans>Action");

 define ('LABEL_REG_NO_CONTROL',"Automatic registration");
 define ('LABEL_REG_CHALLENGE_RESPONSE',"RFU");	
 define ('LABEL_REG_ADMIN_APPROVAL',"Approved by administrators");

 /////////////////////
 //File Create_Site.php3
 /////////////////////
 define ('FORM_NO_SITE', "Du m&aring;ste ange namnet p&aring; sajten.");
 define ('FORM_NO_DESCRIPTION', "Var sn&auml;ll och ge en kort beskrivning av denna sajt.");
 define ('FORM_NO_DBACCESS', "Du m&aring;ste ange en access-metod.");
 define ('FORM_NO_DBNAME', "Du m&aring;ste ange ett databasnamn.");
 define ('FORM_NO_DIRECTORY', "Du m&aring;ste ange namnet p&aring; forum-biblioteket.");
 define ('FORM_SITE_LONG', "Namnet p&aring; sajten &auml;r f&ouml;r l&aring;ngt. Var sn&auml;ll och v&auml;lj ett kortare.");

 define ('CHECK_SITE_EXISTS', "Sajten {SITE} finns redan. Du m&aring;ste antingen ta bort den manuellt eller v&auml;lja ett annat namn.");
 define ('CHECK_CONFIG_EXISTS', "Konfigurationsfilen (<tt>%s</tt>) finns redan. Du m&aring;ste antingen ta bort den manuellt eller v&auml;lja ett annat namn.");

 define ('ERROR_SAFE_MODE', 'SAFE MODE &auml;r aktiverat. Du kan beh&ouml;va skapa biblioteket: {DIRECTORY}');
 define ('ERROR_CREATE_DIR', "Kan inte skapa biblioteket: {DIRECTORY}.");
 define ('ERROR_NO_PERMISSIONS', "Kontrollera r&auml;ttigheterna");

 define ('ERROR_ADMIN_NOT_FOUND', "Kunde inte hitta anv&auml;ndaridentiteten 'admin' vid huvud-agora-sajten");

 define ('ERROR_DB_DBM_EXISTS', "Forumets databas {SITE} finns redan.<br> Du m&aring;ste radera DBM filen: <em>dbm/{SITE}/{DATABASE}</em><br> [och l&aring;sfilen .lck] manuellt.");
 define ('ERROR_DB_EXISTS', "The forum's table {SITE} already exists in this database {DATABASE}, you must first drop this table manually.");
 define ('ERROR_FILESYSTEM', "Problem med tillg&auml;ngligheten. Kontrollera utrymme och r&auml;ttigheter f&ouml;r filsystemet.");
 define ('ERROR_DB_ACCESS', "Problem med tillg&auml;ngligheten. Kontrollera att du har skapat en databas med namet {DATABASE} och kontrollera access-r&auml;ttigheterna");

 define ('ERROR_CREATE_SITE', "Kunde inte skapa sajten: {SITE}.");

 define ('ERROR_TABLE_EXISTS', "Tabellen {TABLE} finns redan i databasen {DATABASE}. Du m&aring;ste f&ouml;rst ta bort tabellen manuellt.");

 define ('ERROR_CREATE_ADMIN', "Kunde inte skapa anv&auml;ndaren {USER} i den nya sajten.");
 define ('ERROR_CREATE_USER', "Kunde inte skapa anv&auml;ndaren {USER} i tabellen {TABLE}.");
 define ('ERROR_NO_ADD_SITE', "Kunde inte l&auml;gga till sajten i huvud-databasen.");

 define ('LABEL_BACK', "Tillbaka");
 define ('LABEL_CREATE_SITE_DONE', "Det gick bra att skapa sajten {SITE}<BR><BR>&nbsp;&nbsp;Du kan nu");
 define ('LABEL_CREATE_FORUM', "Skapa ett forum");
 define ('LABEL_CREATE_SITE', "Skapa en sajt");
 define ('LABEL_CREATE_THIS_SITE', "Skapa denna sajt");
 define ('LABEL_CREATE_NEW_SITE', "Skapa en ny sajt");
 define ('LABEL_CREATE_ANOTHER_SITE', "Skapa en till sajt");
 define ('LABEL_ADMINISTRATE_SITE', "Administrera denna sajt");
 define ('LABEL_SITE_MANAGEMENT', "Hantering av sajt");
 define ('CREATE_SITE_DONE', "Sajten {SITE} skapades framg&aring;ngsrikt.");

 define ('LABEL_SITE_NAME', "Sajtnamn");
 define ('LABEL_SITE_TITLE', "Titel (kort beskrivning)");
 define ('LABEL_SITE_DESCRIPTION', "Beskrivning");
 define ('LABEL_DB_PARAMETERS', "Databas-parametrar");
 define ('LABEL_DB_TYPE', "Databas-typ");
 define ('LABEL_DB_NAME', "Databas-namn");

 define ('LABEL_DB_USER', "Databas-anv&auml;ndare");
 define ('LABEL_DB_PASSWORD', "Databas-l&ouml;senord");

 define ('LABEL_DB_ADMIN_USER', "Databas admin anv&auml;ndare<br>(om tom: anv&auml;nd DB anv&auml;ndare)");
 define ('LABEL_DB_ADMIN_PASSWORD', "Databas admin l&ouml;senord");
 define ('LABEL_DB_SERVER_NAME', "Server-namn");
 define ('LABEL_DB_SERVER_PORT', "Server-port");
 define ('LABEL_DB_USER_SOURCE', "Anv&auml;ndare ursprung");

 define ('LABEL_FORUMS_CONFIGURATION', "Forum-konfiguration");

 define ('LABEL_FORUM_DIRECTORY', "Forum-bibliotek");
 define ('LABEL_SEARCH_ENGINE', "S&ouml;kmotor");
 define ('LABEL_DEFAULT_THEME', "Standardmall");
 define ('NOTICE_SAFEMODE', "SAFE MODE &auml;r aktiverat.");
 define ('NOTICE_MANUAL_INSTALL', 'du kan beh&ouml;va skapa f&ouml;ljande bibliotek manuellt:');

 /////////////////////
 //File Admin.php3
 /////////////////////
 define ('TITLE_SITE_MANAGEMENT', "Administrera sajter");
 define ('LABEL_SITES_OUTLINE', "&Ouml;versikt &ouml;ver sajter");
 define ('COLUMN_SITE_TITLE', "&Auml;mne (titel):");

 define ('ALT_DELETE_SITE', "Radera sajt: %s");
 define ('ALT_EDIT_SITE', "Redigera sajt: %s");
 define ('ERROR_NO_SITE', "Finns ingen sajt.<br> Klicka p&aring; 'OK' knappen f&ouml;r att skapa en ny.");

 /////////////////////
 //File Delete_Site.php3
 /////////////////////
 define ('TITLE_SITE_DELETE', "Radera sajt");
 define ('ERROR_NO_DELETE', "Varning: kunde inte ta bort alla tabeller/filer i {SITE}");
 define ('ERROR_NO_DELETE_AGORA', "kunde inte ta bort posten f&ouml;r sajten {SITE} i agora-databasen");
 define ('LABEL_FILE_REMOVING', "Raderar filen: ");
 define ('LABEL_DIRECTORY_REMOVING', "Raderar biblioteket: ");
 define ('LABEL_SITE_REMOVING', "Sajten {SITE} har raderats.");
 define ('LABEL_SITE_CONTENT', "Denna sajt inneh&aring;ller f&ouml;ljande forum:");
 define ('LABEL_SITE_NO_CONTENT', "Denna sajt inneh&aring;ller inga forum");
 define ('LABEL_SITE_DELETE_CONFIRMATION', "&Auml;r du s&auml;ker att du vill radera sajten '{SITE}' ?");
 define ('LABEL_DELETE_THIS_SITE', "Radera denna sajt");

 /////////////////////
 //File Edit_Site.php3
 /////////////////////
 define ('TITLE_SITE_EDIT', "Redigera sajt");
 define ('ERROR_NO_READ_SITE_PROPERTIES', "Kunde inte komma &aring;t {SITE} beskrivningen.");
 define ('ERROR_NO_UPDATE_SITE_PROPERTIES', "Kunde inte uppdatera egenskaperna hos sajten {SITE}.");
 define ('LABEL_SITE_EDITING', "Redigerar sajt: ");
 define ('LABEL_SITE_PROPERTIES', "Sajt-information");
 define ('LABEL_CHANGE_SITE_ADMINISTRATOR', "V&auml;lj/&auml;ndra den anv&auml;ndare som du vill ska vara den huvudsakliga administrat&ouml;ren av denna sajt");
 define ('COLUMN_SITE_REGISTRATION_MODE',"Registration mode");
 define ('COLUMN_SITE_PASSWORD_HANDLING',"Password handling");

 /////////////////////
 //File editList.php3
 /////////////////////
 define ('NOTICE_DEFAULT_FILE', "Varning: detta &auml;r standardfilen (default) f&ouml;r denna installation");
 define ('ERROR_NO_CURRENT_FILE', "Ingen fil &auml;r vald");
 define ('ERROR_OPEN_FILE', "Kunde inte &ouml;ppna {FILE}");

 define ('LABEL_MAXTHREADS', "Maximalt antal tr&aring;dar per sida");
 define ('LABEL_PAD', "Sekvens som anv&auml;nds som utfyllnad f&ouml;r att skapa textindrag");
 define ('LABEL_DEPTH_LIMIT', "Maximalt tr&aring;d-djup som visas");
 define ('LABEL_BEFORE_LINE', "Skript som utf&ouml;rs f&ouml;r varje rad");
 define ('LABEL_SORT', "Standard-sorteringsordning");
 define ('LABEL_HOT_COLOR', "F&ouml;r nyaste meddelanden, initiera {date_color} med: " );
 define ('LABEL_NEW_COLOR', "F&ouml;r senare meddelanden, initiera {date_color} med:" );
 define ('LABEL_NORMAL_COLOR', "F&ouml;r &auml;ldre meddelanden, initiera {date_color} med: ");
 define ('LABEL_HOT_AGE', "Antal sekunder som anv&auml;nds f&ouml;r nyaste meddelanden" );
 define ('LABEL_NEW_AGE', "Antal sekunder som anv&auml;nds f&ouml;r senare meddelanden");
 define ('LABEL_HOT_THRESHOLD', "Gr&auml;ns f&ouml;r Het-Tr&aring;d (mer &auml;r xx meddelanden, 0 = anv&auml;nds ej)");
 define ('LABEL_TYPE_FILENAME', "Ange filnamn");
 define ('TITLE_SITE_OUTLINE', "Redigera sajt-listas utseende");
 define ('TITLE_FORUM_OUTLINE', "Redigera forum-listas utseende");
 define ('TITLE_MESSAGE_OUTLINE', "Redigera meddelande-listas utseende");
 define ('LABEL_FILE_EDITING', "Redigerar fil");
 define ('LABEL_THREAD_FIRSTLINE_ODD', "F&ouml;rsta rad i TR&Aring;D (udda)");
 define ('LABEL_THREAD_FIRSTLINE_EVEN', "F&ouml;rsta rad i TR&Aring;D (j&auml;mn)");
 define ('LABEL_LEVEL_START', "Starta ny NIV&Aring; med");
 define ('LABEL_LEVEL_END', "Avsluta niv&aring; med");
 define ('LABEL_LINE_CONTENT_ODD', "Svars-rad inneh&aring;ll (udda)");
 define ('LABEL_LINE_CONTENT_EVEN', "Svars-rad inneh&aring;ll (j&auml;mn)");
 define ('LABEL_THREAD_END', "Avsluta tr&aring;d med");
 define ('LABEL_LIST_END', "Slut p&aring; lista");

 define ('LABEL_GLOBAL_FORMAT', "Globalt format f&ouml;r listor");
 define ('LABEL_DEFAULT_ORDER', "Standard-sorteringsordning<br>(i icke-tr&aring;dat l&auml;ge)");
 define ('LABEL_USE_COLOR', "Anv&auml;nd f&auml;rg");
 define ('LABEL_NEWEST_MESSAGE', "Nyaste meddelanden");
 define ('LABEL_NEW_MESSAGE', "Nya meddelanden");
 define ('LABEL_OLD_MESSAGE', "Gamla meddelanden");
 define ('LABEL_MESSAGES_NEWER_THAN', "f&ouml;r meddelanden nyare &auml;n");
 define ('LABEL_FORUM_OUTLINE', "Forum-listas utseende");
 define ('LABEL_HEAD_LISTING', "List-huvud");
 define ('LABEL_CATEGORY_LINE', "Kategori rad");

 define ('LABEL_SITE_LINE_ODD', "Sajt-rad (udda)");
 define ('LABEL_SITE_LINE_EVEN', "Sajt-rad (j&auml;mn)");

 define ('LABEL_FORUM_LINE_ODD', "Forum-rad (udda)");
 define ('LABEL_FORUM_LINE_EVEN', "Forum-rad (j&auml;mn)");
 define ('LABEL_BOTTOM_LISTING', "Slut p&aring; lista:");

 define ('EDIT_THREAD_LIST', "Redigera bassidan - lista &ouml;ver tr&aring;dar (LIST l&auml;ge): ");
 define ('LABEL_EDIT_SEARCH_LISTING' , "Redigera sida med lista &ouml;ver S&Ouml;K-resultat: ");
 define ('LABEL_SEARCH_FORM_TITLE', "Forum-titel (s&ouml;ka i flera forum):");

 define ('EDIT_THREAD_VIEW', "Redigera Tr&aring;d-lista som visas under meddelanden (GRANSKA l&auml;ge): ");
 define ('LABEL_FIRST_THREAD', "F&ouml;rsta inl&auml;gg i tr&aring;d");
 define ('EDIT_THREAD_DOWNLOAD', "Redigera list- (tr&aring;d-) format i <B>DOWNLOAD</B> l&auml;ge:");

 /////////////////////
 //File admin_site.php3
 /////////////////////
 define ('LABEL_AGORA_WEBSITE', 'W-Agora Web Sajt');
 define ('TITLE_SITE_ADMINISTRATION', 'Administration av sajt');
 define ('LABEL_RELOGIN', '&Aring;ter-inloggning (&auml;ndra anv&auml;ndare)');
 define ('LABEL_SITES', 'Lista &ouml;ver sajter');
 define ('LABEL_ADMINISTRATION_MAIN', '&Aring;ter till huvud-administrationssidan');
 define ('ALT_STATS', 'Visa statistik f&ouml;r sajten %s');
 define ('LABEL_ACCESS_THIS_SITE', 'G&aring; till denna sajt');
 define ('ALT_ACCESS_SITE', 'g&aring; till sajten %s som en anv&auml;ndare');

 define ('LABEL_CATEGORIES', "Kategorier");
 define ('COLUMN_ADMIN_USERS', "Administrera anv&auml;ndare");
 define ('COLUMN_INACTIVE_USERS', "Inaktiva anv&auml;ndare");
 define ('COLUMN_MAIL_USERS', "Maila anv&auml;ndare");

 define ('ALT_USER_EDIT', "Redigera anv&auml;ndare");
 define ('ALT_USER_ADMIN', "Hantera registrerade anv&auml;ndare");
 define ('ALT_USER_ADD', "L&auml;gg till anv&auml;ndare");
 define ('ALT_USER_DELETE', "Radera anv&auml;ndare");
 define ('ALT_INACTIVE_USERS', "Radera inaktiva anv&auml;ndare");
 define ('ALT_MAIL_USERS', "Maila anv&auml;ndare");
 define ('ALT_CATEGORY_CREATE', "L&auml;gg till kategori");
 define ('ALT_CATEGORY_EDIT', "Redigera kategori");

 define ('COLUMN_MANAGE_FORUM', "Administrera forum");
 define ('COLUMN_CHANGE_ORDER', "&Auml;ndra ordning");

 define ('ALT_FORUM_MANAGE', "Hantera forum");
 define ('ALT_FORUM_CREATE', "Skapa forum");
 define ('ALT_FORUM_ORDER', "&Auml;ndra ordningen som forumen visas p&aring;");

 define ('LABEL_FORUM_LAYOUT', "Layout p&aring; lista med forum");

 define ('LABEL_SITECONF', 'Konfiguration');
 define ('LABEL_STYLESHEET', 'Stil-format');
 define ('LABEL_HEADER', 'List-huvud');
 define ('LABEL_FORUM_LIST', 'Forum-listning');
 define ('LABEL_FOOTER', 'List-fot');
 define ('LABEL_MESSAGES', 'Meddelanden');

 define ('ALT_SITECONF', 'Redigera allm&auml;nna inst&auml;llningar f&ouml;r forum-lista (BODY, datumformat, ...)');
 define ('ALT_MODIFY_STYLESHEET', '&Auml;ndra stil-format (CSS) fil');
 define ('ALT_HEADER', '&Auml;ndra huvudet p&aring; forum-listan');
 define ('ALT_FOOTER', '&Auml;ndra foten p&aring; forum-listan');
 define ('ALT_FORUM_LIST', '&Auml;ndra layouten p&aring; forum-listan');
 define ('ALT_MESSAGES', '&Auml;ndra texter, meddelanden, bilder som visas p&aring; forum-listan');

 define ('LABEL_DEFAULT_TEMPLATES', "Standard-mallar f&ouml;r sajten");

 define ('COLUMN_PROFILE', "Visa profil");
 define ('COLUMN_LOGIN', "Login-formul&auml;r");
 define ('COLUMN_REGISTER', "Registrerings-formul&auml;r");
 define ('COLUMN_CHANGE_PASSWORD', "Formul&auml;r f&ouml;r att &auml;ndra l&ouml;senord");
 define ('COLUMN_FORGOT_PASSWORD', "Formul&auml;r f&ouml;r gl&ouml;mt l&ouml;senord");
 define ('COLUMN_MAIL', "Mall f&ouml;r emails");
 define ('COLUMN_SUBSCRIBING', "Formul&auml;r f&ouml;r prenumeration");

 define ('ALT_PROFILE_FORM', "&Auml;ndra profil-mall");
 define ('ALT_LOGIN_FORM', "&Auml;ndra login-formul&auml;r");
 define ('ALT_REGISTER_FORM', "&Auml;ndra registrerings-formul&auml;r");
 define ('ALT_CHANGE_PASSWORD_FORM', "&Auml;ndra formul&auml;r f&ouml;r att &auml;ndra l&ouml;senord");
 define ('ALT_FORGOT_PASSWORD', "&Auml;ndra formul&auml;r f&ouml;r gl&ouml;mt l&ouml;senord");
 define ('ALT_MAIL_TEMPLATE', "Konfiguration och mall f&ouml;r emails");
 define ('ALT_SUBSCRIBE_FORM', "&Auml;ndra formul&auml;r f&ouml;r prenumeration");

 define ('LABEL_USER_TEMPLATES', "Mall f&ouml;r anv&auml;ndarhantering");
 define ('COLUMN_USER_FIELDS', "F&auml;lt i anv&auml;ndarprofilen");
 define ('ALT_USER_FIELDS', "&Auml;ndra/L&auml;gg till f&auml;lt i anv&auml;ndarprofilen ");

 /////////////////////
 //File admin_Forum.php3
 /////////////////////
 define ('TITLE_FORUM_ADMINISTRATION', "Forum-administration (Sajt: %s)");
 define ('LABEL_CHOOSE_FORUM', "V&auml;lj det forum du vill administrera/redigera eller radera");
 define ('ERROR_NO_FORUM_ADMIN', "Det finns inga forum vid sajten '%s',<br> klicka p&aring; 'OK' f&ouml;r att skapa en ny.");
 define ('ERROR_NO_FORUM', "Det finns inga forum vid sajten '{SITE}' som du har ansvaret f&ouml;r.");
 define ('LABEL_FORUM_ADMINISTRATION', "Administration av forum ");
 define ('LABEL_SITE', "Sajt ");
 define ('LABEL_FORUM', "Forum");
 define ('LABEL_FORUM_ACCESS', "G&aring; till forum ");
 define ('LABEL_ACCESS_THIS_FORUM', "G&aring; till detta forum");
 define ('ALT_ADMINISTRATION_SITE', '&Aring;terg&aring; till administration av sajten %s');

 define ('TITLE_NOTES_MANAGEMENT', "Hantering av inl&auml;gg");
 define ('LABEL_EDIT_NOTES', "Hantera inl&auml;gg");
 define ('LABEL_MANAGE_THREADS', "Hantera tr&aring;dar");
 define ('LABEL_POST_MSG', "Posta ett meddelande");

 define ('ALT_EDIT_NOTES', "Radera/&Auml;ndra meddelanden");
 define ('ALT_MANAGE_THREADS', "Radera - Kopiera - Flytta diskussioner");
 define ('ALT_POST', "Posta");

 define ('LABEL_ADD_USER', "L&auml;gg till till detta forum");
 define ('COLUMN_SHOWEDIT', "Visa/Redigera");
 define ('ALT_USER_SHOWEDIT', "Visa/Redigera registrerade/v&auml;ntande anv&auml;ndare");
 define ('ALT_USER_CREATE', "L&auml;gg till anv&auml;ndare");

 define ('LABEL_CONFIGURATION', "Konfiguration");
 define ('LABEL_BASIC', "Grundl&auml;ggande");
 define ('LABEL_ADVANCED', "Avancerad");
 define ('LABEL_PROPERTIES', "Egenskaper");

 define ('ALT_BASIC', "Redigera grundl&auml;ggande konfigurationsparametrar");
 define ('ALT_ADVANCED', "Redigera avancerade konfigurationsparametrar");
 define ('ALT_PROPERTIES', "Redigera forumets egenskaper");

 define ('LABEL_LAYOUT', "Layout/Mallar");

 define ('COLUMN_NOTES_LISTING', "Inl&auml;ggslista");
 define ('COLUMN_FORM', "Formul&auml;r");
 define ('COLUMN_MAIL_FORM',"Mail form");
 define ('COLUMN_FIELDS', "F&auml;lt");
 define ('COLUMN_TEMPLATE', "Mall");
 define ('COLUMN_SEARCH_FORM', "S&ouml;kformul&auml;r");
 define ('COLUMN_INCLUDED', "Inkluderat skript");
 define ('COLUMN_PROFILE_FORM', "Profilformul&auml;r");
 define ('ALT_INCLUDED', "PHP skript som infogas innan &aring;tkomst");
 define ('ALT_TEMPLATE', "&Auml;ndra HTML-mall f&ouml;r inl&auml;gg");
 define ('ALT_FIELDS', "&Auml;ndra/Redigera databas-f&auml;lt");
 define ('ALT_SEARCH_FORM', "Redigera s&ouml;kformul&auml;r");
 define ('ALT_FORM', "Redigera HTML-formul&auml;r som anv&auml;nds f&ouml;r att Posta/Redigera inl&auml;gg");
 define ('ALT_MAIL_FORM', "Edit the form used to send private mails");
 define ('ALT_NOTES_LISTING', "&Auml;ndra/Redigera lista av inl&auml;gg");
 define ('ALT_AGORA_MESSAGES', "&Auml;ndra/Redigera meddelanden som anv&auml;nds av W-Agora");

define('LABEL_MASS_EDIT_FORUMS_DONE', '<trans>mass update has been done on all forums!');
define('TITLE_MASS_EDIT_FORUMS', '<trans>Edit settings on all forums');
define('MSG_MASS_EDIT_FORUMS', '<trans>This form enables you to edit some settings on all forums at the same time');
define('LABEL_MASS_EDIT_FORUM_STATE', '<trans>Forum state');
define('LABEL_MASS_EDIT_FORUM_ACCESS', '<trans>Access mode');
define('LABEL_MASS_EDIT_FORUM_MODERATED', '<trans>Moderated forums');
define('BUTTON_UPDATE_ALL_FORUMS', '<trans>Apply changes to all forums');

 /////////////////////
 //File Moderate_Notes.php3
 /////////////////////
 define ('TITLE_MODERATE_NOTES', 'Godk&auml;nn inkommande inl&auml;gg');
 define ('ERROR_NO_INCOMING', 'Det finns inga inl&auml;gg som ska modereras i detta forum');
 define ('LABEL_MESSAGE_DELETE_CONFIRMATION', '&Auml;r du s&auml;ker p&aring; att du vill radera detta inl&auml;gg?');
 define ('CAPTION_VALIDATE_DELETE_MESSAGE', 'Klicka p&aring; det inl&auml;gg som du vill godk&auml;nna eller radera.');
 define ('CAPTION_MESSAGE_ACTION', 'V&auml;lj den &aring;tg&auml;rd du vill utf&ouml;ra p&aring; detta inl&auml;gg.');
 define ('LABEL_VALIDATE', 'Godk&auml;nn');
 define ('LABEL_DELETE', 'Radera');

 /////////////////////
 //Admin_Notes.php3
 /////////////////////
 define ('LABEL_DELETE_FOL_NOTES', "F&ouml;ljande inl&auml;gg kommer att raderas");
 define ('LABEL_NOTES_IN_FORUM', "Inl&auml;gg i forum <font color=red>%s</font>");
 define ('LABEL_NO_FORM', "Finns inget formul&auml;r definierat f&ouml;r detta forum");
 define ('LABEL_EDIT_NOTE', "Redigera ett inl&auml;gg:");
 define ('LABEL_DISPLAY_NOTES', "Visa inl&auml;gg");
 define ('LABEL_ALL_NOTES', "Alla inl&auml;gg");
 define ('LABEL_HIDDEN', "G&ouml;mda");
 define ('LABEL_VISIBLE', "Synliga"); 
 define ('COLUMN_SHOW_NOTE', "Visa");
 define ('COLUMN_HIDE_NOTE', "G&ouml;m");
 define ('ALT_DELETE_NOTE', "Radera detta inl&auml;gg");
 define ('ALT_EDIT_NOTE', "Redigera detta inl&auml;gg");
 define ('ALT_POPUP', "Pop-up");

 define ('LABEL_COPY_FOL_NOTES', "<trans>The following notes (with ALL replies) will be copied/moved");
 define ('ACTION_MESSAGES_DELETE', "<trans>Delete selected notes");
 define ('ACTION_MESSAGES_COPY', "<trans>Copy selected notes to another thread into forum");
 define ('ERROR_DELETE_NOTE', "<trans>Couldn't delete message {NOTE} from forum {FORUM}");
 define ('LABEL_SELECT_DEST_THREAD', "<trans>Select note to attach messages");
 define ('ERROR_COPY_NOTE', "<trans>Couldn't copy note {NOTE} into forum {FORUM}");
 define ('ACTION_MESSAGES_MOVE', "<trans>[Move notes]");
 define ('ERROR_NO_DEST_FORUM', "<trans>Error: you must specify the destination forum.");
 define ('TITLE_COPY_NOTES', "<trans>Copying/moving messages");
 define ('OPEN_NEW_THREAD', "<trans>Open new thread");

 /////////////////////
 //Delete_Notes.php3
 /////////////////////
 define ('TITLE_DELETE_NOTES', "Radera ett inl&auml;gg");
 define ('CAPTION_SELECT_NOTES', "V&auml;lj de inl&auml;gg som du vill Redigera/Radera");
 define ('LABEL_DELETE_THIS', "Raderar");
 define ('CAPTION_SELECT_NOTES_DELETED', "V&auml;lj de inl&auml;gg som du vill radera");

 /////////////////////
 //Delete_Threads.php3
 /////////////////////
 define ('ERROR_INCORRECT_DATES', "Felaktigt datum");
 define ('ERROR_NO_PERIOD', "Var sn&auml;ll, v&auml;lj ett antal dagar/veckor eller m&aring;nader");
 define ('ERROR_NO_NOTES_OLDER', "Det finns inget inl&auml;gg &auml;ldre &auml;n {NUMBER} {UNIT}.");
 define ('CONFIRM_THREAD_MOVE', "&Auml;r du s&auml;ker p&aring; att du vill flytta tr&aring;dar till forum \"{FORUM}\" ?");
 define ('CONFIRM_THREAD_COPY', "&Auml;r du s&auml;ker p&aring; att du vill kopiera tr&aring;dar till forum \"{FORUM}\" ?");
 define ('CONFIRM_DELETE_THREAD', '%s tr&aring;dar kommer att tas bort. &Auml;r du s&auml;ker? ');
 define ('CONFIRM_DELETE_THREAD_DATE', '&Auml;r du s&auml;ker p&aring; att du vill ta bort alla tr&aring;dar mellan %s och %s');
 define ('ERROR_NO_THREAD', "Ingen tr&aring;d &auml;r vald");
 define ('LABEL_COPYING_NOTES', "kopierar inl&auml;gg till {FORUM}...");

 define ('ERROR_PARENT_NOT_FOUND', "Kunde inte infoga inl&auml;gg. \"parent\" fanns inte");
 define ('ERROR_COPY_THREAD', "Kunde inte kopiera tr&aring;d {THREAD} till forum {FORUM}");
 define ('ERROR_DELETE_THREAD', "Kunde inte ta bort tr&aring;den {THREAD} fr&aring;n forum {FORUM}");
 define ('ERROR_INSERT_ATTTACHMENT', "Kunde inte l&auml;gga till bilaga '{NAME}' f&ouml;r inl&auml;gget '{CLE}' i forum '{FORUM}'");

 define ('TITLE_MANAGE_THREADS', "Radera/Kopiera/Flytta tr&aring;dar");
 define ('CAPTION_SELECT_THREAD', "Ingen tr&aring;d &auml;r vald");
 define ('LABEL_SELECT_THREAD', "v&auml;lj den tr&aring;d som ska raderas eller kopieras/flyttas till ett annat forum");
 define ('LABEL_SELECT_THREAD_OR_DATE', "V&auml;lj tr&aring;dar eller v&auml;lj en r&auml;cka tr&aring;dar");
 define ('LABEL_SELECT_INDIVIDUAL_THREAD', "V&auml;lj enstaka tr&aring;dar h&auml;r inunder");
 define ('LABEL_EXECUTE', "Utf&ouml;r");
 define ('LABEL_THREAD_BETWEEN', "V&auml;lj tr&aring;dar mellan");
 define ('LABEL_THREAD_OLDER', "V&auml;lj tr&aring;dar &auml;ldre &auml;n: ");
 define ('LABEL_SELECT_ACTION', "V&auml;lj den &aring;tg&auml;rd som ska utf&ouml;ras");
 define ('ACTION_THREAD_DELETE', "Radera valda tr&aring;dar ");
 define ('ACTION_THREAD_MOVE', "flytta tr&aring;dar (radera n&auml;r dom &auml;r kopierade)");
 define ('ACTION_THREAD_COPY', "Kopiera valda tr&aring;dar till forum: ");
 define ('LABEL_REPLIES', "svar");

 /////////////////////
 //Admin_User.php3
 /////////////////////
 define ('TITLE_SITE_USER_ADMIN', "Hantera anv&auml;ndare vid sajten \"{SITE}\"");
 define ('TITLE_FORUM_USER_ADMIN', "Hantera anv&auml;ndare vid sajten \"{FORUM}\"");
 define ('TITLE_SELECT_USERS', "V&auml;lj anv&auml;ndare att hantera");
 define ('TITLE_MAIL_USERS', "Skapa email att skicka till <font color=blue>%s</font>");
 define ('LABEL_CHOOSE_USERID_INIT', "V&auml;lj en initial");
 define ('LABEL_CHOOSE_USERID_PATTERN', "Eller ange ett m&ouml;nster");
 define ('LABEL_BY_NAME', "<b>Per namn</b>");
 define ('LABEL_BY_ACTIVITY', "<b>Per aktivitet</b>");
 define ('LABEL_SHOW_NO_POST', "Visa anv&auml;ndare som aldrig postat...");
 define ('LABEL_SHOW_NO_LOGIN', "Visa anv&auml;ndare som aldrig loggat in...");
 define ('LABEL_SHOW_DIDNT_POST', "Visa anv&auml;ndare som inte postat sedan...");
 define ('LABEL_SHOW_DIDNT_LOGIN', "Visa anv&auml;ndare som inte loggat in sedan......");
 define ('LABEL_SHOW_IN_STATE', "Visa anv&auml;ndare i status: ");
 define ('LABEL_NOT_REGISTERED', "<trans>Not Registered");
 define ('LABEL_USERS_IN_STATE', "Anv&auml;ndare i status <font color=blue>%s</font> ");
 define ('LABEL_USERS_BEGINING', "Anv&auml;ndare vars ID eller namn b&ouml;rjar p&aring; <font color=blue>%s</font> ");
 define ('LABEL_USERS_NEVER_POST', "Anv&auml;ndare som aldrig postat ");
 define ('LABEL_USERS_NEVER_LOGIN', "<trans>Users who never login ");
 define ('LABEL_USERS_DIDNT_POST', "Anv&auml;ndare som inte postat sedan <font color=blue>%s %s</font> ");
 define ('LABEL_USERS_DIDNT_LOGIN', "Anv&auml;ndare som inte loggat in sedan <font color=blue>%s %s</font> ");
 define ('LABEL_REG_USERS_FORUM', "i forum <font color=red>%s</font>");
 define ('LABEL_REG_USERS_SITE', "vid sajt <font color=red>%s</font>");
 define ('LABEL_CONFIRM_USER_DELETE', "&Auml;r du s&auml;ker p&aring; att du vill radera dessa anv&auml;ndare?");
 define ('LABEL_DELETE_THESE_USERS', "Radera dessa anv&auml;ndare");
 define ('LABEL_USER_CONFIRM_DELETE', "Anv&auml;ndare <font color=blue>%s</font> har raderats");
 define ('LABEL_RETURN_LIST', "&Aring;terg&aring; till lista med anv&auml;ndare");
 define ('LABEL_EDIT_MAIL_PROFILE', "Skicka profil per email till anv&auml;ndare <font color=blue>%s</font>");
 define ('LABEL_TO', "Till");
 define ('LABEL_SEND', "Skicka email");
 define ('LABEL_REG_USER_FORUM', "Du &auml;r registrerad i detta forum");
 define ('LABEL_NO_REG_USER_FORUM', "Du &auml;r inte registrerad i detta forum");
 define ('LABEL_MAIL_USER_OK', "Email har skickat till anv&auml;ndare <font color=blue>%s</font>");
 define ('LABEL_MAIL_USER_NO_OK', "Kunde inte skicka email till anv&auml;ndare <font color=blue>%s</font>");
 define ('ERROR_NO_USER_MATCHING', "Ingen matchande anv&auml;ndare (<font color=blue>%s</font>)");
 define ('ERROR_NO_REMOVE_PRIVILEGE', "Du har inte r&auml;ttighet att radera anv&auml;ndare <font color=blue>%s</font>");
 define ('ERROR_NO_EDIT_PRIVILEGE', "Du har inte r&auml;ttighet att redigera anv&auml;ndare <font color=blue>%s</font>");
 define ('ERROR_NO_REMOVE_PERMISSION', "Anv&auml;ndaren <font color=blue>%s</font> har tillg&aring;ng till ett forum (%s) som du inte &auml;r moderator f&ouml;r.<br> Du kan inte ta bort denna anv&auml;ndare");
 define ('ERROR_SITE_USER_DELETE', "Det g&aring;r inte att radera anv&auml;ndare <font color=blue>%s</font> fr&aring;n sajten %s");
 define ('LABEL_STATUS', "Status");
 define ('ERROR_NO_MATCHING_USERS', "Inga matchande anv&auml;ndare ");
 define ('ERROR_NO_MATCHING_USER', "Anv&auml;ndare %s finns inte vid denna sajt");
 define ('ERROR_NO_OWNER_UPDATE', "Kunde inte uppdatera &auml;garen till forum %s vid sajt %s");
 define ('ERROR_NO_SITE_USER_UPDATE', "Kunde inte uppdatera anv&auml;ndare {FORUM} vid sajt {SITE}");
 define ('TITLE_EDITING_USER', "Redigerar anv&auml;ndare ");
 define ('LABEL_IN_SITE', "vid sajt");
 define ('COLUMN_USER_EMAIL', "Email");
 define ('COLUMN_USER_WEBPAGE', "Hemsida");
 define ('COLUMN_USER_DESCRIPTION', "Beskrivning");
 define ('COLUMN_USER_LASTLOGIN', "Senaste login");
 define ('COLUMN_USER_MAILOK', "Email OK");
 define ('COLUMN_USER_COUNTRY', "Land");
 define ('LABEL_UNSELECT', "&Aring;ngra val"); 
 define ('LABEL_SELECT_ALL', "<trans>Select all"); 
 define ('LABEL_WITH_SELECTED', "<trans>With selected : "); 
 define ('LABEL_MAIL_USER', "Skicka email"); 
 define ('LABEL_REMOVE_ACCESS', "<trans>Remove access"); 
 
 define ('ALT_CHANGE_PASSWORD', "&Auml;ndra anv&auml;ndares l&ouml;senord");
 define ('CAPTION_USER_PRIVILEGE', "Anv&auml;ndares r&auml;ttigheter: ");
 define ('LABEL_CHANGE_USER_PRIVILEGE', "&Auml;ndra anv&auml;ndares r&auml;ttigheter i: ");
 define ('LABEL_USER_SITE_STATUS', "User status in site : ");
 define ('LABEL_CHANGE_STATUS' , "Change status to : ");
 define ('LABEL_USER_CONFIRM_STATUS' , "User <font color=blue>%s</font> is now %s."); //$userid, $user_states[$user_state]
 define ('LABEL_MAIL_USER_STATUS' , "Send new status by mail");
 define ('LABEL_MAIL_STATUS_SUBJECT' , "Modification of your profile in sitede votre profil in site %s"); //$site
 define ('LABEL_MAIL_STATUS_BODY' , "Hello,\n administrator of site %s modified your account. Your account is now %s."); // $site, $user_state
 define ('ERROR_NO_ADMIN_CHANGE_STATUS', "Status of user 'Admin' can't be changed"); 
 define ('ERROR_NO_USER_STATUS', "Status of user couldn't be modified in site %s"); //$userid
 define ('ERROR_NO_ADMIN_CHANGE_PRIVILEGE', "R&auml;ttigheterna kan inte &auml;ndras f&ouml;r anv&auml;ndaren admin");
 define ('CAPTION_CHANGE_USER_FORUM_PRIVILEGES', "V&auml;lj de r&auml;ttigheter som du vill ge denna anv&auml;ndare");
 define ('LABEL_AS', "som ");
 define ('LABEL_GRANT_PRIVILEGES', "V&auml;lj de r&auml;ttigheter som du vill ge denna anv&auml;ndare");
 define ('COLUMN_CAN_LIST', "Lista");
 define ('COLUMN_CAN_READ', "L&auml;s");
 define ('COLUMN_CAN_WRITE', "Skriv");
 define ('COLUMN_SITE', "sajt");
 define ('LABEL_ADD_FORUM', "L&auml;gg till ett forum: ");
 define ('LABEL_MAIL_USER_PROFILE', "Maila den nya profilen till anv&auml;ndaren ");
 define ('LABEL_SHOW', "Visa");
 
 define ('ERROR_NO_ADD_PRIVILEGES', "Kunde inte ut&ouml;ka r&auml;ttigheterna f&ouml;r anv&auml;ndare %s i forum %s");

 define ('COLUMN_MAIL_SUBSCRIBED_USERS', "Maila till prenumererande anv&auml;ndare");
 define ('ALT_MAIL_SUBSCRIBED_USERS', "Skicka ett email till anv&auml;ndare som prenumererar p&aring; detta forum.");
 define ('LABEL_SEND_FORUM_SUBSCRIBED_EMAIL', "Skicka mail till anv&auml;ndare som prenumererar p&aring; forum $bn_name");
 define ('TITLE_SELECT_SUBSCRIBED_USERS', "Chose subscribed users to administrate");
 define ('LABEL_NO_SUBSCRIBED_USERS', "Inga anv&auml;ndare prenumererar p&aring; detta forum");
 define ('LABEL_IN_FORUM', "i forum");
 define ('LABEL_SUBSCRIBE_USER', "Prenumerera en ny anv&auml;ndare");
 define ('LABEL_SUBSCRIBE', "Prenumerera");
 define ('LABEL_UNSUBSCRIBE', "Avbest&auml;ll prenumeration");
 define ('LABEL_CONFIRM_USER_UNSUBSCRIBE', "&Auml;r du s&auml;ker p&aring; att du vill avbest&auml;lla prenumeration f&ouml;r dessa anv&auml;ndare?");
 define ('LABEL_CONFIRM_USER_SUBSCRIBE', "&Auml;r du s&auml;ker p&aring; att du vill best&auml;lla prenumeration f&ouml;r dessa anv&auml;ndare");
 define ('ERROR_NO_MATCHING_ADDRESS', "Prenumererande anv&auml;ndare %s fanns inte i forum %s");
 define ('COLUMN_USER_NEW_EMAIL', "Ny adress:");
 define ('LABEL_EDIT_MAIL_SUBSCRIBE', "Skicka den nya adressen till anv&auml;ndare <font color=blue>%s</font>");
 define ('LABEL_MAIL_USER_SUBSCRIBE', "Skicka den nya prenumerationen till anv&auml;ndaren");
 define ('COLUMN_ADMIN_SUBSCRIBED_USERS', "Prenumererande anv&auml;ndare");
 define ('ALT_ADMIN_SUBSCRIBED_USERS', "Administrera anv&auml;ndare som prenumererar p&aring; detta forum");
 define ('TITLE_FORUM_SUBSCRIBED_USER_ADMIN', "Administrera anv&auml;ndare som prenumererar p&aring; forum \"{FORUM}\"");
 define ('LABEL_USER_CONFIRM_UNSUBSCRIBE', "Prenumerationen f&ouml;r anv&auml;ndare <font color=blue>%s</font> har avbest&auml;llts");
 define ('LABEL_USER_CONFIRM_SUBSCRIBE', "Prenumeration f&ouml;r anv&auml;ndare <font color=blue>%s</font> har best&auml;llts");
 define ('LABEL_KEEP_THREADS', "Beh&aring;ll prenumeration p&aring; tr&aring;dar");
 define ('LABEL_MAIL_SUBSCRIBE_SUBJECT', "Din prenumeration p&aring; forum %s");
 define ('LABEL_MAIL_SUBSCRIBE_BODY_YES', "Du prenumererar nu p&aring; %s. Du kommer att f&aring; alla nya inl&auml;gg per email.");
 define ('LABEL_MAIL_SUBSCRIBE_BODY_NO', "Din prenumeration p&aring; forum %s &auml;r avbest&auml;lld. Du kommer inte l&auml;ngre f&aring; email fr&aring;n detta forum.");
 define ('LABEL_SUBSCRIBED_USERS', "<trans>Subscribed users");
 define ('LABEL_UNSUBSCRIBED_USERS', "<trans>Unsubscribed users");

 /////////////////////
 //Add_User.php3
 /////////////////////
 define ('TITLE_ADD_USER', "L&auml;gg till anv&auml;ndare");
 define ('ERROR_NO_ADD_USER', "Kunde inte l&auml;gga till anv&auml;ndare %s i tabellen %s_userforum");
 define ('WARNING_USER_ADDED', "Anv&auml;ndare '%s' har lagts till i forum '%s'");
 define ('LABEL_RETRIEVING_USERS', "H&auml;mtar alla anv&auml;ndare vid denna sajt (vad god v&auml;nta) ...");
 define ('WARNING_NO_USER_TO_ADD', "Ingen anv&auml;ndare att l&auml;gga till");
 define ('LABEL_ADD_FORUM_USER', "L&auml;gg till en anv&auml;ndare till forum <em><FONT color=#FF6633>%s</FONT></em>");
 define ('LABEL_CHOOSE_USER_ADD', "V&auml;lj en anv&auml;ndare att l&auml;gga till");
 define ('LABEL_USER_GRANT_PRIVILEGES', "<b>S&auml;tt r&auml;ttigheter f&ouml;r forum <FONT color=#FF6633>%s</font> f&ouml;r denna anv&auml;ndare</b><br>");
 define ('LABEL_ACTIVE', "Aktiv");
 define ('LABEL_FORM_SELECT', "&lt;-- V&auml;lj en post --&gt;");
 define ('LABEL_ENTER_EMAILS_TO_ADD', 'Skriv in en lista med email f&ouml;r de anv&auml;ndare du vill l&auml;gga till');
 define ('LABEL_CHOOSE_EMAILS_FILE', 'V&auml;lj en fil som inneh&aring;ller en lista med emailadresser till anv&auml;ndare');

 /////////////////////
 //Create_User.php3
 /////////////////////
 define ('TITLE_NEW_USER', "Skapa anv&auml;ndare");
 define ('ERROR_NO_PASSWORD', "L&ouml;senord m&aring;ste anges och skrivas in tv&aring; g&aring;nger, var sn&auml;ll och bekr&auml;fta");
 define ('ERROR_NO_SITE_ADD_USER', "Kunde inte l&auml;gga till anv&auml;ndare %s i tabellen %s_users");
 define ('LABEL_USER_ADDED', "Anv&auml;ndare '%s' har skapats");
 define ('LABEL_USER_SENT_FOR_APPROVAL', "His/her account will bea ctive once validated by the administrators of the site."); 
 define ('LABEL_CREATE_ANOTHER_USER', "Skapa anv&auml;ndare");
 define ('LABEL_EDIT_THIS_USER', "&Auml;ndra denna anv&auml;ndare");
 define ('ALT_EDIT_THIS_USER', "Redigera anv&auml;ndarinformation");
 define ('LABEL_SITE_CREATE_NEW_USER', "Skapa en ny anv&auml;ndare vid sajten: ");
 define ('LABEL_USER_INFORMATIONS', "Anv&auml;ndarinformation");
 define ('COLUMN_USER_PASSWORD', "Ange l&ouml;senord");
 define ('COLUMN_USER_CONFIRM_PASSWORD', "Var sn&auml;ll och skriv in l&ouml;senordet p&aring; nytt");
 define ('LABEL_ADD_MAILING_LIST', "L&auml;gga till denna anv&auml;ndare till s&auml;ndlistan?");
 define ('LABEL_CREATE_USER', "Skapa anv&auml;ndare");
 define ('LABEL_USER_PRIVILEGE', "V&auml;l r&auml;ttigheter f&ouml;r denna anv&auml;ndare");

 /////////////////////
 //Mail_Users.php3
 /////////////////////
 define ('LABEL_SEND_SITE_EMAIL', 'Skicka email till anv&auml;ndare vid sajten ');
 define ('LABEL_SEND_FORUM_EMAIL', 'Skicka email till anv&auml;ndare i forum ');
 define ('LABEL_NO_ACTIVE_USERS', 'Hittade inga aktiva anv&auml;ndare ');
 define ('LABEL_MAIL_USERS', 'Email kommer att skickas till %s anv&auml;ndare');
 define ('LABEL_USER_MAILED', 'Email skickat till <em> %s </em> <tt>&lt; %s &gt;</tt>.<br>');
 define ('LABEL_USER_NOT_MAILED', '%s &lt; %s &gt; har valt att inte ta emot email.<br>');
 define ('LABEL_MAIL_FILL_FORM', 'Fyll i detta formul&auml;r f&ouml;r att skicka ditt meddelande');
 define ('LABEL_SEND_TO_ALL', 'Skicka till ALLA anv&auml;ndare');
 define ('COLUMN_TO', 'S&auml;nd till:');
 define ('COLUMN_FROM', 'Fr&aring;n:');
 define ('COLUMN_REPLY_TO', 'Svara:');
 define ('COLUMN_MESSAGE', 'Meddelande:');
 define ('LABEL_SEND_MAIL', 'S&auml;nd mail');

 /////////////////////
 //Editconf.php3
 /////////////////////
 define ('ERROR_NO_WRITE_CONFIGURATION', "Kan inte skriva konfigurationsfil. Kontrollera r&auml;ttigheterna");
 define ('ERROR_FILE_UPLOAD_DISABLED', "<trans>File upload feature has been disabled on this server, check your PHP configuration (php.ini) or contact your ISP!!");
 define ('LABEL_CHANGE_CONFIG_DONE', "&Auml;ndringar sparades till ");
 define ('LABEL_SETTINGS_RESTORED', "Inst&auml;llningar har &aring;terst&auml;llts");
 define ('LABEL_FORUM_CONFIGURATION', "Konfiguration av forum %s");
 define ('LABEL_EDITING_FILE', "Redigerar fil: ");
 define ('TITLE_GENERAL_SETTINGS', "Generella inst&auml;llningar");
 define ('COLUMN_BODY', "Bakgrund");
 define ('ALT_BODY', "Ytterligare parametrar f&ouml;r taggen &lt;BODY&gt;");
 define ('COLUMN_DATE_FORMAT', "Datumformat");
 define ('ALT_DATE_FORMAT', "Format f&ouml;r visning av datum (se PHP dokumentation)");
 define ('COLUMN_TIME_OFFSET', "Tidsf&ouml;rskjutning");
 define ('ALT_TIME_OFFSET', "Tidsf&ouml;rskjutning fr&aring;n lokal tid (i Timmar)");
 define ('COLUMN_USE_COOKIE', "Anv&auml;nd cookies");
 define ('ALT_USE_COOKIE', "S&auml;tt/h&auml;mta cookies f&ouml;r att lagra anv&auml;ndarnamn/adress och f&ouml;r att hantera nya meddelanden");
 define ('COLUMN_ALLOW_MODIFICATION', "Till&aring;t &auml;ndringar");
 define ('ALT_ALLOW_MODIFICATION', "Till&aring;ter att anv&auml;ndaren &auml;ndrar (redigerar) inl&auml;gg. L&ouml;senord kr&auml;vs f&ouml;r att redigera ett inl&auml;gg");
 define ('COLUMN_ALLOW_DELETE', "Till&aring;t raderingar");
 define ('ALT_ALLOW_DELETE', "Till&aring;ter att anv&auml;ndaren raderar inl&auml;gg. L&ouml;senord kr&auml;vs f&ouml;r att radera ett inl&auml;gg");

 define ('TITLE_MESSAGE_FORMATING', "Formattering av inl&auml;gg");
 define ('COLUMN_ALLOW_HTML', "Till&aring;t HTML");
 define ('ALT_ALLOW_HTML', "Till&aring;ter att anv&auml;ndaren infogar HTML taggar");
 define ('COLUMN_TAGS_ALLOWED', "Till&aring;tna taggar:");
 define ('ALT_TAGS_ALLOWED', "skriv in de HTML-taggar som accepteras fr&aring;n anv&auml;ndaren, &aring;tskilda av blanksteg, komman eller semikolon (skriv inte in < och >)");
 define ('COLUMN_TAGS_DISALLOWED', "Ej till&aring;tna taggar:");
 define ('ALT_TAGS_DISALLOWED', "skriv in de HTML-taggar som kommer att censureras (tas bort) fr&aring;n anv&auml;ndarens inpput, &aring;tskilda av blanksteg, komman eller semikolon (skriv inte in < och >). Anv&auml;nds endast om f&auml;ltet 'Till&aring;tna taggar' &auml;r tom");
 define ('COLUMN_USE_SMILEY', "Anv&auml;nd smileys");
 define ('ALT_USE_SMILEY', "Omvandla smileys till ikoner (smileys accepteras enbart i f&auml;lt som accepterar HTML)");
 define ('COLUMN_CONVERT_URL', "Omvandla URLs");
 define ('ALT_CONVERT_URL', "Omvandla automatiskt URL till l&auml;nkar (enbart i f&auml;lt som accepterar HTML)");

 define ('TITLE_LAMER_FILTER', "Lamer filter");
 define ('COLUMN_DISALLOW_IP', "Ej till&aring;tna IP's:");
 define ('ALT_DISALLOW_IP', "Skriv in de IP-adresser som ej f&aring;r posta inl&auml;gg, &aring;tskilda av blanksteg, komman eller semikolon");

 define ('TITLE_FILE_UPLOAD', "Ladda upp filer");
 define ('COLUMN_FILE_UPLOAD', "St&ouml;d f&ouml;r att ladda upp filer ");
 define ('ALT_FILE_UPLOAD', "Till&aring;ter att anv&auml;nare laddar upp filer (som bilagor) till din server");
 define ('COLUMN_MAX_FILE_SIZE', "Maximal filstorlek (i bytes)");
 define ('ALT_MAX_FILE_SIZE', "Begr&auml;nsa storleken p&aring; uppladdade filer");

 define ('COLUMN_ALLOW_EXTENSION', "Till&aring;tna fil&auml;ndelser: ");
 define ('ALT_ALLOW_EXTENSION', "Skriv in de fil&auml;ndelser (t.ex.: .gif) som till&aring;ts att laddas upp, &aring;tskilda av blanksteg, komman eller semikolon");
 define ('COLUMN_DENY_EXTENSION', "Ej till&aring;tna fil&auml;ndelser: ");
 define ('ALT_DENY_EXTENSION', "Skriv in de fil&auml;ndelser (t.ex.: .gif) som INTE till&aring;ts att laddas upp, &aring;tskilda av blanksteg, komman eller semikolon (anv&auml;nds endast om f&auml;ltet 'till&aring;tna fil&auml;ndelser' &auml;r tom)");

 define ('COLUMN_ALLOW_MIME', "Till&aring;tna mime-typer: ");
 define ('ALT_ALLOW_MIME', "Skriv in de mime-typer (t.ex.: image/gif, text/*) som till&aring;ts att laddas upp, &aring;tskilda av blanksteg, komman eller semikolon (&auml;ndelserna m&aring;ste ha formatet (typ/subtyp eller typ/*)) ");
 define ('COLUMN_DENY_MIME', "Ej till&aring;tna mime-typer: ");
 define ('ALT_DENY_MIME', "Skriv in de mime-typer (t.ex.: image/gif, text/*) som INTE till&aring;ts att laddas upp, &aring;tskilda av blanksteg, komman eller semikolon (anv&auml;nds endast om f&auml;ltet 'Till&aring;tna mime-typer' &auml;r tom)");

 define ('TITLE_SEARCH', "S&ouml;k");
 define ('COLUMN_SEARCH_SUPPORT', "St&ouml;d f&ouml;r s&ouml;kning ");
 define ('ALT_SEARCH_SUPPORT', "Till&aring;ter att anv&auml;ndaren s&ouml;ker i inl&auml;ggen");
 define ('COLUMN_SEARCH_ENGINE', "S&ouml;kmotor: ");
 define ('COLUMN_PATH_NAME', "S&ouml;kv&auml;g ");
 define ('ALT_PATH_NAME', "Plats f&ouml;r s&ouml;k-programmet");
 define ('TITLE_SEND_MAIL', "Skicka email");
 define ('COLUMN_MAIL_MODERATOR', "Skicka email till moderatorn");
 define ('ALT_MAIL_MODERATOR', "Informera moderatorn per email n&auml;r ett inl&auml;gg har postats eller &auml;ndrats");
 define ('COLUMN_ALLOW_MAIL_SUBSCRIPTION', "Till&aring;t prenumeration per email");
 define ('ALT_ALLOW_MAIL_SUBSCRIPTION', "Till&aring;ter att anv&auml;ndaren f&aring;r alla svar per email");
 define ('COLUMN_ALLOW_PRIVATE_MAIL', "Allow private mails");
 define ('ALT_ALLOW_PRIVATE_MAIL', "allow users tosend private mails to the authors of notes");
 define ('COLUMN_MAIL_ATTACHMENT', "Attach files to mails");
 define ('ALT_MAIL_ATTACHMENT', "Attach \"attachment\" files to the mails sent to users");
 define ('LABEL_DEFAULT', "&Aring;ngra");

 define ('LABEL_FRAMES', "Frames");
 define ('COLUMN_USE_FRAMES', "Anv&auml;nd frames");
 define ('ALT_USE_FRAMES', "Gamla web-l&auml;sare kan anv&auml;ndas &auml;ven om detta alternativ v&auml;ljs");
 define ('COLUMN_FRAMESET_PARAMETER', "Frameset parametrar:");
 define ('ALT_FRAMESET_PARAMETER', "Ytterligare parametrar f&ouml;r taggen &lt;FRAMESET&gt; ");
 define ('COLUMN_HEADER_FRAME_PARAMETER', "Huvud Frame parameter:");
 define ('ALT_HEADER_FRAME_PARAMETER', "Ytterligare parametrar f&ouml;r taggen &lt;FRAME&gt; ");
 define ('COLUMN_FOOTER_FRAME_PARAMETER', "Fot Frame parameter:");

 define ('TITLE_POST_MESSAGES', "Posta inl&auml;gg");
 define ('COLUMN_POST_POPUP', "Posta i popup-f&ouml;nster ");
 define ('ALT_POST_POPUP', "&Ouml;ppnar ett eget f&ouml;nster f&ouml;r formul&auml;r f&ouml;r att posta/svara/redigera");
 define ('COLUMN_NO_BUTTON_BAR', "Visa inte knapp-rad");
 define ('ALT_NO_BUTTON_BAR', "Visa inte knapp-raden och alternativen vid botten av formul&auml;ret f&ouml;r att posta/svara/redigera");
 define ('COLUMN_NO_THANKS', "Visa inte Tack ");
 define ('ALT_NO_THANKS', "Visa n&auml;sta sida efter postning/redigering utan att visa meddelande med tack");
 define ('COLUMN_AFTER_POSTING', "&Aring;terv&auml;nd till, efter postning,");
 define ('ALT_AFTER_POSTING', "Sida att &aring;terv&auml;nda till efter postning");
 define ('COLUMN_NEWLY_POSTED', "Det postade inl&auml;gget");
 define ('COLUMN_MESSAGE_LIST', "Lista med inl&auml;gg");
 define ('COLUMN_FIRST_MESSAGE', "F&ouml;rsta inl&auml;gg i tr&aring;d");

 define ('TITLE_INCLUDE_FILES', "Inkluderade filer (alla filer finns i %s). L&auml;mna dessa f&auml;lt blanka f&ouml;r att anv&auml;nda standard");

 define ('COLUMN_CSS_FILE', "Stil-format (CSS) fil:");
 define ('ALT_CSS_FILE', "CSS fil (inkluderas i &lt;HEAD&gt; taggen:");
 define ('COLUMN_HEADER_FILE', "Huvud");
 define ('ALT_HEADER_FILE', "Fil som anv&auml;nds f&ouml;r list-huvud");
 define ('COLUMN_FOOTER_FILE', "Fot");
 define ('ALT_FOOTER_FILE', "Fil som anv&auml;nds f&ouml;r list-fot");
 define ('COLUMN_LISTING_OUTLINE', "Inl&auml;ggsista");
 define ('ALT_LISTING_OUTLINE', "Format f&ouml;r listning av inl&auml;gg");
 define ('COLUMN_INCLUDE_MESSAGES', "Meddelanden");
 define ('ALT_INCLUDE_MESSAGES', "Meddelanden och ikoner som visas");
 define ('COLUMN_FORM_FILE', "Formul&auml;r");
 define ('ALT_FORM_FILE', "FORMUL&Auml;R som anv&auml;nds f&ouml;r att posta/svara/redigera inl&auml;gg");
 define ('COLUMN_MAIL_FORM_FILE', "Private mails form");
 define ('ALT_MAIL_FORM_FILE', "form used to send private mails");
 define ('COLUMN_FILE_SEARCH', "S&ouml;kformul&auml;r");
 define ('ALT_FILE_SEARCH', "Formul&auml;r f&ouml;r s&ouml;kning");
 define ('COLUMN_TEMPLATE_FILE', "Mall");
 define ('ALT_TEMPLATE_FILE', "Mall f&ouml;r inl&auml;gg");
 define ('COLUMN_FIELDS_NAME', "F&auml;lt");
 define ('ALT_FIELDS_NAME', "Databasf&auml;lt (variabel) definition");
 define ('COLUMN_PHP_INCLUDE', "PHP-fil som inkluderas f&ouml;re access");
 define ('ALT_PHP_INCLUDE', "Valfri PHP-fil som k&ouml;rs (inkluderas) innan data infogas");
 define ('COLUMN_FILE_LOGIN', "Login-formul&auml;r");
 define ('ALT_FILE_LOGIN', "Formul&auml;r f&ouml;r anv&auml;ndar-login");
 define ('COLUMN_REGISTER_FORM', "Registerings-formul&auml;r");
 define ('ALT_FILE_REGISTER', "Formul&auml;r f&ouml;r registrering av anv&auml;ndare");
 define ('COLUMN_SHOW_PROFILE', "Mall f&ouml;r att visa profil");
 define ('ALT_FILE_SHOW_PROFILE', "Visar anv&auml;ndares profil");
 define ('COLUMN_FILE_CHANGE_PASSWORD', "Formul&auml;r f&ouml;r att &auml;ndra l&ouml;senord");
 define ('ALT_FILE_CHANGE_PASSWORD', "Formul&auml;r f&ouml;r att &auml;ndra l&ouml;senord");
 define ('COLUMN_FILE_FORGOT_PASSWORD', "Formul&auml;r f&ouml;r gl&ouml;mt l&ouml;senord");
 define ('ALT_FILE_FORGOT_PASSWORD', "Formul&auml;r f&ouml;r anv&auml;ndare som gl&ouml;mt l&ouml;senord");
 define ('COLUMN_FILE_MAIL_TEMPLATE', "Mall f&ouml;r email");
 define ('ALT_FILE_MAIL_TEMPLATE', "Konfigurering och mallar f&ouml;r email");
 define ('COLUMN_SUBSCRIBE_FORM_TEMPLATE', "Formul&auml;r f&ouml;r prenumeration");
 define ('ALT_FILE_SUBSCRIBE_FORM', "Formul&auml;r f&ouml;r prenumeration av forum per email");

 define ('TITLE_DISCUSSION_BOARD', "Diskussionsforum");
 define ('COLUMN_ALLOW_REPLIES', "Till&aring;t svar (tr&aring;da inl&auml;gg)");
 define ('ALT_ALLOW_REPLIES', "Till&aring;ter att anv&auml;ndarna svarar p&aring; inl&auml;gg (tr&aring;dar)");

 define ('TITLE_DISPLAYED_MESSAGE', "Visade inl&auml;gg");
 define ('COLUMN_NO_TOOLBAR', "Ingen verktygsrad i inl&auml;gg ");
 define ('ALT_NO_TOOLBAR', "Visa inte meny-raden (svara|redigera|radera|lista) i slutet av det visade inl&auml;gget");
 define ('COLUMN_NO_NAVIGATION_BAR', "Ingen navigeringsrad i inl&auml;gg");
 define ('ALT_NO_NAVIGATION_NAR', "Visa inte navigeringsraden (n&auml;sta/f&ouml;reg&aring;ende tr&aring;d/inl&auml;gg URLs) i det visade inl&auml;gget");
 define ('COLUMN_NO_THREAD', "Ingen tr&aring;d i inl&auml;gg");
 define ('ALT_NO_THREAD', "Visa inte aktuell tr&aring;d i det visade inl&auml;gget");
 define ('COLUMN_APPEND_MESSAGE', "L&auml;gg till svarsformul&auml;r i visat inl&auml;gg");
 define ('ALT_APPEND_MESSAGE', "Visar formul&auml;r f&ouml;r svar i slutet p&aring; det visade inl&auml;gget");

 define ('TITLE_MESSAGE_LISTING', "Lista med inl&auml;gg");
 define ('COLUMN_MESSAGE_NO_NAVIGATION_BAR', "Ingen navigeringsrad i listan");
 define ('ALT_MESSAGE_NO_NAVIGATION_NAR', "Visa inte navigeringsraden (n&auml;sta/f&ouml;reg&aring;ende sida URLs) i listan &ouml;ver inl&auml;gg");
 define ('COLUMN_GUESTBOOK', "L&auml;gg till formul&auml;r f&ouml;r postning i listan");
 define ('ALT_GUESTBOOK', "Visa formul&auml;r f&ouml;r postning av inl&auml;gg i slutet av listan &ouml;ver inl&auml;gg (g&auml;stboks-stil)");

 define ('TITLE_BROWSE_SERVER', "S&ouml;k filer p&aring; servern");
 define ('COLUMN_BROWSE_SERVER', "St&ouml;d f&ouml;r att s&ouml;ka filer p&aring; servern");
 define ('ALT_BROWSE_SERVER', "Till&aring;ter att anv&auml;ndare bifogar filer som finns p&aring; din server");
 define ('COLUMN_BASE_DIRECTORY', "Bas-bibliotek");
 define ('ALT_BASE_DIRECTORY', "Definiera det top-niv&aring; bibliotek anv&auml;ndare kan s&ouml;ka efter dokument att bifoga");

 /////////////////////
 //Edit_Forum.php3
 /////////////////////
 define ('LABEL_EDIT_FORUM', "Redigera egenskaper f&ouml;r forum");
 define ('LABEL_SITE_EDIT_FORUM', "V&auml;lj det forum du vill redigera vid sajten %s");
 define ('ERROR_NO_FORUM_UPDATE', "Kunde inte uppdatera forum %s vid sajten %s");
 define ('ERROR_NO_NEW_MODERATOR', "Kunde inte ge anv&auml;ndaren %s moderators r&auml;ttigheter f&ouml;r forum %s ");
 define ('LABEL_EDIT_FORUM_SHORT', "Redigera forum: ");
 define ('LABEL_FORUM_INFORMATION', "Information om forum");
 define ('COLUMN_STATE', "Status");
 define ('COLUMN_CATEGORY', "Kategori");
 define ('LABEL_PRIVACY_INFORMATION', "Information ang&aring;ende &aring;tkomst");
 define ('LABEL_CHANGE_ACCESS', "&Auml;ndra access-metod f&ouml;r detta forum");
 define ('LABEL_MODERATED', "modererad");
 define ('LABEL_UPDATE_THIS_FORUM' , "Uppdatera forum");
 define ('LABEL_CHOOSE_MODERATOR', "V&auml;lj/&auml;ndra den anv&auml;ndare som skall vara huvudsaklig moderator av detta forum");

 /////////////////////
 //admin_categories.php3
 /////////////////////
 define ('LABEL_EDIT_CATEGORIES', "Redigera kategorier vid sajten ");
 define ('LABEL_ADD_CATEGORY', "L&auml;gg till kategori");
 define ('COLUMN_EDIT_CATEGORY', "&Auml;ndra kategori ");
 define ('COLUMN_DELETE_CATEGORY', "Radera kategori ");
 define ('COLUMN_CAT_TITLE', "Kategorititel");
 define ('LABEL_UPDATE_ORDER', "Uppdatera ordning");
 define ('LABEL_ADD_NEW_CATEGORY', "L&auml;gg till en ny kategori");
 define ('LABEL_ADD_THIS_CATEGORY', "L&auml;gg till denna kategori");
 define ('LABEL_EDIT_CATEGORY', "Redigera kategori");
 define ('LABEL_UPDATE_THIS_CATEGORY', "Uppdatera denna kategori");

 /////////////////////
 //Create_Forum.php3
 /////////////////////
 define ('TITLE_CREATE_FORUM', "Skapa forum");
 define ('ERROR_FORUM_NAME_TO_LONG', "Namnet p&aring; forumet &auml;r f&ouml;r l&aring;ngt. Var sn&auml;ll och v&auml;lj ett kortare namn.");
 define ('ERROR_CONFIG_FILE_EXISTS', "Konfigurationsfilen (%s) finns redan. Du m&aring;ste ta bort den manuellt eller v&auml;lja ett annat namn");
 define ('ERROR_NO_FILE_COPY', "Kunde inte kopiera filen %s");

 define ('ERROR_FORUM_DB_DBM_EXISTS', "Sajt-databasen %s finns redan.<br> Du m&aring;ste ta bort DBM filen: <em>dbm/%s/%s</em><br> [och lockfilen .lck] manuellt");
 define ('ERROR_FORUM_DB_EXISTS', "Forumets tabell (%s) finns redan i denna databas (%s). Du m&aring;ste f&ouml;rst ta bort tabellen manuellt eller v&auml;lja ett annat namn");

 define ('ERROR_FORUM_DB_DBM_ACCESS', "Access-problem. Kunde inte skapa DBM fil (<em>%s</em>) Kontrollera utrymme och r&auml;ttigheter i filsystemet");
 define ('ERROR_FORUM_DB_ACCESS', "Access-problem. Kunde inte skapa tabell (<em>%s</em>) Kontrollera att du har skapat en databas med namnet %s och kontrollera access-r&auml;ttigheterna");
 define ('ERROR_NO_CREATE_FORUM', "Kunde inte skapa forum:");
 define ('ERROR_NO_FORUM_INSERT', "Kunde inte skapa forum %s vid sajten %s");
 define ('LABEL_FORUM_CREATED', "Forum '<em>%s</em>' har skapats vid sajten %s<BR><BR>&nbsp;&nbsp;Du kan nu:");
 define ('LABEL_CREATE_ANOTHER_FORUM', "Skapa ett till forum");
 define ('ALT_ACCESS_FORUM', "G&aring; till forum");
 define ('LABEL_ADMINISTRATE_FORUM', "Administrera forum");
 define ('ALT_ADMINISTRATE_FORUM', "Hantera inl&auml;gg i detta forum");
 define ('LABEL_EDIT_THIS_FORUM', "Redigera detta forum");
 define ('ALT_EDIT_THIS_FORUM', "Redigera inst&auml;llningar f&ouml;r detta forum");
 define ('LABEL_SITE_ADMINISTRATION', "&Aring;terv&auml;nd till sajt-administrationen");
 define ('LABEL_FORUM_CREATED_SUCCESSFULLY', "Forumet %s skapades framg&aring;ngsrikt");
 define ('LABEL_INSTALL_FORUM', "Installera ett nytt forum vid sajt: ");
 define ('COLUMN_GIVE_FORUM_NAME', "Namn p&aring; forum:");
 define ('COLUMN_FORUM_TEMPLATE', "V&auml;lj en mall (tema):");
 define ('LABEL_SET_ACCESS', "V&auml;lj access-metod f&ouml;r detta forum:");
 define ('LABEL_CREATE_THIS_FORUM', "Skapa detta forum");
 define ('LABEL_NAME_OF_FORUM', "(det namn du ger till detta forum)");
 define ('LABEL_CHOOSE_FIRST_MODERATOR', "V&auml;lj en anv&auml;ndare (&auml;gare) som ska moderera detta forum:");

 /////////////////////
 //Reorder_Forum.php3
 /////////////////////
 define ('TITLE_REORDER_FORUM', "&Auml;ndra den ordning som forumen visas p&aring; vid sajten: ");
 define ('LABEL_CHANGE_FORUM_ORDER', "H&auml;r under kan du &auml;ndra den ordning som forumen visas p&aring;. Tilldela varje forum ett unikt nummer, men starta med 1. Ett v&auml;rde av 0 g&ouml;r att forumet inte visas i listan");


 /////////////////////
 //editform.php3
 /////////////////////
 define ('LABEL_NEW_FILE_EDITING', "Redigerar en ny fil:");
 define ('WARNING_EDITING_DEFAULT', "VARNING: detta &auml;r standard-filen f&ouml;r denna sajt! &Auml;ndringar p&aring;verkar alla forum vid denna sajt som anv&auml;nder denna standard.");
 define ('LABEL_SPECIFIC_TEMPLATE', "ange ett namn p&aring; <a href='%s'>sidan f&ouml;r inst&auml;llningar</a>, om du vill anv&auml;nda en speciell mall");

 /////////////////////
 //editmsg.php3
 /////////////////////
 define ('TITLE_EDITING_MESSAGES', "Redigerar meddelanden");
 define ('ERROR_NO_CREATE_MESSAGE', "Kunde inte skapa fil med meddelanden. Kontrollera r&auml;ttigheter");

 /////////////////////
 //editfields.php3
 /////////////////////
 define ('TITLE_EDITING_FIELDS', 'Redigerar f&auml;lt');
 define ('LABEL_NAME', 'Namn');
 define ('LABEL_SIZE', 'Storlek');
 define ('LABEL_REQUIRED', 'Kr&auml;vs');
 define ('LABEL_LISTED', 'Listas');
 define ('LABEL_ACCEPT_HTML', 'Acceptera HTML/smileys');
 define ('LABEL_SAVE_COOKIE', 'Spara i permanent cookie');
 define ('LABEL_DELETE_FIELD', 'Radera');
 define ('LABEL_USER_VARIABLES', 'Anv&auml;ndar-variabler');
 define ('LABEL_LISTED_VARIABLES', 'Listade variabler');
 define ('LABEL_REQUIRED_VARIABLES', 'Variabler som kr&auml;vs');
 define ('LABEL_VARIABLES_ACCEPT_HTML', 'Variabler som accepterar HTML');
 define ('LABEL_VARIABLES_COOKIE', 'Variabler s&auml;tts som permanent cookie');
 define ('LABEL_CONFIRM_DELETE_FIELD', 'Vill du ta bort detta f&auml;lt fr&aring;n beskrivningen av tabellen');
 define ('ALT_DELETE_FIELD', 'Ta bort f&auml;lt: %s');
 define ('ALT_ADD_FIELD', 'L&auml;gg till ett f&auml;lt');
 define ('ERROR_UNDEFINED_VARNAME', 'Var sn&auml;ll och ge ett namn p&aring; f&auml;ltet du vill l&auml;gga till');
 define ('ERROR_UNDEFINED_VARSIZE', 'Var sn&auml;ll och ange storlek/typ f&ouml;r f&auml;ltet du vill l&auml;gga till [xxx | int | text]');
 define ('ERROR_VARNAME_ALREADY_DEFINED', 'Detta f&auml;lt-namn anv&auml;nds redan');

 /////////////////////
 //edittemplate.php3
 /////////////////////
 define ('TITLE_EDITING_TEMPLATE', "Redigera mallar");
 define ('LABEL_DEFINE_DOCUMENT_GENERATION', "Definiera hur dokument ska genereras (fr&aring;n mallen):");
 define ('LABEL_STATIC', "<b>Statiskt</b><i> (en HTML-fil skapas n&auml;r ett inl&auml;gg postas) </i>");
 define ('LABEL_ONTHEFLY', "<b>Direkt</b><i> (ingen HTML-fil. Inl&auml;gget skapas dynamiskt n&auml;r anv&auml;ndaren tar fram det)</i>");
 define ('LABEL_NO_DOCUMENTS', "<b>Inget dokument</b><i> (enbart databasen listas)</i>");
 define ('LABEL_EDIT_TEMPLATE', "Redigera mall f&ouml;r dokument:");

 /////////////////////
 //editmail.php3
 /////////////////////
 define ('TITLE_EDITING_MAIL', "Redigera mall f&ouml;r email");
 define ('LABEL_OVERWRITE_MAIL_FILE', "Fil f&ouml;r email-mall (<font color=red>VARNING!</font> detta kommer att ers&auml;tta nuvarande fil)");
 define ('LABEL_SEND_OUT_EMAILS', "Emailets avs&auml;ndare (Fr&aring;n: rubrik)");
 define ('LABEL_USER_EMAIL', "Anv&auml;ndarens emailadress");
 define ('LABEL_THIS_EMAIL', "Denna emailadress");
 define ('LABEL_FIRST_RECIPIENT', "F&ouml;rsta mottagare (Till: rubrik)");
 define ('LABEL_RETURN_PATH', "Return-Path");
 define ('LABEL_REPLY_TO', "Svara-Till");
 define ('LABEL_NO_MAIL_SUBJECT', "&Auml;mne p&aring; email, om inl&auml;gget inte har ett &auml;mne");
 define ('LABEL_MAIL_SUBJECT', "&Auml;mne p&aring; email");
 define ('LABEL_MAIL_APPROVAL', "Email som skickas till moderatorer f&ouml;r godk&auml;nnande av inl&auml;gg (modererade forum)");
 define ('LABEL_MAIL_POSTED', "Email som skickas n&auml;r nytt inl&auml;gg postats");
 define ('LABEL_MAIL_MODIFIED', "Email som skickas n&auml;r inl&auml;gg &auml;ndrats");
 define ('LABEL_MAIL_BODY', "Text i emailet");
 define ('LABEL_MAIL_REGISTRATION', "Email som skickas till anv&auml;ndare som registrerats");
 define ('LABEL_MAIL_CONFIRM_REGISTRATION', "Email som skickas till anv&auml;ndare n&auml;r administrator redigerat profil");
 define ('LABEL_MAIL_USER_APPROVAL', "Email som skickas till moderatorer f&ouml;r godk&auml;nnande av anv&auml;ndare");
 define ('LABEL_MAIL_USER_MODIFICATION', "Email som skickas till moderatorer f&ouml;r &auml;ndring av anv&auml;ndares profil");
 define ('LABEL_MAIL_FORGOT_PASSWORD', "Email som skickas till anv&auml;ndare som gl&ouml;mt l&ouml;senordet");

 /////////////////////
 //delete_Forum.php3
 /////////////////////
 define ('TITLE_DELETE_FORUM', 'Radera forum');
 define ('TITLE_DELETE_FORUM_IN_SITE', 'Radera forum %s fr&aring;n sajten %s');

 define ('ERROR_MUST_BE_ADMIN_TO_REMOVE_FORUM', 'Du m&aring;ste vara inloggad som adminstrat&ouml;r f&ouml;r att kunna radera ett forum');
 define ('ERROR_NO_AVAILABLE_FORUM', 'Det finns inga forum i sajten %s,<br>');
 define ('ERROR_FORUM_DOESNT_EXIST', 'forum %s finns inte vid denna sajt');
 define ('ERROR_CANT_REMOVE_FORUM', 'Kunde inte ta bort forum %s fr&aring;n sajten %s');

 define ('LABEL_CHOOSE_FORUM_TO_DELETE', 'V&auml;lj det forum du vill ta bort fr&aring;n sajten %s');
 define ('LABEL_FORUM_DELETED', 'Forum %s har raderats');

 define ('CAPTION_DELETE_FORUM', '<B>&Auml;r du s&auml;ker p&aring; att du vill radera f&ouml;ljande forum</B>');
 define ('LABEL_FORUM_TITLE', '&auml;mne: ');
 define ('LABEL_FORUM_DESCR', 'Beskrivning: ');
 define ('LABEL_FORUM_OWNER', '&Auml;gare: ');
 define ('LABEL_FORUM_TYPE', 'Typ: ');
 define ('LABEL_FORUM_MODER', 'Modererad: ');
 define ('LABEL_FORUM_STATE', 'Status: ');
 define ('LABEL_DELETE_THIS_FORUM', 'Radera detta forum');
?>
