#
#  communicate.py - ghost-to-ghost communication mechanism
#  Copyright (C) 2002, 2003 by Shyouzou Sugitani <shy@debian.or.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
#  $Id: communicate.py,v 1.3 2003/07/25 01:31:14 shy Exp $
#

import os
import socket
import string
import fcntl

import ninix.home

class Communicate:
    def __init__(self):
        self.pid = os.getpid()
        self.ghosts = {}
    def rebuild_ghostdb(self, current):
        self.read_ghostdb(1, current)
    def read_ghostdb(self, rebuild=0, current=None):
        changed = 1
        self.ghosts = {}
        home_dir = ninix.home.get_ninix_home()
        path = os.path.join(home_dir, 'socket', 'ghost.db')
        if rebuild:
            if not os.path.exists(path):
                file = open(path, 'w+')
            else:
                file = open(path, 'r+')
            fcntl.lockf(file.fileno(), fcntl.LOCK_EX)
        else:
            file = open(path, 'r')
            fcntl.lockf(file.fileno(), fcntl.LOCK_SH)
        while 1:
            line = file.readline()
            if not line:
                break # EOF
            line = string.strip(line)
            if not line:
                continue
            pid, name, s0, s1 = string.split(line, ',')
            if pid == str(self.pid):
                try:
                    unicode(name)
                except:
                    changed = 1 
                else:
                    if current:
                        if name == current[0] and s0 == current[1] and s1 == current[2]:
                            changed = 0
            elif os.path.exists(os.path.join(home_dir, 'socket', pid)):
                try:
                    unicode(name)
                except:
                    pass
                else:
                    self.ghosts[pid] = (name, s0, s1)
            else:
                changed = 1
        if current:
            self.ghosts[self.pid] = current
        elif rebuild: # remove current ghost from DB
            changed = 1
        if rebuild and changed:
            file.seek(0,0)
            for key in self.ghosts.keys():
                file.write('%s,%s,%s,%s\n' % (key,
                                              self.ghosts[key][0],
                                              self.ghosts[key][1],
                                              self.ghosts[key][2],))
            file.truncate()
        fcntl.lockf(file.fileno(), fcntl.LOCK_UN)
        file.close()
    def directsstp_send(self, path, header):
        s = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
        try:
            s.connect(path)
        except socket.error, (code, message):
            ##sys.stderr.write(message + "\n")
            return None
        s.send(header)
        buffer = []
        while 1:
            try:
                data = s.recv(1024)
            except socket.error, (code, message):
                break
            if not data:
                break
            buffer.append(data)
        s.close()
        return string.join(buffer, '')
    def get_otherghostname(self):
        otherghostname = []
        self.read_ghostdb()
        for pid in self.ghosts.keys():
            if pid != self.pid:
                ghost = string.join(self.ghosts[pid], chr(1))
                otherghostname.append(ghost)
        return otherghostname
    def send_message(self, ghostname, header):
        self.read_ghostdb()
        response = None
        for key in self.ghosts.keys():
            if self.ghosts[key][0] == ghostname:
                home_dir = ninix.home.get_ninix_home()
                path = os.path.join(home_dir, 'socket')
                directsstp_path = os.path.join(path, key)
                response = self.directsstp_send(directsstp_path, header)
                break
        return response
