# -*- coding: EUC-JP -*-
# Tamito KAJIYAMA <24 June 2001>
# $Id: entry_db.py,v 1.2 2003/07/19 04:23:12 shy Exp $

import whrandom

class EntryDatabase:
    def __init__(self, db=None):
        self.db = db or {}
    def add(self, id, script):
        entries = self.db.get(id, [])
        entries.append(script)
        self.db[id] = entries
    def get(self, id, default=None):
        entries = self.db.get(id, [default])
        return whrandom.choice(entries)
    def is_empty(self):
        return not self.db

def test():
    entry_db = EntryDatabase()
    print "is_empty() =", entry_db.is_empty()
    entry_db.add("#temp0", "\hա\e")
    entry_db.add("#temp0", "\hʤΤ\e")
    entry_db.add("#temp0", "\hۤۤ\e")
    entry_db.add("#temp2", "\h͡\e")
    entry_db.add("#temp3", "\hʤۤɡ\e")
    for i in range(5):
        print "#temp0", entry_db.get("#temp0")
    for id in ["#temp1", "#temp2", "#temp3"]:
        print id, entry_db.get(id)
    print "is_empty() =", entry_db.is_empty()

if __name__ == "__main__":
    test()
