# -*- coding: EUC-JP -*-
# Tamito KAJIYAMA <6 November 2001>
# $Id: htmllib.py,v 1.2 2003/07/19 04:23:12 shy Exp $
# NOTE: This file contains Japanese characters (EUC-JP).

# HTML entity definitions
entitydefs = {
    # C0 Controls and Basic Latin
    "quot":	 '"',		# quotation mark
    "amp":	 "&",		# ampersand
    "lt":	 "<",		# less-than sign
    "gt":	 ">",		# greater-than sign
    # Latin Extended-A
    "OElig":	 "OE",		# latin capital ligature OE
    "oelig":	 "oe",		# latin small ligature oe
    "Scaron":	 "S",		# latin capital letter S with caron
    "scaron":	 "S",		# latin small letter s with caron
    "Yuml":	 "Y",		# latin capital letter Y with diaeresis
    # Spacing Modifier Letters
    "circ":	 "^",		# modifier letter circumflex accent
    "tilde":	 "~",		# small tilde
    # General Punctuation
    "ensp":	 None,		# en space
    "emsp":	 None,		# em space
    "thinsp":	 None,		# thin space
    "zwnj":	 None,		# zero width non-joiner
    "zwj":	 None,		# zero width joiner
    "lrm":	 None,		# left-to-right mark
    "rlm":	 None,		# right-to-left mark
    "ndash":	 "",		# en dash
    "mdash":	 "",		# em dash
    "lsquo":	 "",		# left single quotation mark
    "rsquo":	 "",		# right single quotation mark
    "sbquo":	 None,		# single low-9 quotation mark
    "ldquo":	 "",		# left double quotation mark
    "rdquo":	 "",		# right double quotation mark
    "bdquo":	 None,		# double low-9 quotation mark
    "dagger":	 "",		# dagger
    "Dagger":	 "",		# double dagger
    "permil":	 "",		# per mille sign
    "lsaquo":	 "",		# single left-pointing angle quotation mark
    "rsaquo":	 "",		# single right-pointing angle quotation mark
    "euro":	 None,		# euro sign
    # Latin-1
    "nbsp":	 None,		# no-break space = non-breaking space
    "iexcl":	 None,		# inverted exclamation mark
    "cent":	 "",		# cent sign
    "pound":	 "",		# pound sign
    "curren":	 None,		# currency sign
    "yen":	 "",		# yen sign = yuan sign
    "brvbar":	 None,		# broken bar = broken vertical bar
    "sect":	 "",		# section sign
    "uml":	 "",		# diaeresis = spacing diaeresis
    "copy":	 "(C)",		# copyright sign
    "ordf":	 None,		# feminine ordinal indicator
    "laquo":	 "",		# left-pointing double angle quotation mark
    "not":	 "",		# not sign
    "shy":	 None,		# soft hyphen = discretionary hyphen
    "reg":	 "(R)",		# registered sign = registered trade mark sign
    "macr":	 "",		# macron = overline
    "deg":	 "",		# degree sign
    "plusmn":	 "",		# plus-minus sign
    "sup2":	 None,		# superscript two
    "sup3":	 None,		# superscript three
    "acute":	 "",		# acute accent
    "micro":	 "",		# micro sign
    "para":	 "",		# pilcrow sign
    "middot":	 "",		# middle dot
    "cedil":	 None,		# cedilla
    "sup1":	 None,		# superscript one
    "ordm":	 None,		# masculine ordinal indicator
    "raquo":	 "",		# right-pointing double angle quotation mark
    "frac14":	 None,		# vulgar fraction one quarter
    "frac12":	 None,		# vulgar fraction one half
    "frac34":	 None,		# vulgar fraction three quarters
    "iquest":	 None,		# inverted question mark
    "Agrave":	 "A",		# latin capital letter A with grave
    "Aacute":	 "A",		# latin capital letter A with acute
    "Acirc":	 "A",		# latin capital letter A with circumflex
    "Atilde":	 "A",		# latin capital letter A with tilde
    "Auml":	 "A",		# latin capital letter A with diaeresis
    "Aring":	 "A",		# latin capital letter A with ring above
    "AElig":	 "AE",		# latin capital letter AE
    "Ccedil":	 "C",		# latin capital letter C with cedilla
    "Egrave":	 "E",		# latin capital letter E with grave
    "Eacute":	 "E",		# latin capital letter E with acute
    "Ecirc":	 "E",		# latin capital letter E with circumflex
    "Euml":	 "E",		# latin capital letter E with diaeresis
    "Igrave":	 "I",		# latin capital letter I with grave
    "Iacute":	 "I",		# latin capital letter I with acute
    "Icirc":	 "I",		# latin capital letter I with circumflex
    "Iuml":	 "I",		# latin capital letter I with diaeresis
    "ETH":	 None,		# latin capital letter ETH
    "Ntilde":	 "N",		# latin capital letter N with tilde
    "Ograve":	 "O",		# latin capital letter O with grave
    "Oacute":	 "O",		# latin capital letter O with acute
    "Ocirc":	 "O",		# latin capital letter O with circumflex
    "Otilde":	 "O",		# latin capital letter O with tilde
    "Ouml":	 "O",		# latin capital letter O with diaeresis
    "times":	 "",		# multiplication sign
    "Oslash":	 "O",		# latin capital letter O with stroke
    "Ugrave":	 "U",		# latin capital letter U with grave
    "Uacute":	 "U",		# latin capital letter U with acute
    "Ucirc":	 "U",		# latin capital letter U with circumflex
    "Uuml":	 "U",		# latin capital letter U with diaeresis
    "Yacute":	 "Y",		# latin capital letter Y with acute
    "THORN":	 None,		# latin capital letter THORN
    "szlig":	 None,		# latin small letter sharp s = ess-zed
    "agrave":	 "a",		# latin small letter a with grave
    "aacute":	 "a",		# latin small letter a with acute
    "acirc":	 "a",		# latin small letter a with circumflex
    "atilde":	 "a",		# latin small letter a with tilde
    "auml":	 "a",		# latin small letter a with diaeresis
    "aring":	 "a",		# latin small letter a with ring above
    "aelig":	 "ae",		# latin small letter ae
    "ccedil":	 "c",		# latin small letter c with cedilla
    "egrave":	 "e",		# latin small letter e with grave
    "eacute":	 "e",		# latin small letter e with acute
    "ecirc":	 "e",		# latin small letter e with circumflex
    "euml":	 "e",		# latin small letter e with diaeresis
    "igrave":	 "i",		# latin small letter i with grave
    "iacute":	 "i",		# latin small letter i with acute
    "icirc":	 "i",		# latin small letter i with circumflex
    "iuml":	 "i",		# latin small letter i with diaeresis
    "eth":	 None,		# latin small letter eth
    "ntilde":	 "n",		# latin small letter n with tilde
    "ograve":	 "o",		# latin small letter o with grave
    "oacute":	 "o",		# latin small letter o with acute
    "ocirc":	 "o",		# latin small letter o with circumflex
    "otilde":	 "o",		# latin small letter o with tilde
    "ouml":	 "o",		# latin small letter o with diaeresis
    "divide":	 "",		# division sign
    "oslash":	 "o",		# latin small letter o with stroke
    "ugrave":	 "u",		# latin small letter u with grave
    "uacute":	 "u",		# latin small letter u with acute
    "ucirc":	 "u",		# latin small letter u with circumflex
    "uuml":	 "u",		# latin small letter u with diaeresis
    "yacute":	 "y",		# latin small letter y with acute
    "thorn":	 None,		# latin small letter thorn with
    "yuml":	 "y",		# latin small letter y with diaeresis
    # Latin Extended-B
    "fnof":	 None,		# latin small f with hook
    # Greek
    "Alpha":	 "",		# greek capital letter alpha
    "Beta":	 "",		# greek capital letter beta
    "Gamma":	 "",		# greek capital letter gamma
    "Delta":	 "",		# greek capital letter delta
    "Epsilon":	 "",		# greek capital letter epsilon
    "Zeta":	 "",		# greek capital letter zeta
    "Eta":	 "",		# greek capital letter eta
    "Theta":	 "",		# greek capital letter theta
    "Iota":	 "",		# greek capital letter iota
    "Kappa":	 "",		# greek capital letter kappa
    "Lambda":	 "",		# greek capital letter lambda
    "Mu":	 "",		# greek capital letter mu
    "Nu":	 "",		# greek capital letter nu
    "Xi":	 "",		# greek capital letter xi
    "Omicron":	 "",		# greek capital letter omicron
    "Pi":	 "",		# greek capital letter pi
    "Rho":	 "",		# greek capital letter rho
    "Sigma":	 "",		# greek capital letter sigma
    "Tau":	 "",		# greek capital letter tau
    "Upsilon":	 "",		# greek capital letter upsilon
    "Phi":	 "",		# greek capital letter phi
    "Chi":	 "",		# greek capital letter chi
    "Psi":	 "",		# greek capital letter psi
    "Omega":	 "",		# greek capital letter omega
    "alpha":	 "",		# greek small letter alpha
    "beta":	 "",		# greek small letter beta
    "gamma":	 "",		# greek small letter gamma
    "delta":	 "",		# greek small letter delta
    "epsilon":	 "",		# greek small letter epsilon
    "zeta":	 "",		# greek small letter zeta
    "eta":	 "",		# greek small letter eta
    "theta":	 "",		# greek small letter theta
    "iota":	 "",		# greek small letter iota
    "kappa":	 "",		# greek small letter kappa
    "lambda":	 "",		# greek small letter lambda
    "mu":	 "",		# greek small letter mu
    "nu":	 "",		# greek small letter nu
    "xi":	 "",		# greek small letter xi
    "omicron":	 "",		# greek small letter omicron
    "pi":	 "",		# greek small letter pi
    "rho":	 "",		# greek small letter rho
    "sigmaf":	 None,		# greek small letter final sigma
    "sigma":	 "",		# greek small letter sigma
    "tau":	 "",		# greek small letter tau
    "upsilon":	 "",		# greek small letter upsilon
    "phi":	 "",		# greek small letter phi
    "chi":	 "",		# greek small letter chi
    "psi":	 "",		# greek small letter psi
    "omega":	 "",		# greek small letter omega
    "thetasym":	 None,		# greek small letter theta symbol
    "upsih":	 None,		# greek upsilon with hook symbol
    "piv":	 None,		# greek pi symbol
    # General Punctuation
    "bull":	 "",		# bullet = black small circle
    "hellip":	 "",		# horizontal ellipsis = three dot leader
    "prime":	 "",		# prime = minutes = feet
    "Prime":	 "",		# double prime = seconds = inches
    "oline":	 "",		# overline = spacing overscore
    "frasl":	 "/",		# fraction slash
    # Letterlike Symbols
    "weierp":	 None,		# script capital P = power set
    "image":	 None,		# blackletter capital I = imaginary part
    "real":	 None,		# blackletter capital R = real part symbol
    "trade":	 None,		# trade mark sign
    "alefsym":	 None,		# alef symbol = first transfinite cardinal
    # Arrows
    "larr":	 "",		# leftwards arrow
    "uarr":	 "",		# upwards arrow
    "rarr":	 "",		# rightwards arrow
    "darr":	 "",		# downwards arrow
    "harr":	 None,		# left right arrow
    "crarr":	 None,		# downwards arrow with corner leftwards
    "lArr":	 None,		# leftwards double arrow
    "uArr":	 None,		# upwards double arrow
    "rArr":	 "",		# rightwards double arrow
    "dArr":	 None,		# downwards double arrow
    "hArr":	 "",		# left right double arrow
    # Mathematical Operators
    "forall":	 "",		# for all
    "part":	 "",		# partial differential
    "exist":	 "",		# there exists
    "empty":	 None,		# empty set = null set = diameter
    "nabla":	 "",		# nabla = backward difference
    "isin":	 "",		# element of
    "notin":	 None,		# not an element of
    "ni":	 "",		# contains as member
    "prod":	 "",		# n-ary product = product sign
    "sum":	 "",		# n-ary sumation
    "minus":	 "-",		# minus sign
    "lowast":	 "*",		# asterisk operator
    "radic":	 "",		# square root = radical sign
    "prop":	 "",		# proportional to
    "infin":	 "",		# infinity
    "ang":	 "",		# angle
    "and":	 "",		# logical and = wedge
    "or":	 "",		# logical or = vee
    "cap":	 "",		# intersection = cap
    "cup":	 "",		# union = cup
    "int":	 "",		# integral
    "there4":	 "",		# therefore
    "sim":	 "",		# tilde operator = varies with = similar to
    "cong":	 "",		# approximately equal to
    "asymp":	 None,		# almost equal to = asymptotic to
    "ne":	 "",		# not equal to
    "equiv":	 "",		# identical to
    "le":	 "",		# less-than or equal to
    "ge":	 "",		# greater-than or equal to
    "sub":	 "",		# subset of
    "sup":	 "",		# superset of
    "nsub":	 None,		# not a subset of
    "sube":	 "",		# subset of or equal to
    "supe":	 "",		# superset of or equal to
    "oplus":	 None,		# circled plus = direct sum
    "otimes":	 None,		# circled times = vector product
    "perp":	 "",		# up tack = orthogonal to = perpendicular
    "sdot":	 "",		# dot operator
    # Miscellaneous Technical
    "lceil":	 None,		# left ceiling = apl upstile
    "rceil":	 None,		# right ceiling
    "lfloor":	 None,		# left floor = apl downstile
    "rfloor":	 None,		# right floor
    "lang":	 "",		# left-pointing angle bracket = bra
    "rang":	 "",		# right-pointing angle bracket = ket
    # Geometric Shapes
    "loz":	 None,		# lozenge
    # Miscellaneous Symbols
    "spades":	 None,		# black spade suit
    "clubs":	 None,		# black club suit = shamrock
    "hearts":	 None,		# black heart suit = valentine
    "diams":	 None,		# black diamond suit
}
