# Tamito KAJIYAMA <5 October 2001>
# $Id: update.py,v 1.5 2003/07/18 10:26:04 shy Exp $

import urlparse
import string
import StringIO
import os
import md5
import time

import ninix.httplib

class NetworkUpdate:
    __BACKUP_SUFFIX = ".BACKUP"
    def __init__(self, sakura):
        self.sakura = sakura
        self.event_queue = []
        self.state = None
        self.backups = []
        self.newfiles = []
        self.newdirs = []
    def is_active(self):
        return self.state is not None
    def enqueue_event(self, event,
                      ref0=None, ref1=None, ref2=None, ref3=None,
                      ref4=None, ref5=None, ref6=None, ref7=None):
        self.event_queue.append(
            (event, ref0, ref1, ref2, ref3, ref4, ref5, ref6, ref7))
    def get_event(self):
        if not self.event_queue:
            return None
        return self.event_queue.pop(0)
    def has_events(self):
        return len(self.event_queue) > 0
    def start(self, homeurl, ghostdir, timeout=60):
        url = urlparse.urlparse(homeurl)
        if not (url[0] == "http" and url[3] == url[4] == url[5] == ''):
            self.enqueue_event("OnUpdateFailure", "bad home URL")
            self.state = None
            return            
        try:
            self.host, port = string.split(url[1], ":")
            self.port = int(port)
        except ValueError:
            self.host = url[1]
            self.port = 80
        self.path = url[2]
        self.ghostdir = ghostdir
        self.timeout = timeout
        self.state = 0
    def interrupt(self):
        self.event_queue = []
        if self.sakura:
            self.sakura.enqueue_event("OnUpdateFailure", "artificial")
        self.state = None
        self.stop(revert=1)
    def stop(self, revert=0):
        self.buffer = []
        if revert:
            for path in self.backups:
                if os.path.isfile(path):
                    os.rename(path, path[:-len(self.__BACKUP_SUFFIX)])
            for path in self.newfiles:
                if os.path.isfile(path):
                    os.remove(path)
            for path in self.newdirs:
                if os.path.isdir(path):
                    os.rmdir(path)
        else:
            for path in self.backups:
                if os.path.isfile(path):
                    os.remove(path)
        self.backups = []
        self.newfiles = []
        self.newdirs = []
    def reset_timeout(self):
        self.timestamp = time.time()
    def check_timeout(self):
        return time.time() - self.timestamp > self.timeout
    def run(self):
        if self.state is None or (self.sakura and self.sakura.event_queue):
            return 0
        elif self.state == 0:
            self.start_updates()
        elif self.state == 1:
            self.lookup()
        elif self.state == 2:
            self.connect()
        elif self.state == 3:
            self.send_request()
        elif self.state == 4:
            self.wait_response()
        elif self.state == 5:
            self.get_content()
        elif self.state == 6:
            self.schedule = self.make_schedule()
            if self.schedule is None:
                return 0
            self.final_state = len(self.schedule) * 7 + 7
        elif self.state == self.final_state:
            self.end_updates()
        elif (self.state - 7) % 7 == 0:
            filename, checksum = self.schedule[0]
            self.download(os.path.join(self.path, filename), event=1)
        elif (self.state - 7) % 7 == 1:
            self.lookup()
        elif (self.state - 7) % 7 == 2:
            self.connect()
        elif (self.state - 7) % 7 == 3:
            self.send_request()
        elif (self.state - 7) % 7 == 4:
            self.wait_response()
        elif (self.state - 7) % 7 == 5:
            self.get_content()
        elif (self.state - 7) % 7 == 6:
            filename, checksum = self.schedule.pop(0)
            self.update_file(filename, checksum)
        return 1
    def start_updates(self):
        self.download(os.path.join(self.path, "updates2.dau"))
        self.enqueue_event("OnUpdateBegin")
    def download(self, locator, event=0):
        self.locator = self.encode(locator)
        self.http = ninix.httplib.HTTP(self.host, self.port)
        if event:
            self.enqueue_event("OnUpdate.OnDownloadBegin",
                               os.path.basename(locator),
                               self.file_number, self.num_files)
        self.state = self.state + 1
        self.reset_timeout()
    def encode(self, path):
        return string.join(map(self.encode_special, path), "")
    def encode_special(self, c):
        if "\x20" < c < "\x7e":
            return c
        return "%%%02x" % ord(c)
    def lookup(self):
        code = self.http.lookup()
        if code > 0:
            if self.check_timeout():
                self.enqueue_event("OnUpdateFailure", "timeout")
                self.state = None
                self.stop(revert=1)
            return
        elif code < 0:
            self.enqueue_event("OnUpdateFailure", "lookup failed")
            self.state = None
            self.stop(revert=1)
            return
        self.state = self.state + 1
        self.reset_timeout()
    def connect(self):
        code = self.http.connect()
        if code > 0:
            if self.check_timeout():
                self.enqueue_event("OnUpdateFailure", "timeout")
                self.state = None
                self.stop(revert=1)
            return
        elif code < 0:
            self.enqueue_event("OnUpdateFailure", "connection failed")
            self.state = None
            self.stop(revert=1)
            return
        self.http.put_request("GET", self.locator)
        self.state = self.state + 1
        self.reset_timeout()
    def send_request(self):
        code = self.http.send_request()
        if code > 0:
            if self.check_timeout():
                self.enqueue_event("OnUpdateFailure", "timeout")
                self.state = None
                self.stop(revert=1)
            return
        elif code < 0:
            self.enqueue_event("OnUpdateFailure", "request failed")
            self.state = None
            self.stop(revert=1)
            return
        self.state = self.state + 1
        self.reset_timeout()
    def wait_response(self):
        code = self.http.wait_response()
        if code > 0:
            if self.check_timeout():
                self.enqueue_event("OnUpdateFailure", "timeout")
                self.state = None
                self.stop(revert=1)
            return
        elif code < 0:
            self.enqueue_event("OnUpdateFailure", "no HTTP response")
            self.state = None
            self.stop(revert=1)
            return
        code, message, headers = self.http.get_reply()
        if code == 200:
            pass
        elif code == 302 and self.redirect(headers):
            return
        elif self.state == 4: # updates2.dau
            self.enqueue_event("OnUpdateFailure", str(code))
            self.state = None
            return
        else:
            filename, checksum = self.schedule.pop(0)
            print "failed to download %s (%d %s)" % (filename, code, message)
            self.file_number = self.file_number + 1
            self.state = self.state + 3
            return
        self.buffer = []
        size = headers.get("content-length", None)
        if size is None:
            self.size = None
        else:
            self.size = int(size)
        self.state = self.state + 1
        self.reset_timeout()
    def redirect(self, headers):
        location = headers.get("location", None)
        if location is None:
            return 0
        url = urlparse.urlparse(location)
        if not (url[0] == "http" and url[3] == url[4] == url[5] == ''):
            return 0
        print "redirected to", location
        self.http.close()
        try:
            self.host, port = string.split(url[1], ":")
            self.port = int(port)
        except ValueError:
            self.host = url[1]
            self.port = 80
        self.path = os.path.dirname(url[2])
        self.state = self.state - 4
        self.download(url[2])
        return 1
    def get_content(self):
        data = self.http.recv(65536)
        if not data:
            if self.check_timeout():
                self.enqueue_event("OnUpdateFailure", "timeout")
                self.state = None
                self.stop(revert=1)
                return
            elif data is None:
                return
        elif data < 0:
            self.enqueue_event("OnUpdateFailure", "data retrieval failed")
            self.state = None
            self.stop(revert=1)
            return
        if data:
            self.buffer.append(data)
            if self.size is not None:
                self.size = self.size - len(data)
            self.reset_timeout()
            return
        if self.size is not None and self.size > 0:
            return
        self.http.close()
        self.state = self.state + 1
    def make_checksum(self, digest):
        return string.join(map(lambda x: "%02x" % ord(x), digest), '')
    ROOT_FILES = ["install.txt", "delete.txt", "readme.txt", "thumbnail.png"]
    def adjust_path(self, filename):
        filename = string.lower(filename)
        if filename in self.ROOT_FILES or os.path.dirname(filename):
            return filename
        return os.path.join("ghost", "master", filename)
    def make_schedule(self):
        schedule = self.parse_updates2_dau()
        if schedule is not None:
            self.num_files = len(schedule) - 1
            self.file_number = 0
            if self.num_files >= 0:
                self.enqueue_event("OnUpdateReady", self.num_files)
            self.state = self.state + 1
        return schedule
    def parse_updates2_dau(self):
        schedule = []
        file = StringIO.StringIO(string.join(self.buffer, ''))
        for line in file.readlines():
            try:
                filename, checksum, newline = string.split(line, "\001", 2)
            except ValueError:
                self.enqueue_event("OnUpdateFailure", "broken updates2.dau")
                self.state = None
                return None
            if not filename:
                continue
            path = os.path.join(self.ghostdir, self.adjust_path(filename))
            try:
                data = open(path).read()
            except IOError:
                pass
            else:
                m = md5.new()
                m.update(data)
                if checksum == self.make_checksum(m.digest()):
                    continue
            schedule.append((filename, checksum))
        self.updated_files = []
        return schedule
    def update_file(self, filename, checksum):
        data = string.join(self.buffer, '')
        m = md5.new()
        m.update(data)
        digest = self.make_checksum(m.digest())
        if digest == checksum:
            path = os.path.join(self.ghostdir, self.adjust_path(filename))
            subdir = os.path.dirname(path)
            if not os.path.exists(subdir):
                subroot = subdir
                while 1:
                    head, tail = os.path.split(subroot)
                    if os.path.exists(head):
                        break
                    else:
                        subroot = head
                self.newdirs.append(subroot)
                try:
                    os.makedirs(subdir)
                except OSError:
                    self.enqueue_event(
                        "OnUpdateFailure", "can't mkdir " + subdir)
                    self.state = None
                    self.stop(revert=1)
                    return
            if os.path.exists(path):
                if os.path.isfile(path):
                    backup = path + self.__BACKUP_SUFFIX
                    os.rename(path, backup)
                    self.backups.append(backup)
            else:
                self.newfiles.append(path)
            try:
                open(path, "w").write(data)
            except IOError:
                self.enqueue_event(
                    "OnUpdateFailure", "can't write " + os.path.basename(path))
                self.state = None
                self.stop(revert=1)
                return
            self.updated_files.append(filename)
            event = "OnUpdate.OnMD5CompareComplete"
        else:
            event = "OnUpdate.OnMD5CompareFailure"
            self.enqueue_event(event, filename, checksum, digest)
            self.state = None
            self.stop(revert=1)
            return
        self.enqueue_event(event, filename, checksum, digest)
        self.file_number = self.file_number + 1
        self.state = self.state + 1
    def end_updates(self):
        filelist = self.parse_delete_txt()
        if filelist:
            for filename in filelist:
                path = os.path.join(self.ghostdir, filename)
                if os.path.exists(path) and os.path.isfile(path):
                    try:
                        os.unlink(path)
                        print "deleted", path
                    except OSError, e:
                        print e
        list = string.join(self.updated_files, ',')
        if not list:
            self.enqueue_event("OnUpdateComplete", "none")
        else:
            self.enqueue_event("OnUpdateComplete", "changed", list)
        self.state = None
        self.stop()
    def parse_delete_txt(self):
        filelist = []
        try:
            file = open(os.path.join(self.ghostdir, "delete.txt"))
        except IOError:
            return None
        error = None
        while 1:
            line = file.readline()
            if not line:
                break
            line = string.strip(line)
            if not line:
                continue
            filename = line
            filelist.append(string.lower(string.replace(filename, "\\", "/")))
        if error is not None:
            print error
            return None
        return filelist

def test():
    import sys
    if len(sys.argv) != 3:
        sys.stderr.write("Usage: update.py homeurl ghostdir\n")
        sys.exit(1)
    update = NetworkUpdate(None)
    update.start(sys.argv[1], sys.argv[2], timeout=60)
    while 1:
        state = update.state
        s = time.time()
        code = update.run()
        e = time.time()
        delta = e - s
        if delta > 0.1:
            print "Warning: state = %d (%f sec)" % (state, delta)
        while 1:
            event = update.get_event()
            if not event:
                break
            print event
        if code == 0:
            break
        if update.state == 7 and update.schedule:
            print "File(s) to be update:"
            for filename, checksum in update.schedule:
                print "   ", filename
    update.stop()

if __name__ == "__main__":
    test()
