/*
 * Copyright 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <sys/cdefs.h>

#include <jni.h>

__BEGIN_DECLS

//
// Classes in constants cache.
//
// NB The implementations of these methods are generated by the JCLASS_ACCESSOR_IMPL macro in
// JniConstants.c.
//
jclass JniConstants_FileDescriptorClass(JNIEnv* env);
jclass JniConstants_NIOAccessClass(JNIEnv* env);
jclass JniConstants_NioBufferClass(JNIEnv* env);

//
// Methods in the constants cache.
//
// NB The implementations of these methods are generated by the JMETHODID_ACCESSOR_IMPL macro in
// JniConstants.c.
//
jmethodID JniConstants_FileDescriptor_init(JNIEnv* env);
jmethodID JniConstants_NIOAccess_getBaseArray(JNIEnv* env);
jmethodID JniConstants_NIOAccess_getBaseArrayOffset(JNIEnv* env);
jmethodID JniConstants_NioBuffer_array(JNIEnv* env);
jmethodID JniConstants_NioBuffer_arrayOffset(JNIEnv* env);

//
// Fields in the constants cache.
//
// NB The implementations of these methods are generated by the JFIELDID_ACCESSOR_IMPL macro in
// JniConstants.c.
//
jfieldID JniConstants_FileDescriptor_descriptor(JNIEnv* env);
jfieldID JniConstants_NioBuffer_address(JNIEnv* env);
jfieldID JniConstants_NioBuffer__elementSizeShift(JNIEnv* env);
jfieldID JniConstants_NioBuffer_limit(JNIEnv* env);
jfieldID JniConstants_NioBuffer_position(JNIEnv* env);

__END_DECLS
