/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class FileEditorDisplay
extends JTextPane {
    private byte[] pngContent = null;
    private String filename;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEditorDisplay(String filename) {
        this.filename = filename;
        this.initStylesForTextPane();
        String text = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    text = text.concat(line + "\n");
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("Cannot read file: " + filename);
        }
        if (filename.endsWith(".html")) {
            this.setText(text, "html");
        } else if (filename.toLowerCase().endsWith(".png") || filename.toLowerCase().endsWith(".gif") || filename.toLowerCase().endsWith(".jpeg") || filename.endsWith(".tif")) {
            this.setText(text, "png");
        } else if (filename.toLowerCase().endsWith(".z") || filename.toLowerCase().endsWith(".gz") || filename.toLowerCase().endsWith(".zip") || filename.toLowerCase().endsWith(".tar") || filename.toLowerCase().endsWith(".ppt") || filename.toLowerCase().endsWith(".doc") || filename.toLowerCase().endsWith(".ps")) {
            this.setText("Jemboss Cannot display " + filename, "regular");
        } else {
            this.setText(text, "regular");
        }
    }

    public FileEditorDisplay(String filename, Object contents) {
        this.filename = filename;
        this.initStylesForTextPane();
        if (contents.getClass().equals(String.class)) {
            if (!filename.endsWith(".html")) {
                this.setText((String)contents, "regular");
            } else {
                this.setText((String)contents, "html");
            }
        } else if (filename.toLowerCase().endsWith(".png") || filename.toLowerCase().endsWith(".gif") || filename.toLowerCase().endsWith(".jpeg") || filename.endsWith(".tif")) {
            ImageIcon icon = new ImageIcon((byte[])contents);
            this.insertIcon(icon);
            this.pngContent = (byte[])contents;
        } else if (filename.toLowerCase().endsWith(".z") || filename.toLowerCase().endsWith(".gz") || filename.toLowerCase().endsWith(".zip") || filename.toLowerCase().endsWith(".tar") || filename.toLowerCase().endsWith(".ppt") || filename.toLowerCase().endsWith(".doc") || filename.toLowerCase().endsWith(".ps")) {
            this.setText("Jemboss Cannot display " + filename, "regular");
        } else {
            try {
                this.setText(new String((byte[])contents), "regular");
            }
            catch (Exception exp) {
                this.setText("Cannot display " + filename, "regular");
            }
        }
    }

    public void setSize(Dimension d) {
        if (d.width < this.getParent().getSize().width) {
            d.width = this.getParent().getSize().width;
        }
        super.setSize(d);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public void setText(String text, String type) {
        DefaultStyledDocument doc = new DefaultStyledDocument();
        if (type.equalsIgnoreCase("regular")) {
            try {
                doc.insertString(0, text, this.getStyle("regular"));
            }
            catch (BadLocationException ble) {
                System.err.println("Couldn't insert initial text.");
            }
        } else if (type.equalsIgnoreCase("sequence")) {
            try {
                String hdr = this.findHeader(text);
                doc.insertString(doc.getLength(), hdr, this.getStyle("bold"));
                for (int i = hdr.length(); i < text.length(); ++i) {
                    String rescol = new String("darkGray ");
                    if (text.substring(i, i + 1).equalsIgnoreCase("A")) {
                        rescol = "green";
                    } else if (text.substring(i, i + 1).equalsIgnoreCase("T")) {
                        rescol = "red";
                    } else if (text.substring(i, i + 1).equalsIgnoreCase("G")) {
                        rescol = "black";
                    } else if (text.substring(i, i + 1).equalsIgnoreCase("C")) {
                        rescol = "blue";
                    }
                    doc.insertString(doc.getLength(), text.substring(i, i + 1), this.getStyle(rescol));
                }
            }
            catch (BadLocationException ble) {
                System.err.println("Couldn't insert initial text.");
            }
        } else if (type.equalsIgnoreCase("png")) {
            ImageIcon icon = new ImageIcon(this.filename, this.filename);
            this.insertIcon(icon);
            this.pngContent = this.loadPNGContent(this.filename);
        } else if (type.equalsIgnoreCase("html")) {
            this.setContentType("text/html");
            this.setText(text);
            this.setEditable(false);
        }
        this.setDocument(doc);
    }

    private byte[] loadPNGContent(String filename) {
        int nby = 0;
        byte[] data = new byte[1];
        try {
            FileInputStream fis = new FileInputStream(filename);
            DataInputStream dis = new DataInputStream(fis);
            while (true) {
                dis.readByte();
                ++nby;
            }
        }
        catch (EOFException eof) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (nby > 0) {
            try {
                data = new byte[nby];
                FileInputStream fis = new FileInputStream(filename);
                DataInputStream dis = new DataInputStream(fis);
                nby = 0;
                while (true) {
                    data[nby] = dis.readByte();
                    ++nby;
                }
            }
            catch (EOFException eof) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return data;
    }

    public byte[] getPNGContent() {
        return this.pngContent;
    }

    protected void initStylesForTextPane() {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = this.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "monospaced");
        Style s = this.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = this.addStyle("bold", regular);
        StyleConstants.setBold(s, true);
        s = this.addStyle("small", regular);
        StyleConstants.setFontSize(s, 10);
        s = this.addStyle("large", regular);
        StyleConstants.setFontSize(s, 16);
        s = this.addStyle("red", regular);
        StyleConstants.setForeground(s, Color.red);
        StyleConstants.setBold(s, true);
        StyleConstants.setFontFamily(def, "monospaced");
        s = this.addStyle("green", regular);
        StyleConstants.setForeground(s, Color.green);
        StyleConstants.setBold(s, true);
        StyleConstants.setFontFamily(def, "monospaced");
        s = this.addStyle("blue", regular);
        StyleConstants.setForeground(s, Color.blue);
        StyleConstants.setBold(s, true);
        StyleConstants.setFontFamily(def, "monospaced");
        s = this.addStyle("orange", regular);
        StyleConstants.setForeground(s, Color.orange);
        StyleConstants.setBold(s, true);
        StyleConstants.setFontFamily(def, "monospaced");
        s = this.addStyle("black", regular);
        StyleConstants.setForeground(s, Color.black);
        StyleConstants.setBold(s, true);
        StyleConstants.setFontFamily(def, "monospaced");
        s = this.addStyle("darkGray", regular);
        StyleConstants.setForeground(s, Color.darkGray);
        StyleConstants.setBold(s, true);
        StyleConstants.setFontFamily(def, "monospaced");
        s = this.addStyle("icon", regular);
        StyleConstants.setAlignment(s, 1);
    }

    private String findHeader(String text) {
        String hdr;
        block4: {
            hdr = "";
            String tmphdr = "";
            BufferedReader in = new BufferedReader(new StringReader(text));
            try {
                String line = in.readLine();
                if (line.startsWith(">")) {
                    hdr = line;
                    break block4;
                }
                tmphdr = line;
                while ((line = in.readLine()) != null) {
                    tmphdr = tmphdr.concat("\n" + line);
                    if (!line.equals("//") && !line.startsWith("SQ ") && !line.endsWith("..")) continue;
                    hdr = tmphdr;
                    break;
                }
            }
            catch (IOException ioe) {
                System.out.println("Cannot read " + text);
            }
        }
        return hdr;
    }
}

