# frozen_string_literal: true

class CreateVulnerabilityRepresentationInformation < Gitlab::Database::Migration[2.2]
  milestone '17.6'

  # rubocop:disable Migration/EnsureFactoryForTable -- False Positive
  def change
    create_table :vulnerability_representation_information, id: false do |t|
      t.timestamps_with_timezone null: false
      t.bigint :vulnerability_id, null: false, primary_key: true, default: nil
      t.bigint :project_id, null: false
      t.binary :resolved_in_commit_sha
    end
    add_index :vulnerability_representation_information, :project_id, name: 'index_vuln_rep_info_on_project_id'
  end
  # rubocop:enable Migration/EnsureFactoryForTable -- False Positive
end
