package CType::Builtin;

use 5.6.0;
use strict;
use warnings;

use CType;

our @ISA = qw/CType/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $name = shift;

    my $self = {name => $name,
               };
    bless $self, $class;
    return $self
  }

sub name
  {
    my $self = shift;
    return $self->{name};
  }

sub layout
  {
  }

my @builtins = qw/__builtin_va_list/;

sub register_builtins
  {
    my $namespace = shift;
    $namespace->set('ordinary', $_, new CType::Builtin $_) foreach @builtins;
  }

sub describe
  {
    my $self = shift;

    return "builtin $self->{name}";
  }

sub dump_c
  {
    my $self = shift;
    my $skip_cpp = shift;

    my $str = '';
    $str .= $self->{name};
    return $str;
  }

sub get_refs
  {
    return ();
  }

sub _check_interface
  {
    my $self = shift;
    my $other = shift;

    return 'both' unless $other->isa('CType::Builtin');
    return 'both' unless $other->name eq $self->name;
    return 'ok';
  }

1;
